<?php
    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");
    
    //Parametros obligatorios
    $parmsob = array("sessionid",'offset','numofrecords');
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    // Declaracion e inicializacion de variables
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    $offset = $_GET['offset'];
    $numofrecords = $_GET['numofrecords'];
    $order = '';
    $filter = '';
    $date = '';
    $module = '';
    $userid = '';
    
    //Verificamos que la sesion no este expirada
    isSessionValid($db, $sessionid);
    
    // SI recibimos el filter, armamos el query
    if(isset($_GET['filter']) && $_GET['filter']){
        $filter = " AND (".
        "       cmsusers.name LIKE '%".$_GET['filter']."%'".
        "       OR cmsusers.email LIKE '%".$_GET['filter']."%'".
        "       OR audit.dsc LIKE '%".$_GET['filter']."%'".
        "       OR audit.module LIKE '%".$_GET['filter']."%'".
        "       )";
    }
    
    // SI recibimos el order, armamos el query
    if(isset($_GET['order']) && $_GET['order']){
        $order = " ORDER BY ".$_GET['order'];
    }
    
    // SI recibimos el date, armamos el query
    if(isset($_GET['date']) && $_GET['date']){
        $date = determinateDate($_GET['date']);
    }
    
    // SI recibimos el filter, armamos el query
    if(isset($_GET['module']) && $_GET['module']){
        $module = " AND audit.module = '".$_GET['module']."'";
    }
    
    // SI recibimos el userid, armamos el query
    if(isset($_GET['userid']) && $_GET['userid']){
        $userid = " AND cmsusers.id = ".$_GET['userid'];
    }
    
    // Consultamos la cantidad de registros
    $sql = "SELECT COUNT(audit.id) AS qty ".
    "       FROM audit, cmsusers ".
    "       WHERE audit.userid = cmsusers.id ".
    "       ".$filter.
    "       ".$module.
    "       ".$userid.
    "       ".$date;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    $row = $rs->fetch_assoc();
    
    //Guardamos el total de alumnos existentes
    $out->numofrecords = (int)$row["qty"];
    
    // Consultamos a detalle la auditorio
    $sql = "SELECT audit.id AS id, ".
    "       audit.dsc AS dsc, ".
    "       audit.date AS date, ".
    "       audit.module AS module, ".
    "       cmsusers.id AS userid, ".
    "       cmsusers.name AS username ".
    "       FROM audit, cmsusers ".
    "       WHERE audit.userid = cmsusers.id".
    "       ".$filter.
    "       ".$module.
    "       ".$userid.
    "       ".$date.
    "       ".$order.
    "       LIMIT ".$offset.", ".$numofrecords;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    while($row = $rs->fetch_assoc()){
        $record = new stdClass();
        
        $record->id = (int)$row['id'];
        $record->module = $row['module'];
        
        $record->user = new stdClass();
        $record->user->id = (int)$row['userid'];
        $record->user->name = $row['username'];
        
        $record->date = new stdClass();
        $record->date->date = date("Y-m-d H:i", strtotime($row['date']));
        $record->date->formatted = date("d-m-Y h:ia", strtotime($row['date']));
        
        $record->dsc = $row['dsc'];
        
        $records [] = $record;
    }
    
    $out->records = $records;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    /**/
    function determinateDate($date){
        $str = "";
        
        switch($date){
            case 1:
                $str = " AND audit.date >= DATE( DATE_ADD(NOW(), INTERVAL -1 DAY) )";
                break;
            case 2:
                $str = " AND audit.date >= DATE( DATE_ADD(NOW(), INTERVAL -7 DAY))";
                break;
            case 3:
                $str = " AND audit.date >= DATE( DATE_ADD(NOW(), INTERVAL -30 DAY))";
                break;
            case 4:
                $str = " AND audit.date >= DATE( DATE_ADD(NOW(), INTERVAL -90 DAY))";
                break;
            case 5:
                $str = " AND audit.date >= DATE( DATE_ADD(NOW(), INTERVAL -6 MONTH))";
                break;
        }
        
        return $str;
    }
?>