<?php
    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");
    
    //Parametros obligatorios
    $parmsob = array("sessionid");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    // Declaracion e inicializacion de variables
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    
    //Verificamos que la sesion no este expirada
    isSessionValid($db, $sessionid);
    
    //Consultamos la cantidad de registros
    $sql = "SELECT COUNT(DISTINCT module) AS qty".
    "       FROM audit ".
    "       ORDER BY module ASC ";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row = $rs->fetch_assoc();
    
    $out->numofrecords = (int)$row["qty"];
    
    //Consultamos los modulos
    $sql = "SELECT DISTINCT module ".
    "       FROM audit ".
    "       ORDER BY module ASC ";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    while($row = $rs->fetch_assoc()){
        $record = new stdClass();
        $record->dsc = $row['module'];
        
        $records [] = $record;
    }
    
    $out->records = $records;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>