<?php

    include("./connection.php");
    include("./utils.php");

    $dir_root = "/home/ormv/public_html/prd/cms/uploads";
    $dir_new = $dir_root . "/new";
    $dir_ok = $dir_root . "/assigned";
    $dir_err = $dir_root . "/err";
    
    $pointSetted = 0;

    readTests($dir_new);
    //print_r(processTest("10328_6964.jpg"));
    //print_r(readTest($dir_err."/EM Mons Lucas G Castillo 3_000002_pupil_not_found.jpg"));

    function readTests($path){
        global $pointSetted;
        $dir = opendir($path);
        $cnt = 0;
        while (($filename = readdir($dir)) && $cnt < 50){
            if (substr($filename, 0, 1) != "."){
                echo ("<br/>Procesando: " . $filename);
                $pointSetted = 0;
                processTest($filename);
                $cnt ++;
            }
        }
    }

    function processTest($filename){
        global $db;
        global $dir_new;
        global $pointSetted;
        $ext = substr($filename, 0, -2);

        $input_path = $dir_new . "/" . $filename;
        $result = readTest($input_path);
        if ($result["rsp"] == "OK"){
            $test = $result["test"];
            // buscar si tiene respuestas
            $sql =  "SELECT     1 " .
                    "FROM       answers A " .
                    "WHERE      pupilid = " . substr($test["code"], 0, -2);
            if (!$rs=$db->query($sql))
                die($db->error);
            if ($row = $rs->fetch_assoc()){
                // ya existe
                sendToErr($filename, "already_exist");
                return ($result);
                return (false);
            }else{
                // verificar numero de preguntas
                $sql =  "SELECT     T.id, T.numofquestions noq " .
                        "FROM       pupils P " .
                        "INNER JOIN tests T " .
                        "ON         P.level = T.level " .
                        "WHERE      P.id= " . substr($test["code"], 0, -2);
                if (!$rs=$db->query($sql))
                    die($db->error);
                $row = $rs->fetch_assoc();
                $tid = (integer) $row["id"];
                $noq = (integer) $row["noq"];
                // incluir respuesta
                $val = "(" . substr($test["code"], 0, -2) . ",'" . substr($input_path, -3) . "'," . $tid;
                $sql =  "INSERT INTO answers " .
                        "           (pupilid, imgtype, testid";
                for ($i=1; $i<=$noq; $i++){
                    if ($i < 11){
                        $q = $test["answ1"][$i-1];
                    }else if($i >= 11 && $i < 21){
                        $q = $test["answ2"][$i-11];
                    }else{
                        $q = $test["answ3"][$i-21];
                    }
                    $val .= "," . $q;
                    $sql .= ",q" . $i;
                }
                $val .= ")";
                $sql .= ") VALUES " . $val;
                if (!$db->query($sql))
                    die($db->error);
                $destfile = ((integer) substr($test["code"], 0, -2)) . "_" . $db->insert_id . "." . substr($filename, -3);
                sendToOK($filename, $destfile);
                return($result);
                return(true);
            }
        }else{
            sendToErr($filename, $result["ext"]);
            return ($result);
            return (false);
        }
    }

    function sendToErr($filename, $ext=""){
        global $dir_new;
        global $dir_err;

        rename($dir_new . "/" . $filename, $dir_err . "/" . str_replace(".", "_" . $ext . ".", $filename));
    }
    function sendToOk($filename, $destfile){
        global $dir_new;
        global $dir_ok;

        rename($dir_new . "/" . $filename, $dir_ok . "/" . $destfile);
    }
    
    function pointSetted(){
        global $pointSetted;
        return($pointSetted);
    }
    function pointNotSetted(){
        global $pointSetted;
        if ($pointSetted==0)
            return(1);
        else
            return(0);
    }

    function setBlackAndWhite(&$img){
        // convertir la imagen a dos colores (alto contraste)
        imagefilter($img, IMG_FILTER_GRAYSCALE);
        imagetruecolortopalette($img, false, 2);
    }


    function readTest($input_path){
        global $db;
        global $pointSetted;
        
        $img = imagecreatefromstring(file_get_contents($input_path));
        setBlackAndWhite($img);

        if (alignForm($img)){
            $pointSetted = imagecolorat ($img, 10, 10);
            $code = getCode($img);
            // validar codigo del alumno
            $sql =  "SELECT     T.numofquestions noq " .
                    "FROM       pupils P " .
                    "INNER JOIN tests T " .
                    "ON         P.level = T.level " .
                    "WHERE      CONCAT(P.id,RIGHT(CRC32(P.id),2))='" . (integer) $code . "'";
            if (!$rs=$db->query($sql)){
                $output = array(
                    "rsp"=>"NOOK",
                    "type"=>"internal",
                    "ext"=>"internal_error_1",
                    "msg"=>$db->error
                );
                imagedestroy($img);
                return ($output);
            }
            if (!$row = $rs->fetch_assoc()){
                $output = array(
                    "rsp"=>"NOOK",
                    "type"=>"readerror",
                    "msg"=>$code . " no encontrado",
                    "ext"=>"pupil_not_found",
                    "sql"=>$sql
                );
                imagedestroy($img);
                return ($output);
            }
            $noq = (integer) $row["noq"];
            if ($noq > 10)
                $pct = 50;
            else
                $pct = $noq/2;
            $answ1 = getAnwers($img);
            // si más del 50% de las respuestas estan sin contestar se genera error
            if (!validateAnsw($answ1, $pct)){
                $output = array(
                    "rsp"=>"NOOK",
                    "type"=>"readerror",
                    "msg"=>"Demasiadas respuestas sin contestar 1",
                    "ext"=>"too_many_null_responses_col_1",
                    "ref"=>$answ1
                );
                imagedestroy($img);
                return ($output);
            }
            if ($noq-10 > 10)
                $pct = 50;
            else
                $pct = 100-(($noq-10)/2);
            $answ2 = getAnwers($img, 26.3);
            // si más del 50% de las respuestas estan sin contestar se genera error
            if (!validateAnsw($answ2, $pct)){
                $output = array(
                    "rsp"=>"NOOK",
                    "type"=>"readerror",
                    "msg"=>"Demasiadas respuestas sin contestar 2",
                    "ext"=>"too_many_null_responses_col_2",
                    "ref"=>$answ2
                );
                imagedestroy($img);
                return ($output);
            }
            if ($noq-20 > 10)
                $pct = 50;
            else
                $pct = 100-(($noq-20)/2);
            $answ3 = getAnwers($img, 52.6);
            // si más del 60% de las respuestas estan sin contestar se genera error
            if (!validateAnsw($answ3, $pct)){
                $output = array(
                    "rsp"=>"NOOK",
                    "type"=>"readerror",
                    "msg"=>"Demasiadas respuestas sin contestar 3",
                    "ext"=>"too_many_null_responses_col_3",
                    "ref"=>$answ3
                );
                imagedestroy($img);
                return ($output);
            }
            $output = array(
                "rsp"=>"OK",
                "test"=>array(
                    "code"=>$code,
                    "answ1"=>$answ1,
                    "answ2"=>$answ2,
                    "answ3"=>$answ3
                )
            );
            imagedestroy($img);
            return ($output);
        }else{
            $output = array(
                "rsp"=>"NOOK",
                "type"=>"readerror",
                "msg"=>"Fallo la alineacion del formulario",
                "ext"=>"form_alignment_fail"
            );
            imagedestroy($img);
            return ($output);
        }
        imagedestroy($img);
    }

    function validateAnsw($answ, $min=50){
        $badcnt = 0;
        for ($i=0; $i<count($answ); $i++){
            if ($answ[$i]==-1)
                $badcnt++;
        }
        return (true);
        //return (($badcnt*100/count($answ))<=$min);
    }
    
    function getAnwers(&$img, $offset=0){
        $answers = array();
        $xs = array(27.9, 32.2, 36.3, 40.4, 44.4);
        $ys = array(36.8, 41.8, 46.9, 52, 57.1, 62.1, 67.1, 72.2, 77.4, 82.5);
        for ($j=0; $j<count($ys); $j++){
            $answer = -1;
            //$weight = 0;
            $weightprom = 0;
            $sobremarca = false;
            for ($i=0; $i<count($xs); $i++){
                $curweight = checkMark($img, $offset+$xs[$i], $ys[$j]);
                $weightprom += $curweight;
                //if ($curweight > $weight){
                if ($curweight > 150){
                    //$weight = $curweight;
                    if ($answer != -1)
                        $sobremarca = true;
                    $answer = $i+1;
                }
                //drawPoint($img, $offset+$xs[$i], $ys[$j]);
            }
            //$weightprom = ($weightprom - $weight) / count($xs);
            //$weightpct = (integer) (($weight - $weightprom) * 100 / $weightprom);
            // corrección para no respondidas
            //if ($weightpct < 200)
            //    $answer = -1;
            if ($sobremarca)
                $answer = -2;
            $answers[] = $answer;
            //echo (($j+1) . ": " . $answer  . " " . $weight . " " . $weightprom . " " . $weightpct . "</br>");
        }
        return($answers);
    }

    function getCode(&$img){
        $xs = array(1.4, 4.2, 7, 9.9, 12.8, 15.7, 18.5);
        $ys = array(21, 24.6, 28.2, 31.8, 35.5, 39.1, 42.9, 46.9, 50.2, 54);
        $code = "";
        for ($i=0; $i<count($xs); $i++){
            $digit = array();
            for ($j=0; $j<count($ys); $j++){
                $digit[] = array("x"=>$xs[$i], "y"=>$ys[$j]);
                //drawPoint($img, $xs[$i], $ys[$j]);
            }
            $digitrd = getCodeDigit($img, $digit);
            if ($digitrd < 0)
                return ("ERROR LEYENDO DIGITO " . $i);
            else
                $code .= $digitrd;
        }
        return ($code);
    }

    function getCodeDigit($img, $digit){
        $weight = 0;
        $exitval = -1;
        for ($i=0; $i<count($digit); $i++){
            $curweight = checkMark($img, $digit[$i]["x"], $digit[$i]["y"]);
            if ($curweight > $weight){
                $weight = $curweight;
                $exitval = $i;
            }
        }
        return ($exitval);
    }

    function getCodeDigitX($img, $digit){
        $weight = 0;
        $weightprom = 0;
        $exitval = "";
        for ($i=0; $i<count($digit); $i++){
            $curweight = checkMark($img, $digit[$i]["x"], $digit[$i]["y"]);
            $weightprom += $curweight;
            if ($curweight > $weight){
                $weight = $curweight;
                $exitval = (string) $i;
            }
        }
        $weightprom = ($weightprom - $weight) / count($digit);
        $weightpct = (integer) (($weight - $weightprom) * 100 / $weightprom);
        if ($weightpct < 150)
            $exitval = "";

        return ($exitval);
    }

    function checkMark($img, $xpct, $ypct){
        $alto = imagesy($img);
        $ancho = imagesx($img);

        $x = $xpct * $ancho / 100;
        $y = $ypct * $alto / 100;

        // tomar un recuadro de +/- 4 pixeles
        $maxwidth = 10;
        $pointscnt = 0;
        for ($i=-$maxwidth; $i<=$maxwidth; $i++){
            for ($j=-$maxwidth; $j<=$maxwidth; $j++){
                if (imagecolorat ($img, $x+$i, $y+$j)==pointSetted())
                    $pointscnt++;
                //imagesetpixel ( $img, $x+$i, $y+$j, 0 );
            }
        }
        //return (($pointscnt*100)/($maxwidth*$maxwidth));
        return ($pointscnt);
    }
    
    function alignForm(&$img, $justDetect = false){
        // buscar rectángulo superior izquierdo
        $recttopleft = detectRentangle($img, 0,0,25,25);
        if (isset($recttopleft)){
            if ($justDetect)
                drawRectangleCutLines($img, $recttopleft);

            // buscar rectángulo superior derecho
            $recttopright = detectRentangle($img, 85,0,100,25);
            if (isset($recttopright)){
                if ($justDetect)
                    drawRectangleCutLines($img, $recttopright);

                // buscar rectángulo superior medio
                $rectmiddle = detectRentangle($img, 45,0,85,25);
                if (isset($rectmiddle)){
                    if ($justDetect){
                        drawRectangleCutLines($img, $rectmiddle);
                    }else{
                        // Corregir inclinación
                        $img = alignImage($img, $recttopleft, $recttopright);
                    }
                }else{
                    if (!$justDetect){
                        // Corregir inclinación
                        $img = alignImage($img, $recttopleft, $recttopright);
                        
                        // no se consiguió el central se rota la página completamente
                        $img = imagerotate($img, 180, 1);
                    }
                }
                
                if (!$justDetect){
                    // CROPPING
                    // volver a llevar a dos colores
                    setBlackAndWhite($img);
                    // buscar de nuevo rectángulo superior izquierdo
                    $recttopleft = detectRentangle($img, 0,0,25,25);
                    if (isset($recttopleft)){
                        //drawRectangleCutLines($img, $recttopleft);

                        $recttopright = detectRentangle($img, 85,0,100,25);
                        if (isset($recttopright)){
                            // pegar imagen al top+left
                            $rect1 = pct2pxl($img, $recttopleft);
                            $rect2 = pct2pxl($img, $recttopright);
                            $img = imagecrop($img, array("x"=>$rect1["left"], "y"=>$rect1["top"], "width"=>$rect2["right"]-$rect1["left"]+1, "height"=>imagesy($img)));
                        }
                    }
                }
                $salida = true;
            }else{
                $salida = false;
            }
        }else{
            $salida = false;
        }
        return($salida);
    }

    
    ////////////////////////////////////////////
    
    // esta función detecta un rectángulo en un rango de coordenadas porcentuales
    // Ej. Busca rectangulo en X entre 10% y 20% y Y entre 30% y 40% detectRectangle($img,10,20,30,40);
    //     Devuelve un array(left, top, right, bottom) todos valores porcentuales
    function detectRentangle($img, $minx, $miny, $maxx, $maxy){
        $left = 0;
        $right = 0;
        $top = 0;
        $bottom = 0;
        
        $validwidth = 3;    // porcentaje de anchura del recuadro
        $validheight = 3;   // porcentaje de altura del recuadro
        $tolerance = 1;     // tolerancia +/- pct
        
        if ($maxx<$minx||$maxy<$miny){
            die("---");
            return(null);
        }
        
        $alto = imagesy($img);
        $ancho = imagesx($img);
        
        $retry = true;
        
        $xstartorg = (integer) $minx*$ancho/100;
        $xendorg = (integer) $maxx*$ancho/100;
        $ystartorg = (integer) $miny*$alto/100;
        $yendorg = (integer) $maxy*$alto/100;
        
        $xdisp = 0;     // Desplazamiento en busqueda horizontal
        $ydisp = 0;     // Desplazamiento en busqueda vertical
        
        // Reintentos por ubicación equivocada
        $cnt = 0;
        while ($retry){
            $cnt++;
            $retry = false;
            $xstart = $xstartorg + $xdisp;
            $xend = $xendorg;
            $ystart = $ystartorg + $ydisp;
            $yend = $yendorg;
            $topdetect = false;
            $lefdetect = false;
            $botdetect = false;
            $rigdetect = false;
            // barrido vertical, como las coordenadas vienen porcentuales se convierten a absolutas
            for ($y=$ystart;$y<$yend;$y++){
                // barrido horizontal, como las coordenadas vienen porcentuales se convierten a absolutas
                for ($x=$xstart;$x<$xend;$x++){
                    if (!$topdetect){
                        if (imagecolorat ($img, $x, $y) == pointSetted()){      // detección de top+left
                            // mover inicio horizontal al left encontrado
                            $xstart = $x+1;
                            
                            $top = $y;
                            $topdetect = true;
                            $left = $x;
                            $lefdetect = true;
                            
                            // abortar recorrido horzontal para iniciar próxima linea
                            $x = $xend;
                        }
                    }else{
                        if (!$rigdetect){
                            if (imagecolorat ($img, $x, $y) == pointNotSetted()){      // deteccion de right
                                // liminar barrido de ancho hasta nueva detección
                                $xend = $x;
                                
                                $right = $x;
                                $rigdetect = true;
                            }
                        }else{
                            if (imagecolorat ($img, $x, $y) == pointNotSetted()){      // deteccion de bottom
                                $bottom = $y;
                                $botdetect = true;
    
                                // forzar salida del cliclo
                                $y = $yend;
                                $x = $xend;
                            }else{
                                $x = $xend;
                            }
                        }
                    }
                }
            }
            
            // convertir a porcentuales
            $left = $left * 100 / $ancho;
            $right = $right * 100 / $ancho;
            $top = $top * 100 / $alto;
            $bottom = $bottom * 100 / $alto;
            
            $actualwidth = intval($right-$left);
            $actualheight = intval($bottom-$top);
            
            // validación de aceptación de que es un rectangulo adecuado
            if ($actualwidth <= $validwidth+$tolerance && $actualwidth >= $validwidth-$tolerance &&
                $actualheight <= $validheight+$tolerance && $actualheight >= $validwidth-$tolerance){
                return (array("left"=>$left,"top"=>$top,"right"=>$right,"bottom"=>$bottom));
            }else{
                // falla el rectángulo se desplaza el left y el top de inicio y se reintenta
                if ($xstartorg + $xdisp < $xendorg){
                    $xdisp++;
                }else{
                    $xdisp = 0;
                    $ydisp++;
                }
                $retry = true;
                if ($ystartorg + $ydisp >= $yendorg){
                    $retry = false;
                }
                
            }
            
            // evitar infinite loop
            if ($cnt> 10000)
                return(null);
                //die("XX");
        }
        return (null);
    }
    
    // dibuja una linea vertical porcentual a la imagen
    function drawVerticalLine($img, $xpct){
        $ancho = imagesx($img);
        $alto = imagesy($img);
        $xtopleft = ($xpct*$ancho/100);
        imagefilledrectangle($img, $xtopleft, 0, $xtopleft+1, $alto, pointSetted());
    }
    
    // dibuja una linea horizontal porcentual a la imagen
    function drawHorizontalLine($img, $ypct){
        $alto = imagesy($img);
        $ancho = imagesx($img);
        $xbottomright = ($ypct*$alto/100);
        imagefilledrectangle($img, 0, $xbottomright, $ancho, $xbottomright+1, pointSetted());
    }
    
    // muestra las lineas de corte de un rectángulo
    function drawRectangleCutLines($img, $rect){
        drawHorizontalLine($img, $rect["top"]);
        drawVerticalLine($img, $rect["left"]);
        drawHorizontalLine($img, $rect["bottom"]);
        drawVerticalLine($img, $rect["right"]);
    }
    
    function drawPoint($img, $x, $y){
        drawHorizontalLine($img, $y);
        drawVerticalLine($img, $x);
    }
    
    // pct a pixeles
    function pct2pxl($img, $rect){
        $alto = imagesy($img);
        $ancho = imagesx($img);
        $left = $rect["left"] * $ancho / 100;
        $right = $rect["right"] * $ancho / 100;
        $top = $rect["top"] * $alto / 100;
        $bottom = $rect["bottom"] * $alto / 100;
        return (array("left"=>$left,"top"=>$top,"right"=>$right,"bottom"=>$bottom));
    }
    
    function alignImage($img, $recttopleft, $recttopright){
        // Corregir inclinación
        $rect1 = pct2pxl($img, $recttopleft);
        $rect2 = pct2pxl($img, $recttopright);
        if ($rect1["bottom"] < $rect2["bottom"]){  // clockwise rotation
            $c2 = $rect2["bottom"] - $rect1["bottom"] + 1;
            $c1 = $rect2["right"] - $rect1["left"] + 1;
            $angle = rad2deg(atan($c2/$c1));
            $img = imagerotate($img, $angle, 1);
        }
        if ($rect1["bottom"] > $rect2["bottom"]){  // clockwise rotation
            $c2 = $rect1["bottom"] - $rect2["bottom"] + 1;
            $c1 = $rect2["right"] - $rect1["left"] + 1;
            $angle = rad2deg(-1*atan($c2/$c1));
            $img = imagerotate($img, $angle, 1);

        }
        return($img);
    }
    
?>