<?php
    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");
    
    //Parametros obligatorios
    $parmsob = array("ssid");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
        
    $out = new stdClass();
    $sessionid = $_GET["ssid"];
    //arreglo con los grados existentes
    $levels = ["1er Grado","2do Grado","3ro Grado","4ro Grado","5to Grado","6to Grado"];
    
    //Verificamos que la sesion no este expirada
    isSessionValid($db, $sessionid);
    
    //Obtenemos los datos de los colegios publicos
    $sql = "SELECT COUNT(*) AS qty,".
    "   sum(CASE WHEN pupils.level = 1 THEN 1 ELSE 0 END) AS oneLev,".
    "   sum(CASE WHEN pupils.level = 2 THEN 1 ELSE 0 END) AS secLev,".
    "   sum(CASE WHEN pupils.level = 3 THEN 1 ELSE 0 END) AS thirdLev,".
    "   sum(CASE WHEN pupils.level = 4 THEN 1 ELSE 0 END) AS quarLev,".
    "   sum(CASE WHEN pupils.level = 5 THEN 1 ELSE 0 END) AS fifthLev,".
    "   sum(CASE WHEN pupils.level = 6 THEN 1 ELSE 0 END) AS sixLev".
    "   FROM pupils,schools ".
    "   WHERE schools.private=0 AND pupils.schoolid = schools.id";
    
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    $out->numofrecords++;
    $public = $rs->fetch_assoc();
    
    //Obtenemos los datos de los colegios privados
    $sql = "SELECT COUNT(*) AS qty,".
    "   sum(CASE WHEN pupils.level = 1 THEN 1 ELSE 0 END) AS oneLev,".
    "   sum(CASE WHEN pupils.level = 2 THEN 1 ELSE 0 END) AS secLev,".
    "   sum(CASE WHEN pupils.level = 3 THEN 1 ELSE 0 END) AS thirdLev,".
    "   sum(CASE WHEN pupils.level = 4 THEN 1 ELSE 0 END) AS quarLev,".
    "   sum(CASE WHEN pupils.level = 5 THEN 1 ELSE 0 END) AS fifthLev,".
    "   sum(CASE WHEN pupils.level = 6 THEN 1 ELSE 0 END) AS sixLev".
    "   FROM pupils,schools ".
    "   WHERE schools.private=1 AND pupils.schoolid = schools.id";
    
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    //Arreglo con nombres de columnas
    $arrNames = ["oneLev","secLev","thirdLev","quarLev","fifthLev","sixLev"];
    
    $out->numofrecords++;
    $privat = $rs->fetch_assoc();
    
    $out->totals = new stdClass();
    $out->totals->publics = new stdClass();
    $out->totals->privated = new stdClass();
    $out->totals->total = new stdClass();
    
    //Valores totales de colegios publicos
    $out->totals->publics->number = (int)$public["qty"];
    $out->totals->publics->formatted = number_format($public["qty"],0,"",".");
    
    //Valores totales de colegios privados
    $out->totals->privated->number = (int)$privat["qty"];
    $out->totals->privated->formatted = number_format($privat["qty"],0,"",".");
    
    //Valores totales de ambos colegios
    $out->totals->total->number = (int)$privat["qty"] + $public["qty"];
    $out->totals->total->formatted = number_format($out->totals->total->number,0,"",".");
    
    //Valores por cada grado
    for($i = 0; $i < sizeof($public)-1; $i++){
        $out->records[$i] = new stdClass();
        $out->records[$i]->level = (string)$i+1;
        $out->records[$i]->dsc = (string)$levels[$i];
        
        $out->records[$i]->publics = new stdClass();
        $out->records[$i]->privated = new stdClass();
        $out->records[$i]->total = new stdClass();
        
        $out->records[$i]->publics->number = (int)$public[$arrNames[$i]];
        $out->records[$i]->publics->formatted = number_format($out->records[$i]->publics->number,0,"",".");
        
        $out->records[$i]->privated->number = (int)$privat[$arrNames[$i]];
        $out->records[$i]->privated->formatted = number_format($out->records[$i]->privated->number,0,"",".");
        
        $out->records[$i]->total->number = (int)$out->records[$i]->publics->number + $out->records[$i]->privated->number;
        $out->records[$i]->total->formatted = number_format($out->records[$i]->total->number,0,"",".");
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>