<?php
    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");
    
    //Parametros obligatorios
    $parmsob = array("ssid");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $sessionid = $_GET["ssid"];
    $out = new stdClass();
    
    //Verificamos que la sesion no este expirada
    isSessionValid($db, $sessionid);
    
    //Arreglo con los estados
    $states = ["AMAZONAS","ANZOATEGUI","APURE","ARAGUA","ARAGUA/CAGUA","ARAGUA/MARACAY","BARINAS","BOLIVAR","CARABOBO","COJEDES","DELTA AMACURO","FALCON","GUARICO","LARA","MERIDA","MIRANDA","MONAGAS","NVA.ESPARTA","PORTUGUESA","REG.CAPITAL","STA. BÁRBARA","SUCRE","TACHIRA","TRUJILLO","LA GUAIRA","YARACUY","ZULIA"];
    //Inicilizacion de valores totales
    $out->totals = new stdClass();
    for($i = 1; $i <= 6; $i++){
        $out->totals->$i = new stdClass;
        $out->totals->$i->number = 0;
        $out->totals->$i->formatted = "0";
    }
    
    for($i = 0; $i < sizeof($states); $i++){
        $out->numofrecords++;
        //Obtener datos del colegio en especifico
        $sql ="SELECT ".
       "    sum(CASE WHEN pupils.level = 1 AND schools.region = '".$states[$i]."' THEN 1 ELSE 0 END) AS oneLev,".
       "    sum(CASE WHEN pupils.level = 2 AND schools.region = '".$states[$i]."' THEN 1 ELSE 0 END) AS secLev,".
       "    sum(CASE WHEN pupils.level = 3 AND schools.region = '".$states[$i]."' THEN 1 ELSE 0 END) AS thirdLev,".
       "    sum(CASE WHEN pupils.level = 4 AND schools.region = '".$states[$i]."' THEN 1 ELSE 0 END) AS quarLev,".
       "    sum(CASE WHEN pupils.level = 5 AND schools.region = '".$states[$i]."' THEN 1 ELSE 0 END) AS fifthLev,".
       "    sum(CASE WHEN pupils.level = 6 AND schools.region = '".$states[$i]."' THEN 1 ELSE 0 END) AS sixLev".
       "    FROM pupils,schools WHERE pupils.schoolid = schools.id AND schools.name <> 'POBLACION FLOTANTE'";
       
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
            
        $pupilsByRegion = $rs->fetch_row();
        //Inicilizacion de objetos
        $out->records[$i] = new stdClass();
        $out->records[$i]->region = (string)$states[$i];
        $out->records[$i]->levels = new stdClass();
        
        for($j = 1; $j <= sizeof($pupilsByRegion); $j++){
            //En caso de que sea 1 debe inicilizar
            if($j == 1){
                $out->records[$i]->levels->total = new stdClass();
                $out->records[$i]->levels->total->number = 0;
            }
            //Suma de cantidad de alumnos totales entero
            $out->records[$i]->levels->total->number += (int)$pupilsByRegion[$j-1];
            //Creacion de objeto por grado
            $out->records[$i]->levels->$j = new stdClass();
            //Suma de cantidad de alumnos totales por grado
            $out->totals->$j->number += (int)$pupilsByRegion[$j-1];
            //Cantidad de alumnos por grado
            $out->records[$i]->levels->$j->number = (int)$pupilsByRegion[$j-1];
            //Formateo de cantidad de alumnos por grado
            $out->records[$i]->levels->$j->formatted = number_format($pupilsByRegion[$j-1],0,"",".");
            //Formateo de cantidad de alumnos totales
            $out->records[$i]->levels->total->formatted = number_format($out->records[$i]->levels->total->number,0,"",".");
        }
    }
    
    //Agrego de poblacion flotante
    $sql ="SELECT ".
       "    sum(CASE WHEN pupils.level = 1 AND schools.name = 'POBLACION FLOTANTE' THEN 1 ELSE 0 END) AS oneLev,".
       "    sum(CASE WHEN pupils.level = 2 AND schools.name = 'POBLACION FLOTANTE' THEN 1 ELSE 0 END) AS secLev,".
       "    sum(CASE WHEN pupils.level = 3 AND schools.name = 'POBLACION FLOTANTE' THEN 1 ELSE 0 END) AS thirdLev,".
       "    sum(CASE WHEN pupils.level = 4 AND schools.name = 'POBLACION FLOTANTE' THEN 1 ELSE 0 END) AS quarLev,".
       "    sum(CASE WHEN pupils.level = 5 AND schools.name = 'POBLACION FLOTANTE' THEN 1 ELSE 0 END) AS fifthLev,".
       "    sum(CASE WHEN pupils.level = 6 AND schools.name = 'POBLACION FLOTANTE' THEN 1 ELSE 0 END) AS sixLev".
       "    FROM pupils,schools WHERE pupils.schoolid = schools.id";
       
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
            
            
    $pupilsByRegion = $rs->fetch_row();
    
    $positionReg = sizeof($states);
    for($i = 0 ; $i < 1; $i++){
        $out->numofrecords++;
        $out->records[$positionReg] = new stdClass();
        $out->records[$positionReg]->region = "POBLACION FLOTANTE";
        $out->records[$positionReg]->levels = new stdClass();
        
        for($j = 1; $j <= sizeof($pupilsByRegion); $j++){
            //En caso de que sea 1 debe inicilizar
            if($j == 1){
                $out->records[$positionReg]->levels->total = new stdClass();
                $out->records[$positionReg]->levels->total->number = 0;
            }
            //Suma de cantidad de alumnos totales entero
            $out->records[$positionReg]->levels->total->number += (int)$pupilsByRegion[$j-1];
            //Creacion de objeto por grado
            $out->records[$positionReg]->levels->$j = new stdClass();
            //Suma de cantidad de alumnos totales por grado
            $out->totals->$j->number += (int)$pupilsByRegion[$j-1];
            //Cantidad de alumnos por grado
            $out->records[$positionReg]->levels->$j->number = (int)$pupilsByRegion[$j-1];
            //Formateo de cantidad de alumnos por grado
            $out->records[$positionReg]->levels->$j->formatted = number_format($pupilsByRegion[$j-1],0,"",".");
            //Formateo de cantidad de alumnos totales
            $out->records[$positionReg]->levels->total->formatted = number_format($out->records[$positionReg]->levels->total->number,0,"",".");
        }
    }
    
    $out->totals->total = new stdClass();
    for($i = 1; $i <= 6; $i++){
        $out->totals->total->number += (int)$out->totals->$i->number;
        $out->totals->$i->formatted = number_format($out->totals->$i->number,0,"",".");
    }
    
    $out->totals->total->formatted = number_format($out->totals->total->number,0,"",".");
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>