<?php
    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");
    
    //Parametros obligatorios
    $parmsob = array("ssid");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $sessionid = $_GET["ssid"];
    $out = new stdClass();
    
    //Verificamos que la sesion no este expirada
    isSessionValid($db, $sessionid);
    
    //Arreglo con los estados a mostrar
    $states = ["Amazonas","Anzoategui","Apure","Aragua","Barinas","Bolivar","Carabobo","Cojedes","Delta Amacuro","Falcon","Guarico","Lara","Merida","Miranda","Monagas","Nueva Esparta","Portuguesa","Region Capital","Santa Barbara","Sucre","Tachira","Trujillo","La Guaira","Yaracuy","Zulia"];
    
    //Inicializacion de objetos
    $out->totals = new stdClass();
    $out->totals->privated = new stdClass();
    $out->totals->publics = new stdClass();
    $out->totals->total = new stdClass();
    for($i = 0; $i < sizeof($states); $i++){
        $out->records[$i] = new stdClass();
        $out->records[$i]->region = $states[$i];
        $out->records[$i]->qty = new stdClass();
        $out->records[$i]->qty->publics = new stdClass();
        $out->records[$i]->qty->privated = new stdClass();
        $out->records[$i]->qty->totals = new stdClass();
    }
    
    //Obtener datos por cada tipo de colegio
    $privated = getDataByType("1",$db);
    $publics = getDataByType("0",$db);
    
    for($i = 1; $i < sizeof($publics); $i++){
        $out->records[$i-1]->qty->privated->number = (int)$privated[$i];
        $out->records[$i-1]->qty->privated->formatted = number_format($privated[$i],0,"",".");
        $out->records[$i-1]->qty->publics->number = (int)$publics[$i];
        $out->records[$i-1]->qty->publics->formatted = number_format($publics[$i],0,"",".");

        $out->records[$i-1]->qty->totals->number = (int)$privated[$i] + (int)$publics[$i];
        $out->records[$i-1]->qty->totals->formatted = number_format($out->records[$i-1]->qty->totals->number,0,"",".");
        
        $out->totals->privated->number += (int)$privated[$i];
        $out->totals->publics->number += (int)$publics[$i];
        $out->totals->total->number += (int)$out->records[$i-1]->qty->totals->number;
    }
    
    $out->totals->privated->formatted = number_format($out->totals->privated->number,0,"",".");
    $out->totals->publics->formatted = number_format($out->totals->publics->number,0,"",".");
    $out->totals->total->formatted = number_format($out->totals->total->number,0,"",".");
    
    function getDataByType($kindSchools,$db){
        
        $sql = "SELECT COUNT(*) AS qty,".
        "   sum(CASE WHEN schools.region = 'AMAZONAS' THEN 1 ELSE 0 END) AS qtyAmazonas,".
        "   sum(CASE WHEN schools.region = 'ANZOÁTEGUI' THEN 1 ELSE 0 END) AS qtyAnzoategui,".
        "   sum(CASE WHEN schools.region = 'APURE' THEN 1 ELSE 0 END) AS qtyApure,".
        "   sum(CASE WHEN schools.region = 'ARAGUA' THEN 1 ELSE 0 END) AS qtyAragua,".
        "   sum(CASE WHEN schools.region = 'BARINAS' THEN 1 ELSE 0 END) AS qtyBarinas,".
        "   sum(CASE WHEN schools.region = 'BOLÍVAR' THEN 1 ELSE 0 END) AS qtyBolivar,".
        "   sum(CASE WHEN schools.region = 'CARABOBO' THEN 1 ELSE 0 END) AS qtyCarabobo,".
        "   sum(CASE WHEN schools.region = 'COJEDES' THEN 1 ELSE 0 END) AS qtyCojedes,".
        "   sum(CASE WHEN schools.region = 'DELTA AMACURO' THEN 1 ELSE 0 END) AS qtyDelta,".
        "   sum(CASE WHEN schools.region = 'FALCÓN' THEN 1 ELSE 0 END) AS qtyFalcon,".
        "   sum(CASE WHEN schools.region = 'GUÁRICO' THEN 1 ELSE 0 END) AS qtyGuarico,".
        "   sum(CASE WHEN schools.region = 'LARA' THEN 1 ELSE 0 END) AS qtyLara,".
        "   sum(CASE WHEN schools.region = 'MÉRIDA' THEN 1 ELSE 0 END) AS qtyMerida,".
        "   sum(CASE WHEN schools.region = 'MIRANDA' THEN 1 ELSE 0 END) AS qtyMiranda,".
        "   sum(CASE WHEN schools.region = 'MONAGAS' THEN 1 ELSE 0 END) AS qtyMonagas,".
        "   sum(CASE WHEN schools.region = 'NVA.ESPARTA' THEN 1 ELSE 0 END) AS qtyEsparta,".
        "   sum(CASE WHEN schools.region = 'PORTUGUESA' THEN 1 ELSE 0 END) AS qtyPortuguesa,".
        "   sum(CASE WHEN schools.region = 'REG.CAPITAL' THEN 1 ELSE 0 END) AS qtyCapital,".
        "   sum(CASE WHEN schools.region = 'STA. BÁRBARA' THEN 1 ELSE 0 END) AS qtySanta,".
        "   sum(CASE WHEN schools.region = 'SUCRE' THEN 1 ELSE 0 END) AS qtySucre,".
        "   sum(CASE WHEN schools.region = 'TÁCHIRA' THEN 1 ELSE 0 END) AS qtyTachira,".
        "   sum(CASE WHEN schools.region = 'TRUJILLO' THEN 1 ELSE 0 END) AS qtyTrujillo,".
        "   sum(CASE WHEN schools.region = 'LA GUAIRA' THEN 1 ELSE 0 END) AS qtyVargas,".
        "   sum(CASE WHEN schools.region = 'YARACUY' THEN 1 ELSE 0 END) AS qtyYaracuy,".
        "   sum(CASE WHEN schools.region = 'ZULIA' THEN 1 ELSE 0 END) AS qtyZulia".
	    "   FROM schools WHERE schools.email IS NOT NULL AND schools.hashregister IS NULL AND schools.private = '".$kindSchools."'";
	    if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
	    return $rs->fetch_row();
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>