<?php
    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");
    
    //Parametros obligatorios
    $parmsob = array("ssid");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
        
    $out = new stdClass();
    $sessionid = $_GET["ssid"];
    
    //Verificamos que la sesion no este expirada
    isSessionValid($db, $sessionid);
    
    //Obtener la cantidad de colegios publicos
    $sql = "SELECT ".
    "       sum(CASE WHEN email IS NOT NULL && hashregister IS NULL THEN 1 ELSE 0 END) as registered,".
    "       sum(CASE WHEN estimatedpupilsedit = 1 && (email IS NOT NULL) && hashregister IS NULL THEN 1 ELSE 0 END) as estimating,".
    "       sum(CASE WHEN estimatedpupilsedit = 0 && (email IS NOT NULL) && hashregister IS NULL THEN 1 ELSE 0 END) AS registering,".
    "       count(private) as qty FROM schools ".
    "       WHERE private=0";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row= $rs->fetch_assoc();
    
    //Asignar datos de colegios publicos
    $out->numofrecords++;
    $out->records[0] = new stdClass();
    $out->records[0]->type = 0;
    $out->records[0]->dsc = "Públicos";
    $out->records[0]->total = new stdClass();
    $out->records[0]->total->number = (int)$row["qty"];
    $out->records[0]->total->formatted = number_format($row["qty"],0,"",".");
    $out->records[0]->registered = new stdClass();
    $out->records[0]->registered->number = (int)$row["registered"];
    $out->records[0]->registered->formatted = number_format($row["registered"],0,"",".");
    $out->records[0]->estimating = new stdClass();
    $out->records[0]->estimating->number = (int)$row["estimating"];
    $out->records[0]->estimating->formatted = number_format($row["estimating"],0,"",".");
    $out->records[0]->registering = new stdClass();
    $out->records[0]->registering->number = (int)$row["registering"];
    $out->records[0]->registering->formatted = number_format($row["registering"],0,"",".");
    
    //Obtener la cantidad de colegios publicos
    $sql = "SELECT ".
    "       sum(CASE WHEN email IS NOT NULL && hashregister IS NULL THEN 1 ELSE 0 END) as registered,".
    "       sum(CASE WHEN estimatedpupilsedit = 1 && (email IS NOT NULL) && hashregister IS NULL  THEN 1 ELSE 0 END) as estimating,".
    "       sum(CASE WHEN estimatedpupilsedit = 0 && (email IS NOT NULL) && hashregister IS NULL THEN 1 ELSE 0 END) AS registering,".
    "       count(private) as qty FROM schools ".
    "       WHERE private=1";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row= $rs->fetch_assoc();
    
    //Asignar datos de colegios privados
    $out->numofrecords++;
    $out->records[1] = new stdClass();
    $out->records[1]->type = 1;
    $out->records[1]->dsc = "Privados";
    $out->records[1]->total = new stdClass();
    $out->records[1]->total->number = (int)$row["qty"];
    $out->records[1]->total->formatted = number_format($row["qty"],0,"",".");
    $out->records[1]->registered = new stdClass();
    $out->records[1]->registered->number = (int)$row["registered"];
    $out->records[1]->registered->formatted = number_format($row["registered"],0,"",".");
    $out->records[1]->estimating = new stdClass();
    $out->records[1]->estimating->number = (int)$row["estimating"];
    $out->records[1]->estimating->formatted = number_format($row["estimating"],0,"",".");
    $out->records[1]->registering = new stdClass();
    $out->records[1]->registering->number = (int)$row["registering"];
    $out->records[1]->registering->formatted = number_format($row["registering"],0,"",".");
    
    //Calculamos el total de colegios
    $out->totals = new stdClass();
    for($i = 0; $i < $out->numofrecords; $i++) {
        $out->totals->number += $out->records[$i]->registered->number;
    }
    
    $out->totals->formatted += number_format($out->totals->number,0,"",".");
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>