<?php
//  api/regionals/listcsv
    header("Content-Type: application/csv;");
    //header("Content-Type:application/json");
    header("Content-Disposition: attachment; filename=regionales.csv");
    include("../connection.php");
    include("../utils.php");
    
    //Parametros obligatorios
    $parmsob = array("sessionid");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    // Declaracion e inicializacion de variables
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    
    //Verificamos que la sesion no este expirada
    isSessionValid($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios coordinador, si no validamos que tenga otro permiso
    if(!tienePrivilegio($db, $sessionid, 74)){
        badEnd("403", array("msg"=>"No tiene Privilegios".$row["cnt"]));
    }
    
    $queryTotal = '';
    // Armamos el query para sumar su puntuacion
    for($i = 0; $i < 30; $i++){
        if($i == 0){
            $queryTotal .= "IF(q".($i+1)." IS NULL, 0 , q".($i+1).")";
        }else{
            $queryTotal .= "+IF(q".($i+1)." IS NULL, 0 , q".($i+1).")";
        }
    }
    $sql = "SELECT DISTINCT pupils.*, schools.id as collegeId,".
    "       IF( ".
    "           C.id IS NULL, ".
    "           0, ".
    "           (SELECT (".$queryTotal.") AS total FROM corrections WHERE corrections.id = C.id)".
    "       ) AS score, ".
    "       test.id AS testid, an.id AS respId, ".
    "       CONCAT(LPAD(pupils.id,'5','0'),RIGHT(CRC32(pupils.id),2)) as code, ".
    "       schools.code as collegeCode, schools.name as collegeName,".
    "       schools.region as collegeRegion, schools.private as collegePriv, schools.email as collegeEmail ".
    "       FROM schools, tests test, pupils,  answers an ".
    "       LEFT JOIN corrections C ON C.answerid = an.id".
    "       WHERE pupils.schoolid = schools.id".
    "       AND an.pupilid = pupils.id ".
    "       AND an.testid = test.id ".
    "       AND test.name LIKE '%Prueba Nacional%' ";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error .$sql));
    
    while($student = $rs->fetch_assoc()){
        $record = new stdClass();
        $record->pupil = new stdClass();
        $record->school = new stdClass();
        
        $record->pupil->id = (int)$student["id"];
        
        $record->pupil->code = $student["code"];
        
        $record->pupil->ci = $student["ci"];
        $record->pupil->name = $student["name"];
        $record->pupil->surname = $student["surname"];
        $record->pupil->gender = new stdClass();
        $record->pupil->gender->id = $student["gender"];
        $record->pupil->gender->dsc = $student["gender"] == "M" ? "Masculino" : "Femenino";
        $record->pupil->birthdate = new stdClass();
        $record->pupil->birthdate->date = date("Ymd",strtotime($student["birthdate"]));
        $record->pupil->birthdate->formatted = $student["birthdate"];
        
        $record->school->code = $student["collegeCode"];
        $record->school->name = $student["collegeName"];
        $record->school->private = $student["collegePriv"] == 1 ? true : false;
        $record->school->email = $student["collegeEmail"];
        
        $record->pupil->level = (int)$student["level"];
        $record->pupil->section = $student["section"];
        
        $record->school->id = (int)$student["collegeId"];
        $record->school->region = $student["collegeRegion"];
        
        $idPupil = $student["id"] == 0 ? 1 : $student["id"];
        $sql = "SELECT answers.id AS id ".
        "       FROM answers, tests ".
        "       WHERE answers.pupilid =".$record->pupil->id.
        "       AND tests.id = answers.testid".
        "       AND tests.name LIKE '%Prueba Nacional%'";
        if (!$exam=$db->query($sql))
            badEnd("500", array("msg"=>$db->error . "fallo contador ".$student["id"]));
        
        $resexam = $exam->fetch_assoc();
        
        $record->test = new stdClass();
        $record->test->id = (int)$resexam['id'];
        
        // Validamos que tenga su examen corregido
        $sql = "SELECT * FROM corrections WHERE answerid = ".$record->test->id;
        if (!$corr=$db->query($sql))
            badEnd("500", array("msg"=>$db->error . "fallo contador ".$student["id"]));
        
        $corrections = $corr->fetch_assoc();
        
        $record->qualification = $student["score"];
        
        // Si ya tiene un profesor obtenemos su nombre
        if ($corrections['corrector'] !== null) {
            
            $sql = "SELECT name FROM cmsusers WHERE id = ".$corrections['corrector'];
            if (!$corrU=$db->query($sql))
                badEnd("500", array("msg"=>$db->error . "fallo contador ".$student["id"]));
        
            $corrector = $corrU->fetch_assoc();
            
            $record->teachername = $corrector['name'];
        } else{
            $record->teachername = '';
        }
        
        $records [] = $record;
        
        $csvarray [] = array(
            'code' => $record->pupil->code,
            'name' => $record->pupil->name." ".$record->pupil->surname,
            'level' => $record->pupil->level."".abrev($record->pupil->level)." ".$record->pupil->section,
            'college' => $record->school->name,
            'region' => $record->school->region,
            'score' => $record->qualification,
            'teacher' => $record->teachername,
        );
    }
    
    $fp = fopen('php://output', 'wb');
    fwrite($fp, $BOM);
    
    $line = array('COD.','ALUMNO','GRADO','COLEGIO','REG.','CAL.','PROFESOR');
    $line = array_map("utf8_decode", $line);
    
    fputcsv($fp, $line, ';', '"');
    
    foreach($csvarray as $arr){
        $arr = array_map("utf8_decode", $arr);
        fputcsv($fp,$arr,';');
    }
    
    fclose($fp);
    die();
    
    function abrev($level) {
        return $level == "3" || $level == "1" ? "ro" : ($level == "2" ? "do" : "to");
    }
?>