<?php
    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");
    
    $parmsob = array("sessionid","userid");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros invalidos " . implode(", ", $parmsob)));
    
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    $userid = $_GET["userid"];
    
    //Verificamos que la sesion no este expirada
    isSessionValid($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 24))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
        
    $sql =  "SELECT   privileges.id, privileges.grp, privileges.dsc " .
    "       FROM     privileges, userprivileges " .
    "       WHERE    privileges.id = userprivileges.privilegeid AND userprivileges.userid = ".$userid.
    "       ORDER BY privileges.grp ASC, privileges.dsc ASC";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    
    $out->userid = $userid;
    $i = 0;
    while ($row = $rs->fetch_assoc()){
        $out->privileges[$i] = new stdClass;
        $out->privileges[$i]->id = (int)$row["id"];
        $out->privileges[$i]->grp = $row["grp"];
        $out->privileges[$i]->dsc = $row["dsc"];
        $i++;
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>