<?php ini_set("memory_limit","-1")?>
<?php 
    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");
    
    $parmsob = array("sessionid","code");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros invalidos " . implode(", ", $parmsob)));
        
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    $code = $_GET["code"];
    
    //Verificamos que la sesion no este expirada
    isSessionValid($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 8))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    //CONCAT(LPAD(pupils.id,'5','0'),RIGHT(CRC32(pupils.id),2))
    //Obtenemos los datos del estudiante y del colegio
    $sql = "SELECT pupils.id AS pupilid, CONCAT(LPAD(pupils.id,'7','0'),RIGHT(CRC32(pupils.id),2)) AS code,".
    "       pupils.ci AS pupilci, pupils.name AS pupilname,".
    "       pupils.surname AS pupilsurname, pupils.gender AS pupilgender,".
    "       pupils.birthdate AS pupilbirth, pupils.level AS pupillevel,".
    "       pupils.section AS pupilsection,".
    "       pupils.observation AS observation, ".
    "       schools.id AS schoolid, schools.name AS schoolname,".
    "       schools.region AS schoolregion, schools.code AS schoolcode,".
    "       schools.private AS schoolprivate, schools.email AS schoolemail".
    "       FROM schools, pupils".
    "       WHERE pupils.schoolid = schools.id AND".
    "       CONCAT(LPAD(pupils.id,'7','0'),RIGHT(CRC32(pupils.id),2)) = ".$code."";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $student= $rs->fetch_assoc();
    
    if(!empty($student)){
        $out->entry = new stdClass();
        $out->entry->pupil = new stdClass();
        $out->entry->pupil->id = (int)$student["pupilid"];
        
        $out->entry->pupil->code = $student["code"];
        $out->entry->pupil->ci = $student["pupilci"];
        $out->entry->pupil->name = $student["pupilname"];
        $out->entry->pupil->surname = $student["pupilsurname"];
        $out->entry->pupil->gender = new stdClass();
        $out->entry->pupil->gender->id = $student["pupilgender"];
        $out->entry->pupil->gender->dsc = $student["pupilgender"] == "M" ? "Masculino" : "Femenino";
        
        $dateFormat = strtotime($student["pupilbirth"]);
    
        $out->entry->pupil->birthdate = new stdClass();
        $out->entry->pupil->birthdate->date = date("Y",$dateFormat).date("m",$dateFormat).date("d",$dateFormat);
        $out->entry->pupil->birthdate->formatted = $student["pupilbirth"];
        $out->entry->pupil->level = (int)$student["pupillevel"];
        $out->entry->pupil->section = $student["pupilsection"];
        $out->entry->pupil->observation = $student['observation'];
        
        $out->entry->school = new stdClass();
        
        $out->entry->school->id = (int)$student["schoolid"];
        $out->entry->school->code = $student["schoolcode"];
        $out->entry->school->name = $student["schoolname"];
        $out->entry->school->region = $student["schoolregion"];
        $out->entry->school->private = $student["schoolprivate"] == 1 ? true : false;
        $out->entry->school->email = $student["schoolemail"];
        
        // Obtenemos los resultados del alumno
        $sql = "SELECT answers.id AS answerid, ".
        "       answers.datestart AS date, ".
        "       tests.id AS testid, ".
        "       tests.name AS testname, ".
        "       tests.*, ".
        "       tests.level AS testlevel ".
        "       FROM answers, tests ".
        "       WHERE pupilid = ".$out->entry->pupil->id.
        "       AND tests.id = answers.testid";
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        while($exams = $res->fetch_assoc()){
            $record = new stdClass();
            $record->id = (int)$exams['answerid'];
            
            $record->datecreated = new stdClass();
            $record->datecreated->date = $exams['date'];
            $record->datecreated->formatted = date("d/m/Y", strtotime($exams['date']));
            
            $record->test = new stdClass();
            $record->test->id = (int)$exams['testid'];
            $record->test->name = $exams['testname'];
            $record->test->level = (int)$exams['testlevel'];
            
            // Obtenemos el score
            // Si es preeliminar
            if (stripos($record->test->name, 'preliminar') !== false) {
                // Consultamos emparejando con las preferencias
                $sql = "SELECT pupils.*, ".
                "       ".queryForScore(30).
                "       FROM pupils ".
                "       LEFT JOIN answers an ON an.pupilid = pupils.id ".
                "       LEFT JOIN tests test ON an.testid = test.id ".
                "       WHERE pupils.id = ".$out->entry->pupil->id;
                if (!$resScore=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
                    
                $score = $resScore->fetch_assoc();
                $record->score = (float)$score['score'];
                
                // Si es regional
            } else if (stripos($record->test->name, 'regional') !== false) {
                $queryTotal = '';
                // Armamos el query para sumar su puntuacion
                for($i = 0; $i < 30; $i++){
                    if($i == 0){
                        $queryTotal .= "IF(q".($i+1)." IS NULL, 0 , q".($i+1).")";
                    }else{
                        $queryTotal .= "+IF(q".($i+1)." IS NULL, 0 , q".($i+1).")";
                    }
                }
                $sql = "SELECT DISTINCT".
                "       IF( ".
                "           C.id IS NULL, ".
                "           0, ".
                "           (SELECT (".$queryTotal.") AS total FROM corrections WHERE corrections.id = C.id)".
                "       ) AS score ".
                "       FROM tests test, pupils,  answers an ".
                "       LEFT JOIN corrections C ON C.answerid = an.id".
                "       WHERE an.pupilid = pupils.id ".
                "       AND an.testid = test.id ".
                "       AND test.name LIKE '%Prueba Regional%' ".
                "       AND pupils.id = ".$out->entry->pupil->id;
                if (!$resScore=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
                    
                $score = $resScore->fetch_assoc();
                $record->score = (float)$score['score'];
            } else if (stripos($record->test->name, 'nacional') !== false) {
                $queryTotal = '';
                // Armamos el query para sumar su puntuacion
                for($i = 0; $i < 30; $i++){
                    if($i == 0){
                        $queryTotal .= "IF(q".($i+1)." IS NULL, 0 , q".($i+1).")";
                    }else{
                        $queryTotal .= "+IF(q".($i+1)." IS NULL, 0 , q".($i+1).")";
                    }
                }
                $sql = "SELECT DISTINCT".
                "       IF( ".
                "           C.id IS NULL, ".
                "           0, ".
                "           (SELECT (".$queryTotal.") AS total FROM corrections WHERE corrections.id = C.id)".
                "       ) AS score ".
                "       FROM tests test, pupils,  answers an ".
                "       LEFT JOIN corrections C ON C.answerid = an.id".
                "       WHERE an.pupilid = pupils.id ".
                "       AND an.testid = test.id ".
                "       AND test.name LIKE '%Prueba Nacional%' ".
                "       AND pupils.id = ".$out->entry->pupil->id;
                if (!$resScore=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
                    
                $score = $resScore->fetch_assoc();
                $record->score = (float)$score['score'];
            }
            
            $records [] = $record;
        }
        
        $out->entry->corrections = $records;
    }else{
        badEnd("404", array("msg"=>"Alumno no encontrado"));
    }
    
        
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    function queryForScore($questionsqty){
        $str = ' IF(test.id IS NULL, 0, ( test.ptsini ';
        
        for($i = 1; $i <= $questionsqty; $i++){
            $str .= " + 
            IF(test.q$i = 0, 0, 
                IF(test.q$i = an.q$i, 
           	    	CASE
               	    	WHEN test.dif$i = 1 THEN test.ptsoklow
                    	WHEN test.dif$i = 2 THEN test.ptsokmid
                    	WHEN test.dif$i = 3 THEN test.ptsokhigh
              	    END,
              	    CASE
                   		WHEN test.dif$i = 1 THEN -test.ptsbadlow
                   		WHEN test.dif$i = 2 THEN -test.ptsbadmid
                   		WHEN test.dif$i = 3 THEN -test.ptsbadhigh
                   	END
                ) 
            ) ";
        }
        
        $str .= ' ) ) AS score ';
        
        return $str;
    }
?>