<?php
    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");

    $parmsob = array("id", "sessionid", "name", "status");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros invalidos " . implode(", ", $parmsob)));
        
    
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    $id = $_GET["id"];
    $name = $_GET["name"];
    $status = $_GET["status"];
    
    //Verificamos que la sesion no este expirada
    isSessionValid($db, $sessionid);
    
    if($id == 0){
        
        //Validamos que el usuario tenga privilegios
        if(!tienePrivilegio($db, $sessionid, 31))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
        
        $sql = "INSERT INTO cmsusers(name, email, status, type) ".
        "       VALUES('".$name."', '".$name."', ".$status.", 0)";
        if (!$db->query($sql)){
            if ($db->errno == 1062){
                badEnd("409", array("msg"=>"Registro Duplicado"));
            }else{
                badEnd("500", array("msg"=>$db->error));
            }
        }
        
        $out->id = $db->insert_id;
        
        setAudit($db, "ROLES", $sessionid, "Se agregó el rol ".$name);
        
    }else{
        
        //Validamos que el usuario tenga privilegios
        if(!tienePrivilegio($db, $sessionid, 29))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
        
        $sql = "SELECT id FROM cmsusers WHERE type = 0 AND id=".$id;
        if (!$rs = $db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $row = $rs->fetch_assoc();
        if ($row["id"] != $id)
            badEnd("204", array("msg"=>"No se encontró el registro"));
            
        $sql = "UPDATE cmsusers SET ".
        "       name='".$name."', email='".$name."',".
        "       status=".$status." WHERE id=".$id;
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        //Verificamos que se hicieron cambios
        if($db->affected_rows == 0){
            badEnd("304", array("msg"=>"No se pudo modificar"));
        }
        
        $out->id= $id;
        
        setAudit($db, "ROLES", $sessionid, "Se actualizó el rol ".$name);
    }
    
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>