<?php
    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");
    
    $parmsob = array("sessionid","schoolid");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros invalidos " . implode(", ", $parmsob)));
    
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    $schoolid = $_GET["schoolid"];
    
    //Verificamos que la sesion no este expirada
    isSessionValid($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 3))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    $sql = "SELECT name FROM schools WHERE id = ".$schoolid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    $row = $rs->fetch_assoc();
        
    $name = $row['name'];
    
    //Validamos que no tenga alumnos estimados
    $sql = "SELECT count(id) as qtyEstimated FROM estimatedpupils WHERE schoolid=".$schoolid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    $existpupil = $rs->fetch_assoc();
    
    //Validamos que no tenga pagos
    $sql = "SELECT count(id) as qtyPayments FROM payments WHERE schoolid=".$schoolid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    $existpay = $rs->fetch_assoc();
    
    //Si no posee pagos o estudiantes podemos eliminarlo
    if($existpay["qtyPayments"] == 0 && $existpupil["qtyEstimated"] == 0){
        $sql = "DELETE FROM schools WHERE id=".$schoolid;
        if (!$rs=$db->query($sql)){
            if ($db->errno == 1451)
            badEnd("304",array("msg"=>"Existen dependencias que no permiten eliminar el registro"));
        else
            badEnd("500", array("msg"=>$db->error));
        }
    
        setAudit($db, "COLEGIOS", $sessionid, "Se elimino el colegio ".$name);
    
    }else{
        badEnd("304",array("msg"=>"No puede ser borrado el registro ya que posee alumnos/pagos"));
    }
    
    $out->id = $schoolid;
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>