<?php
    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");

    $parmsob = array("id","code","name","region","privat","email","contact","phone","phonesecundary","position","contactalt","emailalt","phonealt","positionalt","paymentverified","resetuser","sessionid");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros invalidos " . implode(", ", $parmsob)));
        
    
    $out = new stdClass();
    $schoolid = $_GET["id"];
    $code = $_GET["code"];
    $name = $_GET["name"];
    $region = $_GET["region"];
    $private = $_GET["privat"];
    $email = $_GET["email"];
    $contact = $_GET["contact"];
    $phone = $_GET["phone"];
    $phonesecundary = $_GET["phonesecundary"];
    $position = $_GET["position"];
    $contactalt = $_GET["contactalt"];
    $emailalt = $_GET["emailalt"];
    $phonealt = $_GET["phonealt"];
    $positionalt = $_GET["positionalt"];
    $paymentverified = $_GET["paymentverified"];
    $resetuser = $_GET["resetuser"];
    $sessionid = $_GET["sessionid"];
    $allowedPupils = '';
    $groups = '';
    
    if(isset($_GET['allowedpupils']) && $_GET['allowedpupils'] != ''){
        $allowedPupils = intval($_GET['allowedpupils']);
    }
    
    if(isset($_GET['groups']) && $_GET['groups'] != ''){
        $groups = $_GET['groups'];
    }
    
    //Verificamos que la sesion no este expirada
    isSessionValid($db, $sessionid);
    
    if($schoolid == 0){
        
        //Validamos que el usuario tenga privilegios
        if(!tienePrivilegio($db, $sessionid, 4))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
        
        $sql = "SELECT * FROM schools WHERE UPPER(email)='".$email."'";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
            
        $validEmail = $rs->fetch_assoc();
        if(!empty($validEmail)){
            badEnd("409", array("msg"=>$db->error.$sql));
        }else{
            $dataForInsert = "";
            //Asignamos los datos a los campos secundarios
            $dataForInsert .= $email == "null" ? " NULL, " : " '".$email."', ";
            $dataForInsert .= $contact == "null" ? " NULL, " : " '".$contact."', ";
            $dataForInsert .= $phone == "null" ? " NULL, " : " '".$phone."', ";
            $dataForInsert .= $phonesecundary == "null" ? " NULL, " : " '".$phonesecundary."', ";
            $dataForInsert .= $position == "null" ? " NULL, " : " '".$position."', ";
            $dataForInsert .= $contactalt == "null" ? " NULL, " : " '".$contactalt."', ";
            $dataForInsert .= $emailalt == "null" ? " NULL, " : " '".$emailalt."', ";
            $dataForInsert .= $phonealt == "null" ? " NULL, " : " '".$phonealt."', ";
            $dataForInsert .= $positionalt == "null" ? " NULL " : " '".$positionalt."'";
            
            $sql = "INSERT INTO schools(code,".($allowedPupils != '' ? 'allowedpupils,' : '')."name,region,private,email,contact,phone,phonesecundary,position,contactalt,emailalt,phonealt,positionalt,estimatedpupilsedit, asociations) ".
            "       VALUES(CONCAT(LPAD(1,'5','1100'),RIGHT(CRC32(1),2)),".($allowedPupils != '' ? $allowedPupils."," : '')."'".$name."','".$region."','".$private."',".
            "       ".$dataForInsert.", 1, '".$groups."')";
            if (!$db->query($sql))
                badEnd("500", array("msg"=>$db->error.$sql));
            
            $out->noentiendo = $sql;
            $out->id = $db->insert_id;
            
            $sql = "UPDATE schools SET".
            "       code = CONCAT(LPAD(".$out->id.",'5','1100'),RIGHT(CRC32(".$out->id."),2))".
            "       WHERE id = ".$out->id;
            if (!$db->query($sql))
                badEnd("500", array("msg"=>$db->error.$sql));
            
            if($email != "null" && $email != null){
                // SI se envia el email, creamos el usuario
                $sql = "INSERT INTO users(email, name, schoolid)".
                "       VALUES(".
                "       '".$email."', '".$contact."', ". $out->id.
                "       )";
                if (!$db->query($sql))
                    badEnd("500", array("msg"=>$db->error.$sql));
            }
            setAudit($db, "COLEGIOS", $sessionid, "Se agregó el colegio ".$name);
            
        }
    }else{
            
        if($resetuser == 1){
            
            //Validamos que el usuario tenga privilegios
            if(!tienePrivilegio($db, $sessionid, 5))
                badEnd("403", array("msg"=>"No tiene Privilegios"));
            
            //Colocamos los datos del colegio como nulos
            $sql = "UPDATE schools SET".
            "   email=NULL, contact=NULL,".
            "   phone=NULL, phonesecundary=NULL,".
            "   position=NULL, contactalt=NULL,".
            "   phonealt=NULL, emailalt=NULL,".
            "   positionalt=NULL,".
            "   hashregister=NULL".
            "   WHERE id=".$schoolid."";
            if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
                
            if($db->affected_rows == 0){
                badEnd("204", array("msg"=>"No se pudo modificar"));
            }
            
            //En caso de que ya existe el usuario se elimina, en caso contrario es que nunca llego a realizar el proceso completo de registro
            $sql = "DELETE FROM users WHERE schoolid=".$schoolid."";
            if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
            
            $out->id = $schoolid;
        }else{
            
            //Validamos que el usuario tenga privilegios
            if(!tienePrivilegio($db, $sessionid, 2))
                badEnd("403", array("msg"=>"No tiene Privilegios"));
            
            $sql = "SELECT id FROM schools WHERE id=".$schoolid;
            if (!$rs = $db->query($sql))
                badEnd("500", array("msg"=>$db->error));
            
            $row = $rs->fetch_assoc();
            if ($row["id"] != $schoolid)
                badEnd("204", array("msg"=>"No se encontró el registro"));
            
            $payValid = 0;
            if($private == 1){
                
                //Validamos que el usuario tenga privilegios
                if(!tienePrivilegio($db, $sessionid, 7))
                    badEnd("403", array("msg"=>"No tiene Privilegios"));
        
                //Verificamos que el colegio tenga pagos realizados
                $sql="SELECT id FROM payments WHERE schoolid=".$schoolid;
                if (!$rs=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
        
                $row= $rs->fetch_assoc();
    
                if($row["id"] != null){
                    $sql ="UPDATE payments SET ".
                    "   validated=".$paymentverified."".
                    "   WHERE schoolid=".$schoolid."";
                    if (!$rs=$db->query($sql))
                        badEnd("500", array("msg"=>$db->error));
                    
                    $payValid++;
                }
            }
            
            // Consultamos los alumnos permitidos
            $sql = "SELECT SUM(qty) AS qty ".
            "       FROM estimatedpupils ".
            "       WHERE schoolid = ".$schoolid;
            if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>$db->error.$sql));
                
            $allowEstimatedQty = $rs->fetch_assoc();
            
            // SI se envio allowedpupils
            if($allowedPupils != '' && $allowedPupils != $allowEstimatedQty['qty']){
                // Obtenemos la diferencia a sumar o restar
                    
                // SI es mayor agregamos a cualquier grado/seccion
                
                if($allowedPupils > $allowEstimatedQty['qty']){
                    $diffPupils = $allowedPupils - $allowEstimatedQty['qty'];
                        
                    $sql = "UPDATE estimatedpupils SET ".
                    "       qty = (qty + ".$diffPupils.") ".
                    "       WHERE schoolid = ".$schoolid.
                    "       AND level = 1 AND section = 'A'";
                    if (!$db->query($sql))
                        badEnd("500", array("msg"=>$db->error.$sql));
                    
                }else{
                    
                    $diffPupils = intval($allowEstimatedQty['qty']) - $allowedPupils;
                    
                    $out->aydua = $diffPupils;
                    
                    // Consultamos todos los estimados
                    $sql = "SELECT * FROM estimatedpupils ".
                    "       WHERE schoolid = ".$schoolid;
                    if (!$rs=$db->query($sql))
                        badEnd("500", array("msg"=>$db->error.$sql));
                        
                    while($row = $rs->fetch_assoc()){
                        if($diffPupils > 0){
                            
                            $out->aja [] = $diffPupils;
                            
                            if($diffPupils > $row['qty']){
                                
                                $sql = "UPDATE estimatedpupils SET ".
                                "       qty = 0".
                                "       WHERE schoolid = ".$schoolid.
                                "       AND id = ".$row['id'];
                                if (!$db->query($sql))
                                    badEnd("500", array("msg"=>$db->error.$sql));
                                    
                                $diffPupils = $diffPupils - $row['qty'];
                            }else{
                                $sql = "UPDATE estimatedpupils SET ".
                                "       qty = (qty - ".$diffPupils.")".
                                "       WHERE schoolid = ".$schoolid.
                                "       AND id = ".$row['id'];
                                if (!$db->query($sql))
                                    badEnd("500", array("msg"=>$db->error.$sql));
                                
                                
                                $diffPupils -= $diffPupils;
                            }
                        }
                    }
                }
            }
            
            $dataForUpdate = "";
            //Asignamos los datos a los campos secundarios
            $dataForUpdate .= $email == "null" ? " email = NULL, " : " email ='".$email."', ";
            $dataForUpdate .= $contact == "null" ? " contact = NULL, " : " contact = '".$contact."', ";
            $dataForUpdate .= $phone == "null" ? " phone = NULL, " : " phone = '".$phone."', ";
            $dataForUpdate .= $phonesecundary == "null" ? " phonesecundary = NULL, " : " phonesecundary = '".$phonesecundary."', ";
            $dataForUpdate .= $position == "null" ? " position = NULL, " : " position = '".$position."', ";
            $dataForUpdate .= $contactalt == "null" ? " contactalt = NULL, " : " contactalt = '".$contactalt."', ";
            $dataForUpdate .= $emailalt == "null" ? " emailalt = NULL, " : " emailalt = '".$emailalt."', ";
            $dataForUpdate .= $phonealt == "null" ? " phonealt = NULL, " : " phonealt = '".$phonealt."', ";
            $dataForUpdate .= $positionalt == "null" ? " positionalt = NULL, " : " positionalt = '".$positionalt."',";
            
            $sql = "UPDATE schools SET".
            "       ".$dataForUpdate." ".
            "       name='".$name."',".
            "       region='".$region."',".
            "       asociations = '".$groups."', ".
            "       private='".$private."'".
            "       WHERE id=".$schoolid." ";
            if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
            /*
            //Verificamos que se hicieron cambios
            if($db->affected_rows == 0 && $payValid == 0){
                badEnd("304", array("msg"=>"No se pudo modificar"));
            }*/
            
            $out->id= $schoolid;
            
            setAudit($db, "COLEGIOS", $sessionid, "Se actualizó el colegio ".$name);
        }
    }

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>