<?php 
    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");
    
    $parmsob = array("sessionid","id");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros invalidos " . implode(", ", $parmsob)));
        
    $sessionid = $_GET["sessionid"];
    $id = $_GET["id"];
    $out = new stdClass();
    
    //Verificamos que la sesion no este expirada
    isSessionValid($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 42))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    //Traemos la extension y id del alumno del examen
    $sql = "SELECT imgtype, pupilid FROM answers WHERE id=".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    $res = $rs->fetch_assoc();
    $extention = $res["imgtype"];
    $pupilid = $res["pupilid"];
    
    //Borramos el registro del examen
    $sql = "DELETE FROM answers WHERE id=".$id;
    
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    if ($db->affected_rows == 0){
        badEnd("304",array("msg"=>"No puede ser borrado el registro"));
    }
        
    $files = glob('../../uploads/assigned/'.$pupilid."_".$id.".".$extention);
    if(sizeof($files) > 0){
        if(copy($files[0],"../../uploads/err/".$pupilid."_".$id.".".$extention)){
            unlink($files[0]);
        }
    }else{
        badEnd("204", array("msg"=>"No se encuentra el registro" . implode(", ", $parmsob)));
    }
    
    $out->id = $id;
    
    $sql = "SELECT name, surname FROM pupils WHERE id=".$pupilid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    $row = $rs->fetch_assoc();
    
    setAudit($db, "EXAMENES", $sessionid, "Se elimino el examen de ".$row['name']." ".$row['surname']);
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>