<?php 
    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");
    
    $parmsob = array("sessionid","pupilid");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros invalidos " . implode(", ", $parmsob)));
        
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    $pupilid = $_GET["pupilid"];
    
    //Verificamos que la sesion no este expirada
    isSessionValid($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 39))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    //Obtenemos los datos del estudiante y del colegio
    $sql = "SELECT pupils.id AS pupilid, CONCAT(LPAD(pupils.id,'5','0'),RIGHT(CRC32(pupils.id),2)) AS code,".
    "       pupils.ci AS pupilci, pupils.name AS pupilname,".
    "       pupils.surname AS pupilsurname, pupils.gender AS pupilgender,".
    "       pupils.birthdate AS pupilbirth, pupils.level AS pupillevel,".
    "       pupils.section AS pupilsection,".
    "       schools.id AS schoolid, schools.name AS schoolname,".
    "       schools.region AS schoolregion, schools.code AS schoolcode,".
    "       schools.private AS schoolprivate, schools.email AS schoolemail".
    "       FROM schools, pupils".
    "       WHERE pupils.schoolid = schools.id AND".
    "       pupils.id = ".$pupilid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $student= $rs->fetch_assoc();
    
    if(sizeof($student) > 0){
        $out->entry = new stdClass();
        $out->entry->pupil = new stdClass();
        $out->entry->pupil->id = (int)$student["pupilid"];
        
        $out->entry->pupil->code = $student["code"];
        $out->entry->pupil->ci = $student["pupilci"];
        $out->entry->pupil->name = $student["pupilname"];
        $out->entry->pupil->surname = $student["pupilsurname"];
        $out->entry->pupil->gender = new stdClass();
        $out->entry->pupil->gender->id = $student["pupilgender"];
        $out->entry->pupil->gender->dsc = $student["pupilgender"] == "M" ? "Masculino" : "Femenino";
        
        $dateFormat = strtotime($student["pupilbirth"]);
    
        $out->entry->pupil->birthdate = new stdClass();
        $out->entry->pupil->birthdate->date = date("Y",$dateFormat).date("m",$dateFormat).date("d",$dateFormat);
        $out->entry->pupil->birthdate->formatted = $student["pupilbirth"];
        $out->entry->pupil->level = (int)$student["pupillevel"];
        $out->entry->pupil->section = $student["pupilsection"];
        
        $out->entry->school = new stdClass();
        
        $out->entry->school->id = (int)$student["schoolid"];
        $out->entry->school->code = $student["schoolcode"];
        $out->entry->school->name = $student["schoolname"];
        $out->entry->school->region = $student["schoolregion"];
        $out->entry->school->private = $student["schoolprivate"] == 1 ? true : false;
        $out->entry->school->email = $student["schoolemail"];
        
        //Contador para saber la cantidad de examenes
        $sql = "SELECT count(id) AS examQty FROM answers WHERE pupilid =".$student["pupilid"];
        if (!$exam=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        $count = $exam->fetch_assoc();
        
        if($count["examQty"] > 0){
            //Traemos los datos de los examenes
            $sql = "SELECT * from answers WHERE pupilid =".$student["pupilid"];
            if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
            
            //Recorremos los examenes existentes
            for($i = 0; $i < $count["examQty"]; $i++){
                $out->entry->test[$i] = new stdClass();
                
                $examdetail = $rs->fetch_assoc();
                
                //Traemos las referencias del examen
                $sql = "SELECT * from tests WHERE id =".$examdetail["testid"];
                if (!$refer=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
                
                $referdetail = $refer->fetch_assoc();
                
                $out->entry->test[$i]->id = $examdetail["id"];
                $out->entry->test[$i]->name = $referdetail["name"];
                $out->entry->test[$i]->extention = $examdetail["imgtype"];
                
                for($j = 1; $j <= 30; $j++){
                    $out->entry->test[$i]->answers[$j-1] = $examdetail["q".$j];
                    $out->entry->test[$i]->references[$j-1] = $referdetail["q".$j];
                    //$out->entry->test[$i]->qualification[$j-1] = 20;
                    
                    if($referdetail["q".$j] == 0){
                        $out->entry->test[$i]->qualification[$j-1] = 0;
                    }else if($referdetail["q".$j] == $examdetail["q".$j]){
                        
                        switch(intval($referdetail["dif".$j])){
                            case 1:
                                $out->entry->test[$i]->qualification[$j-1] = $referdetail['ptsoklow'];
                                break;
                            case 2:
                                $out->entry->test[$i]->qualification[$j-1] = $referdetail['ptsokmid'];
                                break;
                            case 3:
                                $out->entry->test[$i]->qualification[$j-1] = $referdetail['ptsokhigh'];
                                break;
                            default:
                                $out->entry->test[$i]->qualification[$j-1] = 0;
                        }
                        
                    }else{
                        
                        switch(intval($referdetail["dif".$j])){
                            case 1:
                                $out->entry->test[$i]->qualification[$j-1] = -$referdetail['ptsbadlow'];
                                break;
                            case 2:
                                $out->entry->test[$i]->qualification[$j-1] = -$referdetail['ptsbadmid'];
                                break;
                            case 3:
                                $out->entry->test[$i]->qualification[$j-1] = -$referdetail['ptsbadhigh'];
                                break;
                            default:
                                $out->entry->test[$i]->qualification[$j-1] = 0;
                        }
                        
                    }
                }
            }
            
        }
    }else{
        badEnd("404", array("msg"=>"Alumno no encontrado"));
    }
    
        
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    function determinateScore($correct,$answer,$pts){
        
    }
?>