<?php ini_set("memory_limit","-1")?>
<?php 
    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");
    
    $parmsob = array("sessionid","numofrecords");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros invalidos " . implode(", ", $parmsob)));
        
    $sessionid = $_GET["sessionid"];
    $out = new stdClass();
    $out->numofrecords = 0;
    
    //Verificamos que la sesion no este expirada
    isSessionValid($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 39))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
        
    //Obtenemos los archivos del directorio
    $files = glob('../../uploads/err/*');
    
    foreach($files as $file=>$valueName){
        $out->numofrecords++;
        if(@is_array(getimagesize($valueName))){
            $out->records[$file] = new stdClass();
            $out->records[$file]->filename = basename($valueName);
        }
    }
        
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>