<?php 
    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");
    
    $parmsob = array("sessionid","offset","numofrecords","order");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros invalidos " . implode(", ", $parmsob)));
        
    $sessionid = $_GET["sessionid"];
    $filter = '';
    $region = '';
    $schoolid = '';
    $schooltype = '';
    $level = '';
    $offset = $_GET["offset"];
    $number = $_GET["numofrecords"];
    $order = $_GET["order"];
    $test = '';
    $kindTests = determinateKindTests($_GET['kindTests']);
    
    $out = new stdClass();
    
    //Verificamos que la sesion no este expirada
    isSessionValid($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 39))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    // SI recibimos filter, armamos el query
    if( isset($_GET['filter']) && $_GET['filter'] != '' ){
        
        $filterarr = explode(' ',$_GET['filter']);
        $str = '';
        
        foreach($filterarr as $index => $fil){
            if($index == 0){
                $str .= " OR ( pupils.name LIKE '%".$fil."%' ";
            }else{
                $str .= " AND pupils.surname LIKE '%".$fil."%' ";
            }
        }
        
        if($str != ''){
            $str .= " ) ";
        }
        
        $out->str = $filterarr;
        
        $filter = " AND (".
        "       CONCAT(LPAD(pupils.id,'5','0'),RIGHT(CRC32(pupils.id),2)) LIKE '%".$_GET['filter']."%' ".
        "       ".$str.
        "       OR pupils.name LIKE '%".$_GET['filter']."%'".
        "       OR pupils.surname LIKE '%".$_GET['filter']."%'".
        "       OR CONCAT(pupils.name,' ', pupils.surname) LIKE '%".$_GET['filter']."%'".
        "       OR pupils.ci LIKE '%".$_GET['filter']."%' ".
        "       OR schools.name LIKE '%".$_GET['filter']."%'".
        "       OR schools.region LIKE '%".$_GET['filter']."%'".
        "       )";
    }
    
    // SI recibimos level, armamos el query
    if( isset($_GET['level']) && $_GET['level'] != '' ){
        $level = " AND pupils.level=".$_GET['level'];
    }
    
    // SI recibimos region, armamos el query
    if( isset($_GET['regionid']) && $_GET['regionid'] != '' ){
        $region = " AND schools.region='".$_GET['regionid']."'";
    }
    
    // SI recibimos schoolid, armamos el query
    if( isset($_GET['schoolid']) && $_GET['schoolid'] != '' ){
        $schoolid = " AND schools.id=".$_GET['schoolid'];
    }
    
    // SI recibimos schooltype, armamos el query
    if( isset($_GET['schooltype']) && $_GET['schooltype'] != '' ){
        $schooltype = " AND schools.private=".$_GET['schooltype'];
    }
    
    if(isset($_GET['test']) && $_GET['test'] != ''){
        if($_GET['test'] == '0'){
            $test = " AND (SELECT COUNT(answers.id) ".
            "       FROM answers ".
            "       WHERE answers.pupilid = pupils.id) = 0 ";
        }else{
            $test = " AND (SELECT COUNT(answers.id) ".
            "       FROM answers, tests ".
            "       WHERE answers.pupilid = pupils.id ".
            "       AND tests.id = answers.testid ".
            "       AND tests.name LIKE '%".$_GET['test']."%' ) > 0 ";
        }
    }
    
    //Contamos el total de alumnos existentes
    $sql = "SELECT count(pupils.id) as number FROM pupils, schools ".
    "       WHERE pupils.schoolid = schools.id ".
    "       ".$region.
    "       ".$level.
    "       ".$filter.
    "       ".$test.
    "       ".$schoolid.
    "       ".$kindTests.
    "       ".$schooltype;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error. "fallo cantidad"));
    
    $row = $rs->fetch_assoc();
    
    //Guardamos el total de alumnos existentes
    $out->numofrecords = (int)$row["number"];
        
    $sql = "SELECT DISTINCT pupils.*, schools.id as collegeId,".
    "       CONCAT(LPAD(pupils.id,'7','0'),RIGHT(CRC32(pupils.id),2)) as code, ".
    "       test.id AS testid, an.id AS respId, ".
    "       schools.code as collegeCode, schools.name as collegeName,".
    "       schools.region as collegeRegion, schools.private as collegePriv, schools.email as collegeEmail, ".
    "       ".queryForScore(30).
    "       FROM schools, pupils ".
    "       LEFT JOIN answers an ON an.pupilid = pupils.id ".
    "       LEFT JOIN tests test ON an.testid = test.id ".
    "       WHERE pupils.schoolid = schools.id".
    "       ".$region.
    "       ".$level.
    "       ".$test.
    "       ".$filter.
    "       ".$schoolid.
    "       ".$schooltype.
    "       ".$kindTests.
    "       ORDER BY ".$order." ".
    "       LIMIT ".$offset.",".$number." ";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error . "toda la data"));
    
    for($i = 0; $i < $number; $i++){
        $student= $rs->fetch_assoc();
        
        $out->records[$i] = new stdClass();
        $out->records[$i]->pupil = new stdClass();
        $out->records[$i]->pupil->id = (int)$student["id"];
        
        $out->records[$i]->pupil->code = $student["code"];
        $out->records[$i]->pupil->ci = $student["ci"];
        $out->records[$i]->pupil->name = $student["name"];
        $out->records[$i]->pupil->surname = $student["surname"];
        $out->records[$i]->pupil->gender = new stdClass();
        $out->records[$i]->pupil->gender->id = $student["gender"];
        $out->records[$i]->pupil->gender->dsc = $student["gender"] == "M" ? "Masculino" : "Femenino";
        
        $dateFormat = strtotime($student["birthdate"]);
    
        $out->records[$i]->pupil->birthdate = new stdClass();
        $out->records[$i]->pupil->birthdate->date = date("Y",$dateFormat).date("m",$dateFormat).date("d",$dateFormat);
        $out->records[$i]->pupil->birthdate->formatted = $student["birthdate"];
        $out->records[$i]->pupil->level = (int)$student["level"];
        $out->records[$i]->pupil->section = $student["section"];
        
        $out->records[$i]->school = new stdClass();
        
        $out->records[$i]->school->id = (int)$student["collegeId"];
        $out->records[$i]->school->code = $student["collegeCode"];
        $out->records[$i]->school->name = $student["collegeName"];
        $out->records[$i]->school->region = $student["collegeRegion"];
        $out->records[$i]->school->private = $student["collegePriv"] == 1 ? true : false;
        $out->records[$i]->school->email = $student["collegeEmail"];
        
        $idPupil = $student["id"] == 0 ? 1 : $student["id"];
        $sql = "SELECT count(id) AS examQty FROM answers WHERE pupilid =".$idPupil;
        if (!$exam=$db->query($sql))
            badEnd("500", array("msg"=>$db->error . "fallo contador ".$student["id"]));
        
        $resexam = $exam->fetch_assoc();
        
        $out->records[$i]->testnumber = $student["respId"] == null ? 0 : (int)$student["respId"];
        $out->records[$i]->qualification = $resexam["examQty"] == 0 ? "--" : (int)$student['score'];
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    function queryForScore($questionsqty){
        $str = ' IF(test.id IS NULL, 0, ( test.ptsini ';
        
        for($i = 1; $i <= $questionsqty; $i++){
            $str .= " + 
            IF(test.q$i = 0, 0, 
                IF(test.q$i = an.q$i, 
           	    	CASE
               	    	WHEN test.dif$i = 1 THEN test.ptsoklow
                    	WHEN test.dif$i = 2 THEN test.ptsokmid
                    	WHEN test.dif$i = 3 THEN test.ptsokhigh
              	    END,
              	    CASE
                   		WHEN test.dif$i = 1 THEN -test.ptsbadlow
                   		WHEN test.dif$i = 2 THEN -test.ptsbadmid
                   		WHEN test.dif$i = 3 THEN -test.ptsbadhigh
                   	END
                ) 
            ) ";
        }
        
        $str .= ' ) ) AS score ';
        
        return $str;
    }
    
    // 1 = es igual a presencial
    // 2 = es igual a virtual
    function determinateKindTests($kind){
        $str = '';
        
        switch($kind){
            case 1:
                $str = " AND (SELECT COUNT(answers.id) ".
                    "       FROM answers ".
                    "       WHERE answers.pupilid = pupils.id ".
                    "       AND answers.imgtype IS NOT NULL) > 0 ";
                break;
            case 2:
                $str = " AND (SELECT COUNT(answers.id) ".
                    "       FROM answers ".
                    "       WHERE answers.pupilid = pupils.id ".
                    "       AND answers.imgtype IS NULL) > 0 ";
                break;
        }
        
        return $str;
    }
?>