<?php ini_set("memory_limit","-1")?>
<?php 
    header("Content-Type:application/json; charset=UTF-8");
    header('Content-Encoding: UTF-8');
    include("../connection.php");
    include("../utils.php");
    
    $parmsob = array("sessionid","order","numofrecords","offset");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros invalidos " . implode(", ", $parmsob)));
        
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    $order = "";
    $number = $_GET["numofrecords"];
    $offset = $_GET["offset"];
    $level = "";
    $schoolid = "";
    $region = "";
    $filter = "";
    $test = '';
    $schooltype = '';
    $kindTests = determinateKindTests($_GET['kindTests']);
    
    //Verificamos que la sesion no este expirada
    isSessionValid($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 8))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    if(isset($_GET["order"]) && $_GET["order"] != ""){
        $order = " ORDER BY ".$_GET["order"]." ";
    }
    
    if(isset($_GET["region"]) && $_GET["region"] != ""){
        $region = " AND schools.region = '".$_GET["region"]."' ";
    }
    
    if(isset($_GET["schoolid"]) && $_GET["schoolid"] != ""){
        $schoolid = "AND schools.id = ".$_GET["schoolid"]." ";
    }
    
    if(isset($_GET["level"]) && $_GET["level"] != ""){
        $level = " AND pupils.level = ".$_GET["level"]." ";
    }
    
    if(isset($_GET['test']) && $_GET['test'] != ''){
        if($_GET['test'] == '0'){
            $test = " AND (SELECT COUNT(answers.id) ".
            "       FROM answers ".
            "       WHERE answers.pupilid = pupils.id) = 0 ";
        }else{
            $test = " AND (SELECT COUNT(answers.id) ".
            "       FROM answers, tests ".
            "       WHERE answers.pupilid = pupils.id ".
            "       AND tests.id = answers.testid ".
            "       AND tests.name LIKE '%".$_GET['test']."%' ) > 0 ";
        }
    }
    
    if(isset($_GET["schooltype"]) && $_GET["schooltype"] != ""){
        $schooltype = " AND schools.private = ".$_GET["schooltype"]." ";
    }
    
    if(isset($_GET["filter"]) && $_GET["filter"] != ""){
        
        $filterarr = explode(' ',$_GET['filter']);
        $str = '';
        
        foreach($filterarr as $index => $fil){
            if($index == 0){
                $str .= " OR ( pupils.name LIKE '%".$fil."%' ";
            }else{
                $str .= " AND pupils.surname LIKE '%".$fil."%' ";
            }
        }
        
        if($str != ''){
            $str .= " ) ";
        }
        
        $filter = " AND (".
        "       CONCAT(LPAD(pupils.id,'5','0'),RIGHT(CRC32(pupils.id),2)) LIKE '%".$_GET['filter']."%' ".
        "       ".$str.
        "       OR pupils.name LIKE '%".$_GET['filter']."%'".
        "       OR pupils.surname LIKE '%".$_GET['filter']."%'".
        "       OR CONCAT(pupils.name,' ', pupils.surname) LIKE '%".$_GET['filter']."%'".
        "       OR pupils.ci LIKE '%".$_GET['filter']."%' ".
        "       OR schools.name LIKE '%".$_GET['filter']."%'".
        "       OR schools.region LIKE '%".$_GET['filter']."%'".
        "       )";
    }
    
    //Contamos el total de alumnos existentes
    $sql = "SELECT count(pupils.id) as number FROM pupils, schools ".
    "       WHERE pupils.schoolid = schools.id ".
    "       ".$region.
    "       ".$test.
    "       ".$filter.
    "       ".$level.
    "       ".$schooltype.
    "       ".$schoolid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    $row = $rs->fetch_assoc();
    
    //Guardamos el total de alumnos existentes
    $out->numofrecords = (int)$row["number"];
    
    //Traemos los codigos de los alumnos
    //CONCAT(LPAD(pupils.id,'5','0'),RIGHT(CRC32(pupils.id),2))
    $sql = "SELECT CONCAT(LPAD(pupils.id,'5','0'),RIGHT(CRC32(pupils.id),2)) as code, ".
    "       ".queryForScore(30).
    "       FROM schools, pupils".
    "       LEFT JOIN answers an ON an.pupilid = pupils.id ".
    "       LEFT JOIN tests test ON an.testid = test.id ".
    "       WHERE pupils.schoolid = schools.id ".
    "       ".$region.
    "       ".$test.
    "       ".$filter.
    "       ".$level.
    "       ".$schoolid.
    "       ".$kindTests.
    "       ".$schooltype.
    "       ".$order.
    "       LIMIT ".$offset.",".$number." ";
    
     if (!$coders=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $sql = "SELECT pupils.*, schools.id as collegeId,".
    "       schools.code as collegeCode, schools.name as collegeName,".
    "       schools.region as collegeRegion, schools.private as collegePriv, schools.email as collegeEmail,".
    "       ".queryForScore(30).
    "       FROM schools, pupils ".
    "       LEFT JOIN answers an ON an.pupilid = pupils.id ".
    "       LEFT JOIN tests test ON an.testid = test.id ".
    "       WHERE pupils.schoolid = schools.id".
    "       ".$region.
    "       ".$test.
    "       ".$filter.
    "       ".$level.
    "       ".$schoolid.
    "       ".$kindTests.
    "       ".$schooltype.
    "       ".$order.
    "       LIMIT ".$offset.",".$number;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
        
    for($i = 0; $i < $number; $i++){
        $code = $coders->fetch_assoc();
        $student= $rs->fetch_assoc();
        
        $out->records[$i] = new stdClass();
        $out->records[$i]->pupil = new stdClass();
        $out->records[$i]->pupil->id = (int)$student["id"];
        
        $out->records[$i]->pupil->code = $code["code"];
        $out->records[$i]->pupil->ci = $student["ci"];
        $out->records[$i]->pupil->name = $student["name"];
        $out->records[$i]->pupil->surname = $student["surname"];
        $out->records[$i]->pupil->gender = new stdClass();
        $out->records[$i]->pupil->gender->id = $student["gender"];
        $out->records[$i]->pupil->gender->dsc = $student["gender"] == "M" ? "Masculino" : "Femenino";
        
        $dateFormat = strtotime($student["birthdate"]);
    
        $out->records[$i]->pupil->birthdate = new stdClass();
        $out->records[$i]->pupil->birthdate->date = date("Y",$dateFormat).date("m",$dateFormat).date("d",$dateFormat);
        $out->records[$i]->pupil->birthdate->formatted = $student["birthdate"];
        $out->records[$i]->pupil->level = (int)$student["level"];
        $out->records[$i]->pupil->section = $student["section"];
        
        $out->records[$i]->school = new stdClass();
        
        $out->records[$i]->school->id = (int)$student["collegeId"];
        $out->records[$i]->school->code = $student["collegeCode"];
        $out->records[$i]->school->name = $student["collegeName"];
        $out->records[$i]->school->region = $student["collegeRegion"];
        $out->records[$i]->school->private = $student["collegePriv"] == 1 ? true : false;
        $out->records[$i]->school->email = $student["collegeEmail"];
        
        $out->records[$i]->results = new stdClass();
        
        $out->records[$i]->results->correct = (int)$student['score'];
        
        if($kindTests != ''){
            $out->records[$i]->modalidad = $_GET['kindTests'] == 1 ? 'Presencial' : 'Virtual';
        }else{
            $out->records[$i]->modalidad = '';
        }
    }
    
    $parmsob = array("csv");
    if (parametrosValidos($_GET, $parmsob)){
        //eliminar documentos anteriores
        $files = glob('exports/*');
        foreach($files as $file){
            if(is_file($file))
                unlink($file);
        }
        
        //Eliminar zip anterior
        $files = glob('*.zip');
        foreach($files as $file){
            if(is_file($file))
                unlink($file);
        }
        
        // Abrimos un archivo global
        $csvall = fopen('exports/TODOS.csv','w');
        
        fwrite($csvall, $BOM);
        $line = array('','','','','','','', '','','','','','DIFICULTAD','','','COMPONENTE-COMPETENCIA','','','','','','','','');
        $line = array_map("utf8_decode", $line);
        fputcsv($csvall, $line, ';', '"');
        $line = array('COD.','GRADO','SECCIÓN','NOMBRE','APELLIDO','CI','FEC. NAC', 'GÉNERO','ESTADO','COLEGIO','TIPO','NOTA DE EXAMEN','MODALIDAD','REP','CON','REF','NV-CRM','NV-RA','NV-PRP','GM-CRM','GM-RA','GM-PRP','A-CRM','A-RA','A-PRP');
        $line = array_map("utf8_decode", $line);
        fputcsv($csvall, $line, ';', '"');
        
        for($i = 0; $i < $number; $i++){
            
            $low = 0;
            $mid = 0;
            $high = 0;
            
            $nvCrm = 0;
            $nvRa = 0;
            $nvPrp = 0;
            
            $gmCrm = 0;
            $gmRa = 0;
            $gmPrp = 0;
            
            $aCrm = 0;
            $aRa = 0;
            $aPrp = 0;
            
            //Contador para saber la cantidad de examenes
            $sql = "SELECT count(id) AS examQty FROM answers WHERE pupilid =".$out->records[$i]->pupil->id;
            if (!$exam=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
            
            $count = $exam->fetch_assoc();
            
            if($count["examQty"] > 0){
                //Traemos los datos de los examenes
                $sql = "SELECT * from answers WHERE pupilid =".$out->records[$i]->pupil->id;
                if (!$res=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
                
                //Recorremos los examenes existentes
                $examdetail = $res->fetch_assoc();
                
                //Traemos las referencias del examen
                $sql = "SELECT * from tests WHERE id =".$examdetail["testid"];
                if (!$refer=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
                
                $referdetail = $refer->fetch_assoc();
                
                for($j = 1; $j <= 30; $j++){
                    
                    if($referdetail["q".$j] == $examdetail["q".$j]){
                        
                        switch(intval($referdetail["dif".$j])){
                            case 1:
                                $low += $referdetail['ptsoklow'];
                                // 1 = NV, 2 = GM, 3 = A
                                switch(intval($referdetail["comp".$j])){
                                    case 1:
                                        // 1 = CRM, 2 = RA, 3 = PRP
                                        switch(intval($referdetail["compet".$j])){
                                            case 1:
                                                $nvCrm +=  $referdetail['ptsoklow'];
                                                break;
                                            case 2:
                                                $nvRa +=  $referdetail['ptsoklow'];
                                                break;
                                            case 3:
                                                $nvPrp +=  $referdetail['ptsoklow'];
                                                break;
                                        }
                                        break;
                                    case 2:
                                        // 1 = CRM, 2 = RA, 3 = PRP
                                        switch(intval($referdetail["compet".$j])){
                                            case 1:
                                                $gmCrm +=  $referdetail['ptsoklow'];
                                                break;
                                            case 2:
                                                $gmRa +=  $referdetail['ptsoklow'];
                                                break;
                                            case 3:
                                                $gmPrp +=  $referdetail['ptsoklow'];
                                                break;
                                        }
                                        break;
                                    case 3:
                                        // 1 = CRM, 2 = RA, 3 = PRP
                                        switch(intval($referdetail["compet".$j])){
                                            case 1:
                                                $aCrm +=  $referdetail['ptsoklow'];
                                                break;
                                            case 2:
                                                $aRa +=  $referdetail['ptsoklow'];
                                                break;
                                            case 3:
                                                $aPrp +=  $referdetail['ptsoklow'];
                                                break;
                                        }
                                        break;
                                }
                                break;
                            case 2:
                                $mid +=$referdetail['ptsokmid'];
                                // 1 = NV, 2 = GM, 3 = A
                                switch(intval($referdetail["comp".$j])){
                                    case 1:
                                        // 1 = CRM, 2 = RA, 3 = PRP
                                        switch(intval($referdetail["compet".$j])){
                                            case 1:
                                                $nvCrm +=  $referdetail['ptsokmid'];
                                                break;
                                            case 2:
                                                $nvRa +=  $referdetail['ptsokmid'];
                                                break;
                                            case 3:
                                                $nvPrp +=  $referdetail['ptsokmid'];
                                                break;
                                        }
                                        break;
                                    case 2:
                                        // 1 = CRM, 2 = RA, 3 = PRP
                                        switch(intval($referdetail["compet".$j])){
                                            case 1:
                                                $gmCrm +=  $referdetail['ptsokmid'];
                                                break;
                                            case 2:
                                                $gmRa +=  $referdetail['ptsokmid'];
                                                break;
                                            case 3:
                                                $gmPrp +=  $referdetail['ptsokmid'];
                                                break;
                                        }
                                        break;
                                    case 3:
                                        // 1 = CRM, 2 = RA, 3 = PRP
                                        switch(intval($referdetail["compet".$j])){
                                            case 1:
                                                $aCrm +=  $referdetail['ptsokmid'];
                                                break;
                                            case 2:
                                                $aRa +=  $referdetail['ptsokmid'];
                                                break;
                                            case 3:
                                                $aPrp +=  $referdetail['ptsokmid'];
                                                break;
                                        }
                                        break;
                                }
                                break;
                            case 3:
                                $high +=$referdetail['ptsokhigh'];
                                // 1 = NV, 2 = GM, 3 = A
                                switch(intval($referdetail["comp".$j])){
                                    case 1:
                                        // 1 = CRM, 2 = RA, 3 = PRP
                                        switch(intval($referdetail["compet".$j])){
                                            case 1:
                                                $nvCrm +=  $referdetail['ptsokhigh'];
                                                break;
                                            case 2:
                                                $nvRa +=  $referdetail['ptsokhigh'];
                                                break;
                                            case 3:
                                                $nvPrp +=  $referdetail['ptsokhigh'];
                                                break;
                                        }
                                        break;
                                    case 2:
                                        // 1 = CRM, 2 = RA, 3 = PRP
                                        switch(intval($referdetail["compet".$j])){
                                            case 1:
                                                $gmCrm +=  $referdetail['ptsokhigh'];
                                                break;
                                            case 2:
                                                $gmRa +=  $referdetail['ptsokhigh'];
                                                break;
                                            case 3:
                                                $gmPrp +=  $referdetail['ptsokhigh'];
                                                break;
                                        }
                                        break;
                                    case 3:
                                        // 1 = CRM, 2 = RA, 3 = PRP
                                        switch(intval($referdetail["compet".$j])){
                                            case 1:
                                                $aCrm +=  $referdetail['ptsokhigh'];
                                                break;
                                            case 2:
                                                $aRa +=  $referdetail['ptsokhigh'];
                                                break;
                                            case 3:
                                                $aPrp +=  $referdetail['ptsokhigh'];
                                                break;
                                        }
                                        break;
                                }
                                break;
                        }
                        
                    }else{
                        
                        switch(intval($referdetail["dif".$j])){
                            case 1:
                                $low  -= $referdetail['ptsbadlow'];
                                // 1 = NV, 2 = GM, 3 = A
                                switch(intval($referdetail["comp".$j])){
                                    case 1:
                                        // 1 = CRM, 2 = RA, 3 = PRP
                                        switch(intval($referdetail["compet".$j])){
                                            case 1:
                                                $nvCrm -=  $referdetail['ptsbadlow'];
                                                break;
                                            case 2:
                                                $nvRa -=  $referdetail['ptsbadlow'];
                                                break;
                                            case 3:
                                                $nvPrp -=  $referdetail['ptsbadlow'];
                                                break;
                                        }
                                        break;
                                    case 2:
                                        // 1 = CRM, 2 = RA, 3 = PRP
                                        switch(intval($referdetail["compet".$j])){
                                            case 1:
                                                $gmCrm -=  $referdetail['ptsbadlow'];
                                                break;
                                            case 2:
                                                $gmRa -=  $referdetail['ptsbadlow'];
                                                break;
                                            case 3:
                                                $gmPrp -=  $referdetail['ptsbadlow'];
                                                break;
                                        }
                                        break;
                                    case 3:
                                        // 1 = CRM, 2 = RA, 3 = PRP
                                        switch(intval($referdetail["compet".$j])){
                                            case 1:
                                                $aCrm -=  $referdetail['ptsbadlow'];
                                                break;
                                            case 2:
                                                $aRa -=  $referdetail['ptsbadlow'];
                                                break;
                                            case 3:
                                                $aPrp -=  $referdetail['ptsobadlow'];
                                                break;
                                        }
                                        break;
                                }
                                break;
                            case 2:
                                $mid  -= $referdetail['ptsbadmid'];
                                // 1 = NV, 2 = GM, 3 = A
                                switch(intval($referdetail["comp".$j])){
                                    case 1:
                                        // 1 = CRM, 2 = RA, 3 = PRP
                                        switch(intval($referdetail["compet".$j])){
                                            case 1:
                                                $nvCrm -=  $referdetail['ptsbadmid'];
                                                break;
                                            case 2:
                                                $nvRa -=  $referdetail['ptsbadmid'];
                                                break;
                                            case 3:
                                                $nvPrp -=  $referdetail['ptsbadmid'];
                                                break;
                                        }
                                        break;
                                    case 2:
                                        // 1 = CRM, 2 = RA, 3 = PRP
                                        switch(intval($referdetail["compet".$j])){
                                            case 1:
                                                $gmCrm -=  $referdetail['ptsbadmid'];
                                                break;
                                            case 2:
                                                $gmRa -=  $referdetail['ptsbadmid'];
                                                break;
                                            case 3:
                                                $gmPrp -=  $referdetail['ptsbadmid'];
                                                break;
                                        }
                                        break;
                                    case 3:
                                        // 1 = CRM, 2 = RA, 3 = PRP
                                        switch(intval($referdetail["compet".$j])){
                                            case 1:
                                                $aCrm -=  $referdetail['ptsbadmid'];
                                                break;
                                            case 2:
                                                $aRa -=  $referdetail['ptsbadmid'];
                                                break;
                                            case 3:
                                                $aPrp -=  $referdetail['ptsobadmid'];
                                                break;
                                        }
                                        break;
                                }
                                break;
                            case 3:
                                $high  -= $referdetail['ptsbadhigh'];
                                // 1 = NV, 2 = GM, 3 = A
                                switch(intval($referdetail["comp".$j])){
                                    case 1:
                                        // 1 = CRM, 2 = RA, 3 = PRP
                                        switch(intval($referdetail["compet".$j])){
                                            case 1:
                                                $nvCrm -=  $referdetail['ptsbadhigh'];
                                                break;
                                            case 2:
                                                $nvRa -=  $referdetail['ptsbadhigh'];
                                                break;
                                            case 3:
                                                $nvPrp -=  $referdetail['ptsbadhigh'];
                                                break;
                                        }
                                        break;
                                    case 2:
                                        // 1 = CRM, 2 = RA, 3 = PRP
                                        switch(intval($referdetail["compet".$j])){
                                            case 1:
                                                $gmCrm -=  $referdetail['ptsbadhigh'];
                                                break;
                                            case 2:
                                                $gmRa -=  $referdetail['ptsbadhigh'];
                                                break;
                                            case 3:
                                                $gmPrp -=  $referdetail['ptsbadhigh'];
                                                break;
                                        }
                                        break;
                                    case 3:
                                        // 1 = CRM, 2 = RA, 3 = PRP
                                        switch(intval($referdetail["compet".$j])){
                                            case 1:
                                                $aCrm -=  $referdetail['ptsbadhigh'];
                                                break;
                                            case 2:
                                                $aRa -=  $referdetail['ptsbadhigh'];
                                                break;
                                            case 3:
                                                $aPrp -=  $referdetail['ptsobadhigh'];
                                                break;
                                        }
                                        break;
                                }
                                break;
                        }
                        
                    }
                }
            }
            
            $arr[$i] = array( $out->records[$i]->pupil->code,
                $out->records[$i]->pupil->level,
                $out->records[$i]->pupil->section,
                $out->records[$i]->pupil->name,
                $out->records[$i]->pupil->surname,
                $out->records[$i]->pupil->ci,
                $out->records[$i]->pupil->birthdate->formatted,
                $out->records[$i]->pupil->gender->id,
                $out->records[$i]->school->region,
                $out->records[$i]->school->name,
                ($out->records[$i]->school->private == true ? 'Privado' : 'Oficial'),
                $out->records[$i]->results->correct,
                $out->records[$i]->modalidad,
                $low,
                $mid,
                $high,
                $nvCrm, $nvRa, $nvPrp,
                $gmCrm, $gmRa, $gmPrp,
                $aCrm, $aRa, $aPrp);
                
                //$line = array('REF','NV-CRM','NV-RA','NV-PRP','GM-CRM','GM-RA','GM-PRP','A-CRM','A-RA','A-PRP');
        
        }
        
        for($i = 0; $i < $number; $i++){
            $arr[$i] = array_map("utf8_decode", $arr[$i]);
            fputcsv($csvall, $arr[$i],';');
        }
        
        fclose($csvall);
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    function queryForScore($questionsqty){
        $str = ' IF(test.id IS NULL, 0, ( test.ptsini ';
        
        for($i = 1; $i <= $questionsqty; $i++){
            $str .= " + 
            IF(test.q$i = 0, 0, 
                IF(test.q$i = an.q$i, 
           	    	CASE
               	    	WHEN test.dif$i = 1 THEN test.ptsoklow
                    	WHEN test.dif$i = 2 THEN test.ptsokmid
                    	WHEN test.dif$i = 3 THEN test.ptsokhigh
              	    END,
              	    CASE
                   		WHEN test.dif$i = 1 THEN -test.ptsbadlow
                   		WHEN test.dif$i = 2 THEN -test.ptsbadmid
                   		WHEN test.dif$i = 3 THEN -test.ptsbadhigh
                   	END
                ) 
            ) ";
        }
        
        $str .= ' ) ) AS score ';
        
        return $str;
    }
    
    function queryForScoreOrder($questionsqty){
        $str = ' IF(test.id IS NULL, 0, ( test.ptsini ';
        
        for($i = 1; $i <= $questionsqty; $i++){
            $str .= " + 
            IF(test.q$i = 0, 0, 
                IF(test.q$i = an.q$i, 
           	    	CASE
               	    	WHEN test.dif$i = 1 THEN test.ptsoklow
                    	WHEN test.dif$i = 2 THEN test.ptsokmid
                    	WHEN test.dif$i = 3 THEN test.ptsokhigh
              	    END,
              	    CASE
                   		WHEN test.dif$i = 1 THEN -test.ptsbadlow
                   		WHEN test.dif$i = 2 THEN -test.ptsbadmid
                   		WHEN test.dif$i = 3 THEN -test.ptsbadhigh
                   	END
                ) 
            ) ";
        }
        
        $str .= ' ) ) DESC';
        
        return $str;
    }
    
    // 1 = es igual a presencial
    // 2 = es igual a virtual
    function determinateKindTests($kind){
        $str = '';
        
        switch($kind){
            case 1:
                $str = " AND (SELECT COUNT(answers.id) ".
                    "       FROM answers ".
                    "       WHERE answers.pupilid = pupils.id ".
                    "       AND answers.imgtype IS NOT NULL) > 0 ";
                break;
            case 2:
                $str = " AND (SELECT COUNT(answers.id) ".
                    "       FROM answers ".
                    "       WHERE answers.pupilid = pupils.id ".
                    "       AND answers.imgtype IS NULL) > 0 ";
                break;
        }
        
        return $str;
    }
?>