<?php
    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");
    
    $parmsob = array("sessionid","id");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros invalidos " . implode(", ", $parmsob)));
    
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    $userid = $_GET["id"];
    
    //Verificamos que la sesion no este expirada
    isSessionValid($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 24))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    $sql = "SELECT id, name, email, ".
    "       status, rolid, schoolid, schools".
    "       FROM cmsusers ".
    "       WHERE id = ".$userid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row= $rs->fetch_assoc();
    
    if(empty($row)){
        badEnd("404", array("msg"=>"No encontrado"));
    }
    
    $schoolDefault = $row["schoolid"];
    
    $out->id = (int)$row["id"];
    $out->user = $row["name"];
    $out->name = $row["name"];
    $out->email = $row["email"];
    $out->status = new stdClass();
    $out->status->id = (int)$row["status"];
    $out->status->dsc = (int)$row["status"] == 1 ? "Activo" : "Bloqueado";
    
    if($row['rolid'] == null){
        $out->rol = null;
    }else{
        //COnsultamos el rol que poseemos
        $sql = "SELECT * FROM cmsusers ".
        "       WHERE id = ".$row['rolid'].
        "       AND type = 0";
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        $rowRol = $res->fetch_assoc();
        
        $out->rol = new stdClass();
        $out->rol->id = (int)$rowRol['id'];
        $out->rol->roldsc = $rowRol['name'];
        
        $out->rol->rolmodified = false;
    }
    
    $out->privileges = new stdClass();
    $out->privileges->created = true;
    $out->privileges->read = true;
    $out->privileges->update = true;
    $out->privileges->delete = true;
    
    $arrschools = explode('-',$row["schools"]);

    $sql = "SELECT id, code, name, region FROM schools";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $cont = 0;
    while($row = $rs->fetch_assoc()){
        $out->schools->records[$cont] = new stdClass();
        $out->schools->records[$cont]->id = (int)$row["id"];
        $out->schools->records[$cont]->code = (int)$row["code"];
        $out->schools->records[$cont]->name = $row["name"];
        $out->schools->records[$cont]->region = $row["region"];
        $out->schools->records[$cont]->access = determinateAccess($arrschools,$out->schools->records[$cont]->id,$schoolDefault);
        $cont++;
    }
    
    function determinateAccess($arrschools,$currentid,$defaultid){
        $len = sizeof($arrschools);
        
        if((int)$defaultid == (int)$currentid){
            return "DEFAULT";
        }
        
        for($i = 0; $i < $len; $i++){
            if((int)$arrschools[$i] == (int)$currentid){
                return "SI";
            }
        }
        return "NO";
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>