<?php
    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");

    $parmsob = array("sessionid","id","usr","name","email","rolid","schoolid","status");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros invalidos " . implode(", ", $parmsob)));
        
    
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    $id = $_GET["id"];
    $schoolid = $_GET["schoolid"];
    $name = $_GET["name"];
    $email = $_GET["email"];
    $rolid = $_GET["rolid"];
    $schools = '';
    $status = $_GET["status"];
    
    // Si se envio un rolid, lo consultamos para validar que exista
    if(isset($_GET["rolid"]) && $_GET['rolid'] != ''){
        $sql = "SELECT name, status FROM cmsusers WHERE id = ".$_GET["rolid"]." AND type = 0";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $row = $rs->fetch_assoc();
        
        // Retornamos 204 cuando la busqueda no obtiene resutados
        if($row["name"] == null){
            badEnd("204", array("msg"=>"No se encuentra el registro(rol)"));
        }
    }
    
    //Verificamos que la sesion no este expirada
    isSessionValid($db, $sessionid);
    
    if($id == 0){
        
        //Validamos que el usuario tenga privilegios
        if(!tienePrivilegio($db, $sessionid, 27))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
        
        $sql = "SELECT * FROM cmsusers WHERE UPPER(email)=UPPER('".$email."')";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        $row= $rs->fetch_assoc();
    
        if($row["id"] != null){
            badEnd("409", array("msg"=>"Registro duplicado"));
        }
        
        $sql = "INSERT INTO cmsusers (name,email,status,schoolid,type,rolid,".(isset($_GET["schools"]) && $_GET["schools"] != '' ? 'schools,' : '')."validthru)".
        "       VALUES('".$name."','".$email."',".$status.",".$schoolid.",1,".$rolid.", ".(isset($_GET["schools"]) && $_GET["schools"] != '' ? "'".$_GET['schools']."', " : '')."NULL)";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $out->id = $db->insert_id;
        
        // Si se envio un rolid, le incluimos al usuarios los privilegios
        if(isset($_GET["rolid"]) && $_GET['rolid'] != ''){
            $sql =  "DELETE FROM userprivileges ".
            "       WHERE userid = '".$out->id."'";
            if (!$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
                
            $sql =  "INSERT INTO userprivileges ".
            "       (userid, privilegeid) ".
            "       SELECT '".$out->id."', privilegeid ".
            "       FROM userprivileges ".
            "       WHERE userid = ".$_GET["rolid"];
            if (!$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
        }
        
        setAudit($db, "USUARIOS", $sessionid, "Se creó el usuario ".$email);
        
    }else{
        
        //Validamos que el usuario tenga privilegios
        if(!tienePrivilegio($db, $sessionid, 25))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
        
        $sql = "SELECT id, rolid FROM cmsusers WHERE id=".$id;
        if (!$rs = $db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $row = $rs->fetch_assoc();
        if ($row["id"] != $id)
            badEnd("204", array("msg"=>"No se encontró el registro"));
            
        
        $oldrol = $row["rolid"];
        
        // Si se envio un rolid, le incluimos al usuarios los privilegios
        if(isset($_GET["rolid"]) && $_GET['rolid'] != ''){
            if ($_GET["rolid"] != $oldrol){
                $sql =  "DELETE FROM userprivileges ".
                "       WHERE userid = '".$id."'";
                if (!$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
                    
                $sql =  "INSERT INTO userprivileges ".
                "       (userid, privilegeid) ".
                "       SELECT '".$id."', privilegeid ".
                "       FROM userprivileges ".
                "       WHERE userid = ".$_GET["rolid"];
                if (!$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
            }
        }else{
            //Si no, eliminamos en caso de que tenga
            $sql =  "DELETE FROM userprivileges ".
            "       WHERE userid = '".$id."'";
            if (!$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
        }
            
        $sql = "UPDATE cmsusers SET ".
        "       name='".$name."', email='".$email."',".
        "       status=".$status.", schoolid='".$schoolid."',".
        "       rolid='".$rolid."', schools=".(isset($_GET["schools"]) && $_GET["schools"] != '' ? "'".$_GET['schools']."'" : 'NULL').
        "       WHERE id=".$id;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        //Verificamos que se hicieron cambios
        if($db->affected_rows == 0){
            badEnd("304", array("msg"=>"No se pudo modificar"));
        }
        
        $out->id = $id;
        
        setAudit($db, "USUARIOS", $sessionid, "Se actualizaron los datos de el usuario ".$email);
    }
    
    
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>