var schoolid;
var located = new URLSearchParams(location.search);
var payments = [];
var asociations = '';

window.onload = function carga() {
    let today = new Date();
    let dd = String(today.getDate()).padStart(2, '0');
    let mm = String(today.getMonth() + 1).padStart(2, '0');
    let yyyy = today.getFullYear();
    document.getElementById('chargeDate').value = `${yyyy}-${mm}-${dd}`;
    var located = new URLSearchParams(location.search);
    var cellphone1 = document.getElementById('userCel1');
    var cellphone2 = document.getElementById('userCel2');
    var cellphonealt = document.getElementById('userAltCel');
    
    let currentLocation = document.getElementsByClassName('registerColleges') [0];
    currentLocation.setAttribute("id","locationUrl");
    document.getElementsByClassName('userName')[0].innerHTML = located.get('n');
    
    var params = {
        sessionid: located.get('ssid'),
        schoolid: located.get('college'),
    };
    
    cellphone1.addEventListener('keydown',function(){formatedphone(cellphone1)});
    cellphone2.addEventListener('keydown',function(){formatedphone(cellphone2)});
    cellphonealt.addEventListener('keydown',function(){formatedphone(cellphonealt)});
    
    function formatedphone(input){
        var valNumber=/^(([0-9])|(ext|x)){1,11}$/;
        var originalNumber = "";
        var number = input.value.replace(/[(,),-]/g,"");
        input.value = "";
        var numbers = number.split("");
        console.log(numbers);
        
        for(let i = 0; i < numbers.length; i++){
            
            if(i === 0){
                originalNumber += "(" + numbers[i];
            }else if( i == 3){
                originalNumber += ")" + numbers[i];
            }else if( i == 6){
                originalNumber += "-" + numbers[i];
            }else{
                originalNumber += numbers[i];
            }
        }
        input.value = originalNumber;
    }
    
    if(located.get('college') === "0"){
        newCollege();
    }else{
        let paramList = {
            sessionid: located.get('ssid'),
            offset: 0,
        }
        
        callRegion(paramList, params);
    }
}

function getData(params){
            
    callWS("GET", "schools/entry", params, respxList);
    
    function respxList(status, respText){
        if (status == 200){
            console.log(status);
            console.log(JSON.parse(respText));
            var json = JSON.parse(respText);
            putValues(json);
            
            asociations = json.asociations;
            
            loadGroups(located.get('ssid'), 3);
            
        }else if(status == 403){
            var msg = document.getElementById('error');
            msg.style.display="block";
            msg.innerHTML = "No posee privilegios";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }else if(status == 500){
            var msg = document.getElementById('error');
            msg.style.display="block";
            msg.innerHTML = "Error interno";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }
    }
}

function putValues(json){
    
    schoolid=json.id;
    innerInInputs('collegeName',json.name);
    innerInInputs('code',json.code);
    innerInInputs('state',json.region.name);
    innerInInputs('type',json.privat ? "1" : "0");
    
    innerInInputs('userName',json.contact);
    innerInInputs('userPosition',json.position);
    innerInInputs('userEmail',json.email);
    innerInInputs('userCel1',json.phone);
    innerInInputs('userCel2',json.phonesecundary);
    
    innerInInputs('userAltName',json.contactalt);
    innerInInputs('userAltPos',json.positionalt);
    innerInInputs('userAltEmail',json.emailalt);
    innerInInputs('userAltCel',json.phonealt);
    
    innerInInputs('modality',json.modality);
    
    innerInInputs('estimatedTotally',json.allowedpupils);
    innerInInputs('allowedPupils',json.estimatedpupils.quantity);
    //json.editlocked ? document.getElementById('allowMod').checked = true : null;
    if(json.privat && json.payment !== null){
        let totalDue = 0;
        // Sumamos las deudas
        json.payment.map((e, index) => {
            totalDue += parseFloat(e.amount.number);
            console.log(e.amount.number);
        });
        console.log(totalDue);
        let isValid = 0;
        innerInInputs('totalPay',(totalDue).toLocaleString('es-ES') + ",00");
        for(let i = 0; i < json.payment.length; i++){
            payments.push(json.payment[i]);
            
            if(json.payment[i].validated ){
                isValid++;
            }
        }
        console.log(isValid);
        isValid > 0 ? document.getElementById('verifyPay').checked = true : null;
        
    }else{
        document.getElementById('messagePay').innerHTML = "Estimaci&oacute;n de Alumnos";
        let inputPriv = document.getElementsByClassName("privateSchools");
        for(let  i = 0; i < inputPriv.length; i++){
            inputPriv[i].style.display = 'none';
        }
    }
    
}

function newCollege(){
    schoolid = 0;
    document.getElementById('delete').style.display = 'none';
    document.getElementsByClassName('lookInfo')[0].style.display = 'none';
    //document.getElementById('allowModifyFirst').style.display = 'none';
    document.getElementById('payVerifyFirst').style.display = 'none';
    
    let paramList = {
        sessionid: located.get('ssid'),
        offset: 0,
    }
    
    callRegion(paramList);
    loadGroups(located.get('ssid'), 3);
}

function showPay(){
    var popup = document.getElementsByClassName("popup")[0];
    //gotoTop();
    if(payments[0].id !== null){
        var style = document.createElement('style');
        document.head.appendChild(style);
        style.sheet.insertRule(`.popup {position: fixed;
                top: 0;
                left: 0;
                width: 100%;
                height: ${window.screen.height <= 635 ? "auto" : '100%'};
                background-color: rgba(0,0,0,0.5); display:block;overflow: auto;
                ${window.screen.height <= 635 ? 'padding: 10px 0px;' : null}}`);
                
        document.body.style.overflow = window.screen.height <= 635 ? "scroll" : "hidden";
    
        popup.innerHTML = `
            <div class="modalBox">
                <div class="modalHeader">
                    <span onclick="closeWithX()" name="popup" class="close">X</span>
                </div>
                <div class="modalBody">
                    <h1 class="headerTitle">Información de Pagos</h1>
                    <hr class="sep">
                    ${eachPay(payments)}
                </div>
            </div>`;
    }else{
        alert("No ha realizado pagos");
    }
    
}

function eachPay(paymentsArr){
    var content = ''; 
    for(let i = 0; i< paymentsArr.length; i++){
        content += makeLabels(paymentsArr[i]);
    }
    return content;
}

function makeLabels(payData){
    let data = "";
    
    if(payData.id !== null){
        let bank = "";
        let kindPay = "";
        if(payData.account == 1){
            bank = "Mercantil";
        }
        
        data = `
        <div class="information" id="${payData.id}">
            <div class="groupLabel">
                <span>Banco</span>
                <span>Fecha</span>
                <span>Referencia</span>
                <span>Cédula / RIF</span>
                <span>Monto</span>
                <span>Tipo de Operación</span>
            </div>
            <div class="groupInfo">
                <span id="bankFirst">${bank}</span>
                <span id="dateFirst">${payData.datepay.long}</span>
                <span id="refFirst">${payData.ref}</span>
                <span id="idFirst">${payData.rif}</span>
                <span id="amountFirst">${payData.amount.formatted}</span>
                <span id="kindOfOpFirst">${payData.type.dsc}</span>
            </div>
        </div>
        <hr class="sep">`;
    }
    
    return data;
}

function closeWindow(){
    var modal = document.getElementsByClassName('popup')[0];
    window.onclick = function(event) {
        if (event.target == modal) {
            var style = document.createElement('style');
            document.head.appendChild(style);
            style.sheet.insertRule(`.popup {display: none}`);
            document.body.style.overflow = "visible";
        }
    }
}

function closeWithX(){
    var style = document.createElement('style');
    document.head.appendChild(style);
    style.sheet.insertRule(`.popup {display: none}`);
    document.body.style.overflow = "visible";
}

const innerInInputs = (id,value) => {
    document.getElementById(id).value = value;
}

const getValue = id => {
    return document.getElementById(id).value;
}

function updateCollege(){
    var located = new URLSearchParams(location.search);
    let error = document.getElementById('error');
    error.innerHTML = "";
    //Validar correo
    var rgx = /^[-\w.%+]{1,64}@(?:[A-Z0-9-]{1,63}\.){1,125}[A-Z]{2,63}$/i;
    //Validar telefono
    var valNumber=/^([\(\)\-0-9]+){13,13}?$/;
    
    let params = {
        id: schoolid,
        code: getValue('code') == "" ? 0 : getValue('code'),
        name: getValue('collegeName'),
        region: getValue('state'),
        privat: getValue('type'),
        email: getValue('userEmail'),
        contact: getValue('userName'),
        phone: getValue('userCel1'),
        phonesecundary: getValue('userCel2'),
        position: getValue('userPosition'),
        contactalt: getValue('userAltName'),
        emailalt: getValue('userAltEmail'),
        phonealt: getValue('userAltCel'),
        positionalt: getValue('userAltPos'),
        paymentverified: document.getElementById('verifyPay').checked ? 1 : 0,
        resetuser: document.getElementById('resetUser').checked ? 1 : 0,
        sessionid: located.get('ssid'),
    };
    
    if(params.name === ""){
        error.innerHTML = "Nombre del colegio no puede estar vac\u00EDo";
        gotoTop();
    }else if(params.region === ""){
        error.innerHTML = "Regi\u00F3n del colegio no puede estar vac\u00EDo";
        gotoTop();
    }else if(params.private === ""){
        error.innerHTML = "Tipo del colegio no puede estar vac\u00EDo";
        gotoTop();
    }else if(!rgx.test(params.email) && params.email !== "") {
        error.innerHTML = "El Correo Electr\u00F3nico no es v\u00E1lido";
        gotoTop();
    }else if (!rgx.test(params.emailalt) && params.emailalt !== ""){
        error.innerHTML = "El Correo Electr\u00F3nico alternativo no es v\u00E1lido";
        gotoTop();
    }else if(!valNumber.test(params.phone) && params.phone.length != 13 && params.phone !== ''){
        error.innerHTML = "El n\u00FAmero de tel\u00E9fono 1 no es v\u00E1lido";
        gotoTop();
    }else if(!valNumber.test(params.phonesecundary) && params.phonesecundary !== "" || params.phonesecundary.length != 13 && params.phonesecundary.length != 0){
        error.innerHTML = "El n\u00FAmero de tel\u00E9fono 2 no es v\u00E1lido";
        gotoTop();
    }else if(!valNumber.test(params.phonealt) && params.phonealt !== "" || params.phonealt.length != 13 && params.phonealt.length != 0){
        error.innerHTML = "El n\u00FAmero de tel\u00E9fono alternativo no es v\u00E1lido";
        gotoTop();
    }else{
        let realParams = {
            id: schoolid,
            code: params.code,
            name: params.name,
            region: params.region,
            privat: params.privat,
            email: params.email === "" ? null : params.email,
            contact: params.contact === "" ? null : params.contact,
            phone: params.phone === "" ? null : params.phone,
            phonesecundary: params.phonesecundary === "" ? null : params.phonesecundary,
            position: params.position === "" ? null : params.position,
            contactalt: params.contactalt === "" ? null : params.contactalt,
            emailalt: params.emailalt === "" ? null : params.emailalt,
            phonealt: params.phonealt === "" ? null : params.phonealt,
            positionalt: params.positionalt === "" ? null : params.positionalt,
            paymentverified: document.getElementById('verifyPay').checked ? 1 : 0,
            resetuser: document.getElementById('resetUser').checked ? 1 : 0,
            sessionid: located.get('ssid'),
            allowedpupils: document.getElementById('allowedPupils').value,
        };
        
        var groups = [...document.getElementsByName('checkboxAsociation')].filter((x) => x.checked).map((x)=>{
            if(x.value !== ''){
                return x.value;
             }
        });
        
        if(groups.length > 0 ){
            realParams.groups = groups.join('|');
        }
        
        console.log(groups);
        
        error.innerHTML = "";
        console.log(realParams);
        callWS("GET", "schools/update", realParams, respxUpdate);
    }
}

function respxUpdate(status, respText){
    gotoTop();
    if ( status == 200 ){
        console.log(status);
        console.log(JSON.parse(respText));
        document.getElementById('confirmation').innerHTML = "Modificaci\u00F3n de Datos Exitosa";
        let timerVal = 0;
        var timer = setInterval(function(){
            timerVal++;
            if(timerVal == 2){
                clearInterval(timer);
                navigationMenu('searchCollege');
            }
        },1000);
    } else if ( status == 401 ) {
        var msg = document.getElementById('error');
        msg.style.display="block";
        msg.innerHTML = "Hash invalido";
        setTimeout(() => {
            msg.style.display="none";
        },5000);
    } else if( status == 409 ){
        var msg = document.getElementById('error');
        msg.style.display="block";
        msg.innerHTML = "Correo Duplicado";
        setTimeout(() => {
            msg.style.display="none";
        },5000);
    }else if(status == 403){
        var msg = document.getElementById('error');
        msg.style.display="block";
        msg.innerHTML = "No posee privilegios";
        setTimeout(() => {
            msg.style.display="none";
        },5000);
    }else if(status == 500){
        var msg = document.getElementById('error');
        msg.style.display="block";
        msg.innerHTML = "Error interno";
        setTimeout(() => {
            msg.style.display="none";
        },5000);
    }
}

function deleteCollege(){
    var located = new URLSearchParams(location.search);
    error.innerHTML = "";
    
    let realParams = {
        schoolid: schoolid,
        sessionid: located.get('ssid'),
    };
        
    console.log(realParams);
    callWS("GET", "schools/delete", realParams, respxDelete);
}

function respxDelete(status, respText){
    gotoTop();
    if ( status == 200 ){
        document.getElementById('confirmation').innerHTML = "Eliminaci\u00F3n de Colegio Exitosa";
        let timerVal = 0;
        var timer = setInterval(function(){
            timerVal++;
            if(timerVal == 2){
                clearInterval(timer);
                navigationMenu('searchCollege');
            }
        },1000);
    } else if ( status == 401 ) {
        var msg = document.getElementById('error');
        msg.style.display="block";
        msg.innerHTML = "Hash invalido";
        setTimeout(() => {
            msg.style.display="none";
        },5000)
    } else if( status == 304 ){
        var msg = document.getElementById('error');
        msg.style.display="block";
        msg.innerHTML = "El Colegio posee Alumnos/Pagos registrados";
        setTimeout(() => {
            msg.style.display="none";
        },5000)
    }else if(status == 403){
        var msg = document.getElementById('error');
        msg.style.display="block";
        msg.innerHTML = "No posee privilegios";
        setTimeout(() => {
            msg.style.display="none";
        },5000)
    }else if(status == 500){
        var msg = document.getElementById('error');
        msg.style.display="block";
        msg.innerHTML = "Error interno";
        setTimeout(() => {
            msg.style.display="none";
        },5000)
    }
}

function callRegion(paramsList, params = ''){
    
    callWS("GET", "regions/list", paramsList, respxList);
    
    function respxList(status, respText){
        if (status == 200){
            let json = JSON.parse(respText);
            putRegions(json.records);
            
            if(params != ''){
                getData(params);
            }
        }else if(status == 403){
            var msg = document.getElementById('error');
            msg.style.display="block";
            msg.innerHTML = "No posee privilegios";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }else if(status == 500){
            var msg = document.getElementById('error');
            msg.style.display="block";
            msg.innerHTML = "Error interno";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }
    }
}

function putRegions(records){
    let select = document.getElementById("state");
    for(let i = 0; i< records.length; i++){
        let option = document.createElement("option");
        option.text = records[i].region;
        option.value = records[i].region;
        if(records[i].region == localStorage.getItem('region')){
            option.selected = true;
        }
        select.add(option);
    }
}

function loadGroups(sessionid, id){
    let params = {};
    
    params.sessionid = sessionid;
    params.id = id;
    
    loadScreen();
    callWS("GET", "settings/entry", params, respx);
    
    function respx(status, respText){
        var located = new URLSearchParams(location.search);
        console.log(status);
        console.log(JSON.parse(respText));
        var json = JSON.parse(respText);
        
        switch(status){
            case 200:
                var arrAcc = json.entry.content.split('|');
                var currentAs = asociations.split('|');
                console.log(asociations);
                arrAcc.forEach(el => {
                    var div = document.createElement('div');
                    var label = document.createElement('label');
                    var option = document.createElement('input');
                    
                    div.classList.add('checkBoxLabel');
                    
                    option.type = 'checkbox';
                    option.name = "checkboxAsociation";
                    option.id = el;
                    option.value = el;
                    option.classList.add('inputCheck');
                    
                    currentAs.forEach(elem => {
                        if(el == elem){
                            option.checked = true;
                        }
                    })
                    
                    label.setAttribute("for",el);
                    label.innerHTML = el;
                    
                    div.appendChild(option);
                    div.appendChild(label);
                    
                    document.getElementById('checkBoxDiv').appendChild(div);
                }) 
                break;
            default:
                console.log(json);
                break;
        }
        closeLoad();
    }
}