var located = new URLSearchParams(location.search);
var qtyForPage = 10;
var like = located.get('like') === 'null' || located.get('like') === null ? '' : located.get('like');
var order = located.get('order') === 'null' || located.get('order') === null ? ' audit.id DESC' : located.get('order');
var page = located.get("page") === null ? 1 : parseInt(located.get("page"));
var module = located.get('module') === 'null' || located.get('module') === null ? '' : located.get('module');
var date = located.get('date') === 'null' || located.get('date') === null ? '' : located.get('date');
var numPages = 0;
var numOfRecords = 0;

window.onload = function carga() {
    var located = new URLSearchParams(location.search);
    
    let currentLocation = document.getElementsByClassName('configuration') [0];
    currentLocation.setAttribute("id","locationUrl");
    document.getElementsByClassName('userName')[0].innerHTML = located.get('n');
    
    var params = {
        sessionid: located.get('ssid'),  
    };
    
    callListOfModules(params);
    
    params = {
        sessionid: located.get('ssid'),
        order: order,
        filter: like,
        offset: (page - 1) * qtyForPage,
        numofrecords: qtyForPage,
        module: module,
        date: date,
    };
    
    callListOfLogs(params);
}

function callListOfModules(params){
    callWS("GET","audit/moduleslist", params, response);
    
    function response(status, rsp){
        let json = JSON.parse(rsp);
        console.log(status);
        switch(status){
            case 200:
                let select = document.getElementById('modulesList');
                for(let i = 0; i < json.records.length; i++){
                    let option = document.createElement('option');
                    option.value = json.records[i].dsc;
                    option.text = json.records[i].dsc;
                    
                    select.appendChild(option);
                }
                break;
            case 500:
                var msg = document.getElementById('error');
                msg.innerHTML = 'Error interno';
                msg.style.display = 'block';
                gotoTop();
                                
                setTimeout(() => {
                    msg.style.display = 'none';
                }, 2000);
                break;
            default:
                var msg = document.getElementById('error');
                msg.innerHTML = json.msg;
                msg.style.display = 'block';
                gotoTop();
                    
                setTimeout(() => {
                    msg.style.display = 'none';
                }, 2000);
        }
    }
}

function callListOfLogs(params){
    
    callWS("GET", "audit/list", params, respxList);
    
    console.log(params);
    function respxList(status, respText){
        console.log(status);
        console.log(JSON.parse(respText));
        var json = JSON.parse(respText);
        if (status == 200){
            console.log('ok');
            numPages = Math.ceil(json.numofrecords/qtyForPage);
            numOfRecords = json.numofrecords;
            putValues(json);
        }
    } 
}

function putValues(json){
    if(json.numofrecords === 0){
        alert("No existen registros");
        document.getElementsByClassName('listPages')[0].innerHTML = "";
    }else{
        for(let i = 0; i < json.records.length; i++){
            if(json.records[i].id !== null ){
                document.getElementsByClassName('logTable')[0].insertRow(-1).innerHTML = `
                <td>${json.records[i].date.formatted}</td>
                <td>${json.records[i].module}</td>
                <td>${json.records[i].user.name}</td>
                <td style="text-align: left;">${json.records[i].dsc}</td>
                `;
            }
        }
        makeNumbers();
    }
}

const makeNumbers = () => {
    var container = document.getElementsByClassName('listPages')[0];
    var linkers = "";
    let interations = numPages > 10 ? 10 : numPages;
    for(let i = 0; i < interations; i++){
        
        if(numPages == 1){
            linkers += `<li><a href='javascript:paginationNavigate(${i+1})' class="pagination" id="user${i+1}">${i+1}</a></li>`;
        }else if(page+i <= numPages){
            if(i === 0){
            
                linkers +=`<li><a href='javascript:paginationNavigate(${1})' class="pagination"><<</a></div>`;
                linkers +=`<li><a href='javascript:paginationNavigate(${page === 1 ? 1 : page-1})' class="pagination"><</a></li>`;
                linkers += page === 1 ? '' : `<li><a href='javascript:paginationNavigate(${page-1})' class="pagination" id="user${page-1}">${page-1}</a></li>`;
                linkers += `<li><a href='javascript:paginationNavigate(${page})' class="pagination" id="user${page}">${page}</a></li>`;
            
            }else if(i == interations-1){
            
                linkers += `<li><a href='javascript:paginationNavigate(${page+i})' class="pagination" id="user${page+i}">${page+i}</a></li>`;
            
                linkers +=`<li><a href='javascript:paginationNavigate(${page === numPages ? numPages : page + 1})' class="pagination">></a></li>`;
            
                linkers +=`<li><a href='javascript:paginationNavigate(${numPages})' class="pagination">>></a></li>`;
            }else{
            
                linkers += `<li><a href='javascript:paginationNavigate(${page+i})' class="pagination" id="user${page+i}">${page+i}</a></li>`;
            
            }
        }
        
    }
    container.innerHTML = linkers;
    document.getElementById(`user${page}`).style.color = '#F68E1E';
}

function paginationNavigate(pageU){
    let located = new URLSearchParams(location.search);
    var params = {
        sessionid: located.get('ssid'),
        filter: like,
        offset: (pageU - 1) * qtyForPage,
        sessionid: located.get('ssid'),
        numofrecords: qtyForPage,
        order: order,
        module: module,
        date: date,
    }
    
    page = pageU;
    
    
    var table = document.getElementsByClassName("logTable")[0].rows;
    var rowCount = table.length;
    
    for(let i = rowCount - 1; i > 0; i--){
        table[i].closest('tr').remove();
    }
    
    callListOfLogs(params);
}

function changeOrder(event){
    var located = new URLSearchParams(location.search);
    
    var paramsList = {
        filter: like,
        offset: (page - 1) * qtyForPage,
        sessionid: located.get('ssid'),
        numofrecords: qtyForPage,
        order: order,
        module: module,
        date: date,
    };
    
    var arrowsUp = document.getElementsByClassName('up');
    var arrowsDown = document.getElementsByClassName('down');
    
    for(let i = 0; i< arrowsUp.length; i++){
        arrowsDown[i].setAttribute('onclick','changeOrder(this)');
        arrowsUp[i].setAttribute('onclick','changeOrder(this)');
        
        arrowsDown[i].style.borderColor = "#FFF";
        arrowsUp[i].style.borderColor = "#FFF";
        arrowsDown[i].style.cursor = "pointer";
        arrowsUp[i].style.cursor = "pointer";
    }
    
    var arrow = document.getElementById(event.id);
    arrow.setAttribute('onclick','');
    arrow.style.cursor = "auto";
    arrow.style.borderColor = "#BBB";
    
    switch(event.id){
        case "dateUp":
            order = "audit.date ASC";
            break;
        case "dateDown":
            order = "audit.date DESC";
            break;
        case "moduleUp":
            order = "audit.module ASC";
            break;
        case "moduleDown":
            order = "audit.module DESC";
            break;
        case "userUp":
            order = "cmsusers.name ASC";
            break;
        case "userDown":
            order = "cmsusers.name DESC";
            break;
        case "actionUp":
            order = "audit.dsc ASC";
            break;
        case "actionDown":
            order = "audit.dsc DESC";
            break;
    }
    
    paramsList.order = order;
    
    var table = document.getElementsByClassName("logTable")[0].rows;
    var rowCount = table.length;
    
    for(let i = rowCount - 1; i > 0; i--){
        table[i].closest('tr').remove();
    }
    
    callListOfLogs(paramsList);
}

function searchFilter(e){
    console.log(e.target);
    
    if(e.target.id == "modulesList"){
        module = e.target.value;
        page = 1;
        
        let params = {
            filter: like,
            offset: (page - 1) * qtyForPage,
            sessionid: located.get('ssid'),
            numofrecords: qtyForPage,
            order: order,
            module: module,
            date: date,
        }
        
        var table = document.getElementsByClassName("logTable")[0].rows;
        var rowCount = table.length;
        
        for(let i = rowCount - 1; i > 0; i--){
            table[i].closest('tr').remove();
        }
        
        callListOfLogs(params);
    }
    
    if(e.target.id == "dateFilter"){
        date = e.target.value;
        page = 1;
        
        let params = {
            filter: like,
            offset: (page - 1) * qtyForPage,
            sessionid: located.get('ssid'),
            numofrecords: qtyForPage,
            order: order,
            module: module,
            date: date,
        }
        
        var table = document.getElementsByClassName("logTable")[0].rows;
        var rowCount = table.length;
        
        for(let i = rowCount - 1; i > 0; i--){
            table[i].closest('tr').remove();
        }
        
        callListOfLogs(params);
    }
}

function searchFilterInput(e){
    if(e.keyCode == 13){
        var located = new URLSearchParams(location.search);
        
        like = e.target.value === "" ? '' : `${e.target.value}`;
        page = 1;
        
        var params = {
            filter: like,
            offset: (page - 1) * qtyForPage,
            sessionid: located.get('ssid'),
            numofrecords: qtyForPage,
            order: order,
            module: module,
            date: date,
        };
    
        var table = document.getElementsByClassName("logTable")[0].rows;
        var rowCount = table.length;
    
        for(let i = rowCount - 1; i > 0; i--){
            table[i].closest('tr').remove();
        }
    
        callListOfLogs(params);
        //debugger;
    }
}

function callDownload(){
    var filter = like;
    var modul = module;
    var order = order;

    download("audit/listcsv?filter="+filter+"&module="+modul+"&order="+order+"&sessionid="+located.get('ssid'));
    return;
}