var located = new URLSearchParams(location.search);
var qtyForPage = 10;
var like = located.get('like') === 'null' || located.get('like') === null ? '' : located.get('like');
var order = located.get('order') === 'null' || located.get('order') === null ? 'pupils.id' : located.get('order');
var page = located.get("page") === null ? 1 : parseInt(located.get("page"));
var numPages;
var level = located.get('level') === 'null' || located.get('level') === null  ? '' : located.get('level');
var region = located.get('region') === 'null' || located.get('region') === null  ? '' : located.get('region');
var schoolid = located.get('schoolid') === 'null' || located.get('schoolid') === null  ? '': located.get('schoolid');
var statusExam = located.get('statusExam') === 'null' || located.get('statusExam') === null  ? '' : located.get('statusExam');
var teacher = located.get('teacher') === 'null' || located.get('teacher') === null  ? '' : located.get('teacher');

var numOfRecords = 0;
var isTeacher = false;
var isAdmin = false;
var canExport = false;

window.onload = function carga() {
    var located = new URLSearchParams(location.search);
    
    like = localStorage.getItem('like') === null ? '' : localStorage.getItem('like');
    order = localStorage.getItem('order') === null ? 'pupils.id' : localStorage.getItem('order');
    level = localStorage.getItem('level') === null ? '' : localStorage.getItem('level');
    region = localStorage.getItem('region') === null ? '' : localStorage.getItem('region');
    schoolid = localStorage.getItem('schoolid') === null ? '' : localStorage.getItem('schoolid');
    statusExam = localStorage.getItem('statusExam') === null ? '' : localStorage.getItem('statusExam');
    teacher = localStorage.getItem('teacher') === null ? '' : localStorage.getItem('teacher');
    
    let currentLocation = document.getElementsByClassName('tests') [0];
    currentLocation.setAttribute("id","locationUrl");
    document.getElementsByClassName('userName')[0].innerHTML = located.get('n');
    
    document.getElementById('searchInput').value = like;
    //document.getElementById('schoolType').value = type;
    
    document.getElementById('levelStudent').value = level;
    document.getElementsByClassName('res')[0].value = statusExam;
    
    let paramsUser = {
        sessionid: located.get('ssid'),
    };
    
    loadScreen();
    //  Obtenemos los privilegios del usuario
    callWS("GET", "privileges/entrybyuser", paramsUser, respxList);
    
    function respxList(status, respText){
        if (status == 200){
            console.log(status);
            console.log(JSON.parse(respText));
            var json = JSON.parse(respText);
            
            // Recorremos los privilegios, validamos que tiene permisos de coordinador primero
            json.privileges.map(el => {
                if(el.grp == "COORDINADOR ORM" && el.dsc == 'Ver'){
                    isAdmin = true;
                } else if(el.grp == "PROFESORES"){
                    isTeacher = true;
                }
                
                if(el.id == 74){
                    canExport = true;
                }
            });
            
            paintExport();
            
            // Validamos sus privilegios
            if(isTeacher && !isAdmin){
                loadTeacherData();
            } else if (isAdmin) {
                loadCoordinateData();
            }else{
               privilegeError();
            }
            
        }else if(status == 403){
            privilegeError();
        }else if(status == 500){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "Error interno";
            gotoTop();
            
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }
    }
}

function paintExport() {
    if(canExport){
        document.getElementsByClassName('exportBox')[0].style.display = 'flex';
    } else {
        document.getElementsByClassName('exportBox')[0].style.display = 'none';
    }
}

function loadCoordinateData(){
    // Mostramos filtro de colegios
    document.getElementById('inputSchools').style.display = 'block';
    document.getElementsByClassName('teacher')[0].style.display = 'block';
    document.getElementsByClassName('btnExam')[0].style.display = 'none';
    document.getElementById('nameCol').style.display = 'table-cell';
    document.getElementById('collegeCol').style.display = 'table-cell';
    let paramsListSchools = {
        offset: 0,
        filter: '',
        schoolid: schoolid,
        region: region,
        sessionid: located.get('ssid'),
        status: '',
        numofrecords: null,
        order: "id",
    };
    
    callListOfSchoolFirst(paramsListSchools);
}

function callListOfTeachers(paramsList){
    callWS("GET", "teachers/list", paramsList, respxList);
    
    console.log(paramsList);
    function respxList(status, respText){
        if (status == 200){
            console.log(status);
            console.log(JSON.parse(respText));
            var json = JSON.parse(respText);
            putTeachers(json.records);
        }else if(status == 403){
            privilegeError();
        }else if(status == 500){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "Error interno";
            gotoTop();
            
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }
    }
}

function putTeachers(records){
    let select = document.getElementsByClassName("teacher")[0];
    for(let i = 0; i< records.length; i++){
        let option = document.createElement("option");
        option.text = records[i].name;
        option.value = records[i].id;
        
        if(teacher == records[i].id){
            option.selected = true;
        }
        select.add(option);
    }
}

function loadTeacherData() {
    var params = {
        sessionid: located.get('ssid'),
        offset: 0,
    };
    
    callRegionFirst(params);
    
    let paramsTest = {
        sessionid: located.get('ssid'),
        offset: (page - 1) * qtyForPage,
        numofrecords: qtyForPage,
        filter: like,
        order: order,
        level: level,
        status: statusExam,
        regionid: region,
        teacher: teacher,
    };
    
    callListOfTest(paramsTest);
}

function callListOfTest(paramsList){
    callWS("GET", "nationals/list", paramsList, respxList);
    
    console.log(paramsList);
    function respxList(status, respText){
        if (status == 200){
            console.log(status);
            console.log(JSON.parse(respText));
            var json = JSON.parse(respText);
            numPages = Math.ceil(json.numofrecords/10);
            putValues(json);
            numOfRecords = json.numofrecords;
            
            document.getElementById('totalBox').style.display = 'block';
            document.getElementById('totalItems').innerHTML = `Total: ${format(numOfRecords.toString())}`;
            
        }else if(status == 403){
            privilegeError();
        }else if(status == 500){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "Error interno";
            gotoTop();
            
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }
    }
}

function format(input) {
    var num = input.replace(/\./g,'');
    num = num.toString().split('').reverse().join('').replace(/(?=\d*\.?)(\d{3})/g,'$1.');
    num = num.split('').reverse().join('').replace(/^[\.]/,'');
    
    return num;
}

function putValues() {
    // Validamos sus privilegios
    if(isTeacher && !isAdmin){
        loadTeacherData();
    } else if (isAdmin) {
        loadCoordinateData();
    }else{
       privilegeError();
    }
}

function callListOfSchoolFirst(paramsList){
    callWS("GET", "schools/list", paramsList, respxList);
    
    console.log(paramsList);
    function respxList(status, respText){
        console.log(status);
        console.log(JSON.parse(respText));
        var json = JSON.parse(respText);
        if (status == 200){
            console.log('ok');
            putSchools(json.records);
            
            var params = {
                sessionid: located.get('ssid'),
                offset: 0,
            };
        
            callRegionFirst(params);
            
            let paramsTest = {
                sessionid: located.get('ssid'),
                offset: (page - 1) * qtyForPage,
                numofrecords: qtyForPage,
                filter: like,
                order: order,
                status: statusExam,
                level: level,
                regionid: region,
                teacher: teacher,
            };
            
            callListOfTest(paramsTest);
            
            // Cargamos la lista de profesores
            let paramsListTeacher = {
                sessionid: located.get('ssid'),
            };
            
            callListOfTeachers(paramsListTeacher);
    
        }else if(status == 403){
            privilegeError();
        }else if(status == 500){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "Error interno";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }
    }
}

function putSchools(records){
    let option = "";
    option += `<option disabled selected>Colegios...</option>`;
    option += `<option value="">TODOS</option>`;
    for(let i = 0; i < records.length; i++){
        option += `<option value="${records[i].id} - ${records[i].name}">${records[i].id} - ${records[i].name}</option>`;
        
        if(parseInt(records[i].id) == parseInt(schoolid)){
            document.getElementById('inputSchools').value = `${records[i].id} - ${records[i].name}`;
        }
        
    }
    
    document.getElementById("schools").innerHTML = option;
}

function callRegionFirst(paramsList){
    callWS("GET", "regions/list", paramsList, respxList);
    
    function respxList(status, respText){
        if (status == 200){
            let json = JSON.parse(respText);
            putRegions(json.records);
        }else if(status == 403){
            privilegeError();
        }else if(status == 500){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "Error interno";
            gotoTop();
            
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }
    }
}

function putRegions(records){
    let select = document.getElementsByClassName("region")[0];
    for(let i = 0; i< records.length; i++){
        let option = document.createElement("option");
        option.text = records[i].region;
        option.value = records[i].region;
        
        if(region == records[i].region){
            option.selected = true;
        }
        select.add(option);
    }
    
    document.getElementById('regionList').value = region;
}

function searchingPupil(e){
    if(e.keyCode == 13){
        var located = new URLSearchParams(location.search);
        
        like = e.target.value === "" ? '' : `${e.target.value}`;
        localStorage.setItem('like',like);
        page = 1;
        
        let paramsTest = {
            sessionid: located.get('ssid'),
            offset: (page - 1) * qtyForPage,
            numofrecords: qtyForPage,
            filter: like,
            order: order,
            level: level,
            status: statusExam,
            regionid: region,
            teacher: teacher,
        };
        
        var table = document.getElementsByClassName("testTable")[0].rows;
        var rowCount = table.length;
    
        for(let i = rowCount - 1; i > 0; i--){
            table[i].closest('tr').remove();
        }
    
        callListOfTest(paramsTest);
    }
}

function searchFilter(e) {
    let located = new URLSearchParams(location.search);

    if(e.target.className === "region"){
        region = e.target.value;
        localStorage.setItem('region',region);
        
        document.getElementById("inputSchools").value = "";
        
        if(!isTeacher){
            schoolid='';
            let paramsSchool = {
                region: region,
                schoolid: schoolid,
                offset: 0,
                sessionid: located.get('ssid'),
                status: '',
                numofrecords: null,
                order: "id",
            }
            
            callListOfSchool(paramsSchool);
        }
    }
    
    if(e.target.className === "grade"){
        level = e.target.value;
        localStorage.setItem('level',level);
    }
    
    if(e.target.className === "res"){
        statusExam = e.target.value;
        localStorage.setItem('statusExam',statusExam);
    }
    
    if(e.target.className === "teacher"){
        teacher = e.target.value;
        localStorage.setItem('teacher',teacher);
    }
    
    if(e.target.className === "schools" && e.target.value != ""){
        let getId = e.target.value.split("-");
        console.log(getId.length);
        if(getId.length < 2){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "Debe seleccionar un colegio";
            setTimeout(() => {
                msg.style.display="none";
            },5000);
            return 0;
        }
        schoolid = getId[0];
        localStorage.setItem('schoolid',schoolid);
    }else if(e.target.className === "schools" && e.target.value == ""){
        schoolid='';
        localStorage.setItem('schoolid',schoolid);
    }
    
    page = 1;
        
    let paramsTest = {
        sessionid: located.get('ssid'),
        offset: (page - 1) * qtyForPage,
        numofrecords: qtyForPage,
        filter: like,
        order: order,
        status: statusExam,
        level: level,
        regionid: region,
        teacher: teacher,
    };
    
    var table = document.getElementsByClassName("testTable")[0].rows;
    var rowCount = table.length;
    for(let i = rowCount - 1; i > 0; i--){
         table[i].closest('tr').remove();
    }
        
    callListOfTest(paramsTest);
}

function callListOfSchool(paramsList){
    callWS("GET", "schools/list", paramsList, respxList);
    
    console.log(paramsList);
    function respxList(status, respText){
        console.log(status);
        console.log(JSON.parse(respText));
        var json = JSON.parse(respText);
        if (status == 200){
            console.log('ok');
            putSchools(json.records);
        }else if(status == 403){
            var msg = document.getElementById('msgApi');
            privilegeError();
        }else if(status == 500){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "Error interno";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }
    }
}

function changeOrder(event){
    var located = new URLSearchParams(location.search);
    
    var arrowsUp = document.getElementsByClassName('up');
    var arrowsDown = document.getElementsByClassName('down');
    
    let paramsTest = {
        sessionid: located.get('ssid'),
        offset: (page - 1) * qtyForPage,
        numofrecords: qtyForPage,
        filter: like,
        order: order,
        level: level,
        regionid: region,
        status: statusExam,
        teacher: teacher,
    };
    
    for(let i = 0; i< arrowsUp.length; i++){
        arrowsDown[i].setAttribute('onclick','changeOrder(this)');
        arrowsUp[i].setAttribute('onclick','changeOrder(this)');
        
        arrowsDown[i].style.borderColor = "#FFF";
        arrowsUp[i].style.borderColor = "#FFF";
        arrowsDown[i].style.cursor = "pointer";
        arrowsUp[i].style.cursor = "pointer";
    }
    
    var arrow = document.getElementById(event.id);
    arrow.setAttribute('onclick','');
    arrow.style.cursor = "auto";
    arrow.style.borderColor = "#BBB";
    
    switch(event.id){
        case "codeUp":
            order = "pupils.id ASC";
            break;
        case "codeDown":
            order = "pupils.id DESC";
            break;
        case "nameUp":
            order = "pupils.name ASC";
            break;
        case "nameDown":
            order = "pupils.name DESC";
            break;
        case "genderUp":
            order = "pupils.gender ASC";
            break;
        case "genderDown":
            order = "pupils.gender DESC";
            break;
        case "gradeUp":
            order = "pupils.level ASC, pupils.section ASC";
            break;
        case "gradeDown":
            order = "pupils.level DESC, pupils.section DESC";
            break;
        case "collegeUp":
            order = "schools.name ASC";
            break;
        case "collegeDown":
            order = "schools.name DESC";
            break;
        case "regionUp":
            order = "schools.region ASC";
            break;
        case "regionDown":
            order = "schools.region DESC";
            break;
        case "pointUp":
            order = "answers.id ASC";
            break;
        case "pointDown":
            order = "answers.id DESC";
            break;
        case "resultUp":
            order = " score ASC";
            break;
        case "resultDown":
            order = " score DESC";
            break;
    }
    
    paramsTest.order = order;
    
    localStorage.setItem('order',order);
    
    var table = document.getElementsByClassName("testTable")[0].rows;
    var rowCount = table.length;
    
    for(let i = rowCount - 1; i > 0; i--){
        table[i].closest('tr').remove();
    }
    
    callListOfTest(paramsTest);
}

function privilegeError(){
    var msg = document.getElementById('msgApi');
    msg.style.display="block";
    msg.innerHTML = "No posee privilegios";
    gotoTop();
}

function putValues(json){
    if(json.numofrecords == 0){
        alert("No existen registros");
    }else{
        for(let i = 0; i < json.records.length; i++){
            if(json.records[i].pupil.name !== null ){
                
                if(isTeacher && !isAdmin){
                    document.getElementsByClassName('testTable')[0].insertRow(-1).innerHTML = `
                        <td>${json.records[i].pupil.code}</td>
                        <td>${json.records[i].pupil.level}${abrev(json.records[i].pupil.level)} ${json.records[i].pupil.section}</td>
                        <td>${json.records[i].school.region}</td>
                        <td>${json.records[i].qualification}</td>
                        <td>${json.records[i].teachername}</td>
                        <td>
                            ${json.records[i].teachername === "" ? `--` : `
                                <i class="eyePointer eye" onclick="${'navigateDetails('+json.records[i].test.id+')'}">
                                </i>
                            `}
                        </td>`;
                } else if (isAdmin) {
                    document.getElementsByClassName('testTable')[0].insertRow(-1).innerHTML = `
                        <td>${json.records[i].pupil.code}</td>
                        <td>${json.records[i].pupil.name + " " + json.records[i].pupil.surname}</td>
                        <td>${json.records[i].pupil.level}${abrev(json.records[i].pupil.level)} ${json.records[i].pupil.section}</td>
                        <td>${json.records[i].school.name}</td>
                        <td>${json.records[i].school.region}</td>
                        <td>${json.records[i].qualification}</td>
                        <td>${json.records[i].teachername}</td>
                        <td>
                            ${json.records[i].teachername === "" ? `--` : `
                                <i class="eyePointer eye" onclick="${'navigateDetails('+json.records[i].test.id+')'}">
                                </i>
                            `}
                        </td>`;
                }else{
                   privilegeError();
                }
            }
        }
        makeNumbers();
    }
}

function navigateDetails(id) {
    let located = new URLSearchParams(location.search);
    var params = {
        ssid: located.get('ssid'),
        n: located.get('n'),
        answerid: id,
    };
    
    gotoPage('home','reviewNational',params);
}

function newExam() {
    let params = {
        sessionid: located.get('ssid'),
    };
    
    loadScreen();
    //  Obtenemos los privilegios del usuario
    callWS("GET", "nationals/newexam", params, respxList);
    
    function respxList(status, respText){
        if (status == 200){
            console.log(status);
            console.log(JSON.parse(respText));
            var json = JSON.parse(respText);
            
            if(json.qty > 0){
                var params = {
                    ssid: located.get('ssid'),
                    n: located.get('n'),
                    answerid: json.id,
                };
                
                gotoPage('home','reviewNational',params);
            }else{
                alert('No hay exámenes por corregir');
            }
            
        }else if(status == 403){
            privilegeError();
        }else if(status == 500){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "Error interno";
            gotoTop();
            
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }
    }
}

const abrev = level => {
    return level == "3" || level == "1" ? "ro" : (level == "2" ? "do" : "to");
}

const makeNumbers = () => {
    var container = document.getElementsByClassName('listPages')[0];
    var linkers = "";
    let interations = numPages > 10 ? 10 : numPages;
    for(let i = 0; i < interations; i++){
        if(numPages == 1){
            linkers += `<li><a href='javascript:paginationNavigate(${i+1})' class="pagination" id="${i+1}">${i+1}</a></li>`;
        }else if(page+i <= numPages){
            if(i === 0){
                linkers +=`<li><a href='javascript:paginationNavigate(${1})' class="pagination"><<</a></div>`;
                linkers +=`<li><a href='javascript:paginationNavigate(${page === 1 ? 1 : page-1})' class="pagination"><</a></li>`;
                linkers += page === 1 ? '' : `<li><a href='javascript:paginationNavigate(${page-1})' class="pagination" id="${page-1}">${page-1}</a></li>`;
                linkers += `<li><a href='javascript:paginationNavigate(${page})' class="pagination" id="${page}">${page}</a></li>`;
            }else if(i == interations-1){
                linkers += `<li><a href='javascript:paginationNavigate(${page+i})' class="pagination" id="${page+i}">${page+i}</a></li>`;
                linkers +=`<li><a href='javascript:paginationNavigate(${page === numPages ? numPages : page + 1})' class="pagination">></a></li>`;
                linkers +=`<li><a href='javascript:paginationNavigate(${numPages})' class="pagination">>></a></li>`;
            }else{
                linkers += `<li><a href='javascript:paginationNavigate(${page+i})' class="pagination" id="${page+i}">${page+i}</a></li>`;
            }
        }
    }
    container.innerHTML = linkers;
    document.getElementById(`${page}`).style.color = '#F68E1E';
}

function paginationNavigate(page){
    let located = new URLSearchParams(location.search);
    var params = {
        ssid: located.get('ssid'),
        n: located.get('n'),
        page: page,
    }
    
    if(order !== ""){
        localStorage.setItem('order',order);
        params.order = order;
    }
    
    if(like !== ""){
        localStorage.setItem('like',like);
        params.like = like;   
    }
    
    if(region !== ""){
        localStorage.setItem('region',region);
        params.region = region;
    }
    
    if(schoolid !== ""){
        localStorage.setItem('schoolid',schoolid);
        params.schoolid = schoolid;
    }
    
    if(level !== ""){
        localStorage.setItem('level',level);
        params.level = level;
    }
    
    if(statusExam !== ""){
        localStorage.setItem('statusExam',statusExam);
        params.statusExam = statusExam;
    }
    
    if(teacher !== ""){
        localStorage.setItem('teacher',teacher);
        params.teacher = teacher;
    }
    
    gotoPage('home','nationals',params);
}

function callDownload(){

    download("nationals/listcsv.php?sessionid="+located.get('ssid'));
    return;
}