var located = new URLSearchParams(location.search);

var numQuestions = 30;
var question = 1;
var isTeacher = false;
var isAdmin = false;
var questionsArr = [];
var answerid = 0;
var rotatePos = 0;

window.onload = function carga() {
    var located = new URLSearchParams(location.search);
    
    let currentLocation = document.getElementsByClassName('tests') [0];
    currentLocation.setAttribute("id","locationUrl");
    document.getElementsByClassName('userName')[0].innerHTML = located.get('n');
    
    let paramsUser = {
        sessionid: located.get('ssid'),
    };
    
    //  Obtenemos los privilegios del usuario
    callWS("GET", "privileges/entrybyuser", paramsUser, respxList);
    
    function respxList(status, respText){
        if (status === 200){
            console.log(status);
            console.log(JSON.parse(respText));
            var json = JSON.parse(respText);
            
            // Recorremos los privilegios, validamos que tiene permisos de coordinador primero
            json.privileges.map(el => {
                if(el.grp == "COORDINADOR ORM" || el.grp == "PROFESORES"){
                    isTeacher = true;
                }
                
                if(el.id == 46){
                    isAdmin = true;
                }
            });
            
            if(isTeacher){
                entryExamData();
            }
        }else if(status == 403){
            privilegeError();
        }else if(status == 500){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "Error interno";
            gotoTop();
            
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }
    }
}

function entryExamData(){
    let paramsUser = {
        sessionid: located.get('ssid'),
        answerid: located.get('answerid'),
    };
    callWS("GET", "nationals/entry", paramsUser, respxEntry);
    
    function respxEntry(status, respText){
        if (status === 200){
            console.log(status);
            console.log(JSON.parse(respText));
            var json = JSON.parse(respText);
            
            // Si el examen esta completo mostramos el resumen
            if(json.entry.completed != null || json.entry.saved){
                showResume(json);
                questionsArr = json.entry.questions;
                // contamos la cantidad de preguntas
                var count = 0;
                json.entry.questions.map(el => {
                    if (el.question.id != 0) {
                        count++;
                    }
                });
                answerid = json.entry.id;
                numQuestions = count;
                makeNumbers(question, true);
                
                if (json.entry.saved && json.entry.completed == null){
                    document.getElementById('completedSave').style.display = 'block';
                    document.getElementById('saveCorrection').style.display = 'block';
                } else if (json.entry.saved && json.entry.completed != null) {
                    document.getElementById('completedSave').style.display = 'none';
                }
            } else {
                document.getElementById('correctionMainBox').style.display = 'block';
                document.getElementById('watchDetails').style.display = 'none';
                document.getElementById('resumeBox').style.display = 'none';
                document.getElementById('watchResume').style.display = 'none';
                // datos generales
                document.getElementById('titlePupil').innerHTML = `${json.entry.pupil.code} - ${json.entry.test.testlevel}${abrev(json.entry.test.testlevel)} Grado`;
                questionsArr = json.entry.questions;
                // contamos la cantidad de preguntas
                var count = 0;
                json.entry.questions.map(el => {
                    if (el.question.id != 0) {
                        count++;
                    }
                });
                answerid = json.entry.id;
                numQuestions = count;
                makeNumbers(question, true);
            }
            
        }else if(status == 403){
            privilegeError();
        }else if(status == 500){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "Error interno";
            gotoTop();
            
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }
    }
}

function privilegeError(){
    var msg = document.getElementById('msgApi');
    msg.style.display="block";
    msg.innerHTML = "No posee privilegios";
    gotoTop();
}

function watchResume(){
    document.getElementById('correctionMainBox').style.display = 'none';
    document.getElementById('watchResume').style.display = 'none';
    document.getElementById('resumeBox').style.display = 'block';
    document.getElementById('watchDetails').style.display = 'block';
    
    let paramsUser = {
        sessionid: located.get('ssid'),
        answerid: located.get('answerid'),
    };
    callWS("GET", "nationals/entry", paramsUser, respxEntry);
    
    function respxEntry(status, respText){
        if (status === 200){
            console.log(status);
            console.log(JSON.parse(respText));
            var json = JSON.parse(respText);
            document.getElementById('modalFinal').style.display = 'none';
            // Si esta completo, blanqueamos la pantallas
            if (json.entry.completed != null || json.entry.saved) {
                showResume(json);
                
                if (json.entry.saved && json.entry.completed == null){
                    document.getElementById('completedSave').style.display = 'block';
                    document.getElementById('saveCorrection').style.display = 'block';
                } else if (json.entry.saved && json.entry.completed != null) {
                    document.getElementById('completedSave').style.display = 'none';
                }
            }
        }else if(status == 403){
            privilegeError();
        }else if(status == 500){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "Error interno";
            gotoTop();
            
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }
    }
}

function watchDetails(){
    document.getElementById('correctionMainBox').style.display = 'block';
    document.getElementById('watchResume').style.display = 'block';
    document.getElementById('resumeBox').style.display = 'none';
    document.getElementById('watchDetails').style.display = 'none';
    makeNumbers(1);
}

const abrev = level => {
    return level == "3" || level == "1" ? "er" : (level == "2" ? "do" : "to");
}

function openNewTab(url) {
    window.open(url);
}

function loadQuestion(id) {
    document.getElementById('titleQuestion').innerHTML = questionsArr[id].question.label;
    document.getElementById('questionDsc').innerHTML = questionsArr[id].question.dsc;
    if(questionsArr[id].question.image.url === null){
        document.getElementById('questionImg').src = "";
        document.getElementById('questionImg').style.display = "none";
        document.getElementById('questionImg').setAttribute("onclick", ``);
    } else {
        document.getElementById('questionImg').src = questionsArr[id].question.image.url;
        document.getElementById('questionImg').style.display = "block";
    }
    
    var options = '';
    // Las opciones
    questionsArr[id].options.map(el => {
        options += `
            <div class="optionBoxQuestion">
                ${el.label != "" ? (`
                    <h2 class="subtitleQuestion">${el.label}</h2>
                `) : ""}
                <ul>
                    <li><p class="questionDsc">${el.dsc}</p></li>
                </ul>
                ${el.image.url !== null ? (`
                    <img src="${el.image.url}" alt="Option" class="imgQuestionGlobal" />
                `) : ''}
            </div>
        `;
    });
    document.getElementById("optionsQuestion").innerHTML = options;
    
    // Respuestas sin imagen
    var answers = '';
    if(questionsArr[id].answer != null){
        var answersArr = questionsArr[id].answer.split("|");
        // Las opciones
        answersArr.map((el, index) => {
            answers += `
                <div>
                    <h2 class="subtitleQuestion">Respuesta ${answersArr.length > 1 ? index+1+" " : ``} del alumno</h2>
                    <ul>
                        <li class="answerPupil"><p class="questionDsc">${el == "" ? "Sin Responder" : el}</p></li>
                    </ul>
                </div>
            `;
        });
    } else {
        answers = `
            <div>
                <h2 class="subtitleQuestion">Sin Responder</h2>
            </div>
        `;
    }
    document.getElementById("answerText").innerHTML = answers;
    
    // Obtenemos los archivos anexos
    var files = '';
    var selectedImg = '';
    if(questionsArr[id].files.length > 0){
        
        questionsArr[id].files.map((el, index) => {
            if (index == 0) {
                selectedImg = el.url;
            }
            files += `
                <div class="carouselItemBox">
                    <img src="${el.url}" alt="anexo" class="carouselItem" onclick="selectImg('${el.url}')"/>
                </div>
            `;
        });
        document.getElementById('selectedImgAnswer').style.display = 'block';
        document.getElementsByClassName('arrowBox')[0].style.display = 'flex';
        document.getElementById('selectedImgAnswer').src = selectedImg;
    } else {
        files = `No posee archivos anexados`;
        document.getElementById('selectedImgAnswer').style.display = 'none';
        document.getElementsByClassName('arrowBox')[0].style.display = 'none';
        document.getElementById('selectedImgAnswer').src = "";
    }
    
    document.getElementById('carousel').innerHTML = files;
    
    // Guardamos las observaciones
    document.getElementById('observationsInput').value = questionsArr[id].observation;
    document.getElementById('scoreInput').value = questionsArr[id].score;
    
    document.getElementById('saveCorrection').setAttribute('onclick', `updateQuestion(${answerid}, ${question})`);
}

function selectImg(url){
    document.getElementById('selectedImgAnswer').src = url;
}

function makeNumbers(currentQuestion, firsttime = null) {
    // validamos que el score y las observaciones sean distintas, si es asi, le decimos que guarde
    let observationsVal = document.getElementById('observationsInput').value;
    let scoreVal = document.getElementById('scoreInput').value;
    if ((scoreVal != questionsArr[question-1].score || observationsVal != questionsArr[question-1].observation) && firsttime == null) {
        alert('Para pasar a de pregunta debe guardar los cambios');
    } else {
        question = currentQuestion;
        loadQuestion(currentQuestion-1);
        var container = document.getElementsByClassName('listPages')[0];
        container.innerHTML = '';
        var linkers = "";
        let interations = numQuestions;
        console.log(question, interations);
        linkers += question == 1 ? '' : `<li><span onclick='makeNumbers(${question === 1 ? 1 : question-1})' class="pagination"><</span></li>`;
        linkers += `<li><span onclick='makeNumbers(${question})' class="pagination" id="${question}">${question}</span></li>`;
        linkers += question == interations ? '' : `<li><span onclick='makeNumbers(${question === numQuestions ? numQuestions : question + 1})' class="pagination">></span></li>`;
        container.innerHTML = linkers;
        document.getElementById(`${question}`).style.color = 'rgb(154, 55, 30)';
    }
}

function goBackReview() {
    document.getElementById('modalFinal').style.display = 'none';
    document.getElementById('observationsInput').value = '';
    document.getElementById('scoreInput').value = 0;
    makeNumbers(1);
}

function completedCorrection(){
    let params = {
        sessionid: located.get('ssid'),
        answerid: answerid,
        completed: 1,
    };
    
    callWS("GET", "nationals/update", params, respxEntry);
    
    function respxEntry(status, respText){
        if (status === 200){
            console.log(status);
            console.log(JSON.parse(respText));
            var json = JSON.parse(respText);
            
            navigationMenu('nationals');
        }else if(status == 403){
            privilegeError();
        }else if(status == 500){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "Error interno";
            gotoTop();
            
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }
    }
}

function updateQuestion(answerid, qid, lastQuestion = false){
    let observationsVal = document.getElementById('observationsInput').value;
    let scoreVal = document.getElementById('scoreInput').value;
    
    // validamos que las observaciones esten hechas y que la puntuacion sea mayor a 0
    
    if(scoreVal < 0 || scoreVal > 4){
        var msg = document.getElementById('msgApi');
        msg.style.display="block";
        msg.innerHTML = "Puntuación inválida";
        gotoTop();
                
        setTimeout(() => {
            msg.style.display="none";
        },5000);
        return 0;
    }
    
    if(observationsVal == ""){
        var msg = document.getElementById('msgApi');
        msg.style.display="block";
        msg.innerHTML = "Observaciones son requeridas";
        gotoTop();
                
        setTimeout(() => {
            msg.style.display="none";
        },5000);
        return 0;
    }
    
    // Si es la ultima pregunta le mostramos el modal
    if(numQuestions == qid){
        // Si vienes del modal esto sera true y lo dejaremos apsar
        if(!lastQuestion){
            updateQuestion(answerid, question, true);
            return 0;
        }else{
            document.getElementById('modalFinal').style.display = 'none';
        }
    }
    
    let params = {
        qid: qid,
        answerid: answerid,
        observation: observationsVal,
        score: scoreVal,
        sessionid: located.get('ssid'),
    };
    
    callWS("GET", "nationals/update", params, respxEntry);
    
    function respxEntry(status, respText){
        if (status === 200){
            console.log(status);
            console.log(JSON.parse(respText));
            var json = JSON.parse(respText);
            
            let paramsUser = {
                sessionid: located.get('ssid'),
                answerid: located.get('answerid'),
            };
            callWS("GET", "nationals/entry", paramsUser, respxEntry);
            
            function respxEntry(status, respText){
                if (status === 200){
                    console.log(status);
                    console.log(JSON.parse(respText));
                    var json = JSON.parse(respText);
                    // datos generales
                    questionsArr = json.entry.questions;
                    document.getElementById('modalFinal').style.display = 'none';
                    console.log(lastQuestion);
                    // Si esta completo, blanqueamos la pantallas
                    if (json.entry.completed != null || json.entry.saved) {
                        console.log(lastQuestion);
                        if(lastQuestion){
                            showResume(json);
                            if (json.entry.saved && json.entry.completed == null){
                                document.getElementById('completedSave').style.display = 'block';
                                document.getElementById('saveCorrection').style.display = 'block';
                            } else if (json.entry.saved && json.entry.completed != null) {
                                document.getElementById('completedSave').style.display = 'none';
                            }
                        }else{
                            document.getElementById('correctionMainBox').style.display = 'block';
                            document.getElementById('resumeBox').style.display = 'none';
                            console.log(question);
                            if(questionsArr[question].question.id != 0){
                                makeNumbers(question+1);
                            }
                        }
                        
                    }else{
                        if(lastQuestion){
                            showResume(json);
                        }else{
                            document.getElementById('correctionMainBox').style.display = 'block';
                            document.getElementById('resumeBox').style.display = 'none';
                            console.log(question);
                            if(questionsArr[question].question.id != 0){
                                makeNumbers(question+1);
                            }
                        }
                    }
                }else if(status == 403){
                    privilegeError();
                }else if(status == 500){
                    var msg = document.getElementById('msgApi');
                    msg.style.display="block";
                    msg.innerHTML = "Error interno";
                    gotoTop();
                    
                    setTimeout(() => {
                        msg.style.display="none";
                    },5000)
                }
            }
        }else if(status == 403){
            privilegeError();
        }else if(status == 500){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "Error interno";
            gotoTop();
            
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }
    }
}

function showResume(json){
    document.getElementById('correctionMainBox').style.display = 'none';
    document.getElementById('watchResume').style.display = 'none';
    document.getElementById('resumeBox').style.display = 'block';
    document.getElementById('watchDetails').style.display = 'block';
    // datos generales
    // datos generales
    if(!isAdmin){
        console.log(isAdmin);
        document.getElementById('saveCorrection').style.display = 'none';
    }
    document.getElementById('titlePupilResume').innerHTML = `${json.entry.pupil.code} - ${json.entry.test.testlevel}${abrev(json.entry.test.testlevel)} Grado`;
    document.getElementById('finalClasification').innerHTML = `Calificación: ${json.entry.score}`;
    document.getElementById('teacherName').innerHTML = `${json.entry.teachername}`;
    let box = document.getElementById('resumeBoxDetails');
    box.innerHTML = '';
    json.entry.questions.map(el => {
        if(el.question.label != null){
            box.innerHTML += `
                <div class="rowQuestion">
                    <div class="colLabel">
                        <span>${el.question.label}</span>
                    </div>
                    <div class="colObs">
                        <span>${el.observation}</span>
                    </div>
                    <div class="colScore">
                        <span>${el.score}</span>
                    </div>
                </div>
            `;
        }
    });
    
    document.getElementById('titlePupil').innerHTML = `${json.entry.pupil.code} - ${json.entry.test.testlevel}${abrev(json.entry.test.testlevel)} Grado`;
}

function rotateImage(direction){
    if (direction < 0) {
        rotatePos = rotatePos - direction == 0 ? 270 : rotatePos-direction;
    }else {
        rotatePos = rotatePos + direction == 360 ? 0 : rotatePos+direction;
    }
    document.getElementById('selectedImgAnswer').style.transform = `rotate(${rotatePos}deg)`;
    console.log(document.getElementById('selectedImgAnswer').style.transform);
}