var located = new URLSearchParams(location.search);
var priviligies;
var numPagesRoles;
var pageRoles = located.get("pageRoles") === null ? 1 : parseInt(located.get("pageRoles"));
var numOfRecordsRoles = 0;
var qtyForPage = 10;
var rolidSelected = 0;

window.onload = function carga() {
    var located = new URLSearchParams(location.search);
    
    let currentLocation = document.getElementsByClassName('registerUsers') [0];
    currentLocation.setAttribute("id","locationUrl");
    document.getElementsByClassName('userName')[0].innerHTML = located.get('n');
    
    var params = {
        sessionid: located.get('ssid'),
        offset: 0,
        numofrecords: 1000
    };
    
    callWS('GET','privileges/list',params, resp);
    
    function resp(status, rsp){
        let json = JSON.parse(rsp);
        console.log(status);
        switch(status){
            case 200:
                priviligies = json.records;
                break;
            case 403:
                var msg = document.getElementById('error');
                msg.style.display="block";
                msg.innerHTML = "No posee privilegios";
                gotoTop();
                
                setTimeout(() => {
                    msg.style.display="none";
                },5000)
                break;
            case 500:
                var msg = document.getElementById('error');
                msg.innerHTML = 'Error interno';
                msg.style.display = 'block';
                gotoTop();
                                
                setTimeout(() => {
                    msg.style.display = 'none';
                }, 2000);
                break;
            default:
                var msg = document.getElementById('error');
                msg.innerHTML = json.msg;
                msg.style.display = 'block';
                gotoTop();
                    
                setTimeout(() => {
                    msg.style.display = 'none';
                }, 2000);
        }
    }
    
    params = {
        sessionid: located.get('ssid'),
        offset: (pageRoles - 1) * qtyForPage,
        numofrecords: qtyForPage
    }
    
    callListOfRoles(params);
}

function callListOfRoles(params){
    callWS('GET', 'roles/list', params, resp2);
    
    function resp2(status, rsp){
        let json = JSON.parse(rsp);
        console.log(status);
        switch(status){
            case 200:
                console.log(json);
                console.log('ok');
                numPagesRoles = Math.ceil(json.numofrecords/qtyForPage);
                numOfRecordsRoles = json.numofrecords;
                drawRols(json.records);
                break;
            case 403:
                var msg = document.getElementById('error');
                msg.style.display="block";
                msg.innerHTML = "No posee privilegios";
                gotoTop();
                
                setTimeout(() => {
                    msg.style.display="none";
                },5000)
                break;
            case 500:
                var msg = document.getElementById('error');
                msg.innerHTML = 'Error interno';
                msg.style.display = 'block';
                gotoTop();
                                
                setTimeout(() => {
                    msg.style.display = 'none';
                }, 2000);
                break;
            default:
                var msg = document.getElementById('error');
                msg.innerHTML = json.msg;
                msg.style.display = 'block';
                gotoTop();
                    
                setTimeout(() => {
                    msg.style.display = 'none';
                }, 2000);
        }
    }
}

function drawRols(rol){
    let box = document.getElementById('roleInformation');
    if(rol == null){
        box.innerHTML += `
        <div class="roleData" id="0">
            <span id="nextRole"></span>
            <input type="text" id="newRole" placeholder="Rol..."/>
            <div class="boxLessPlus">
                <svg viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg" class="icons hideInput" id="overWriteRol0">
                    <g data-name="Layer 5" id="Layer_5">
                        <path d="M6.47,25l8.41-3.46,15-15L24.92,1.63l-15,15Zm5.16-7.28L24.92,4.45l2.13,2.13L13.75,19.87l-3.6,1.48ZM30,12V30H2V2H20V4H4V28H28V12Z"/>
                    </g>
                </svg>
                <span class="lessCircle hideInput" id="lessRol0"></span>
                <span class="plusCircle" id="uniquePlus" onclick="addNewRoleData(0)"></span>
            </div>
        </div>`;
    }else{
        for(let i = 0; i < rol.length; i++){
            box.innerHTML += `
            <div class="roleData">
                <span id="rol${rol[i].id}">${rol[i].user}</span>
                <input type="text" class="hideInput" placeholder="Rol..."/>
                <div class="boxLessPlus">
                    <svg viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg" class="icons" id="overWriteRol${rol[i].id}" onclick="detailRole('rol${rol[i].id}','text', ${rol[i].id})">
                        <g data-name="Layer 5" id="Layer_5">
                            <path d="M6.47,25l8.41-3.46,15-15L24.92,1.63l-15,15Zm5.16-7.28L24.92,4.45l2.13,2.13L13.75,19.87l-3.6,1.48ZM30,12V30H2V2H20V4H4V28H28V12Z"/>
                        </g>
                    </svg>
                    <span class="lessCircle" id="lessRol${rol[i].id}" onclick="deleteRole(${rol[i].id}, '${rol[i].user}')"></span>
                    <span class="plusCircle hideInput"></span>
                </div>
            </div>`;
        }
        box.innerHTML += `
        <div class="roleData">
            <span id="nextRole"></span>
            <input type="text" id="newRole" placeholder="Rol..."/>
            <div class="boxLessPlus">
                <svg viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg" class="icons hideInput" id="overWriteRol0">
                    <g data-name="Layer 5" id="Layer_5">
                        <path d="M6.47,25l8.41-3.46,15-15L24.92,1.63l-15,15Zm5.16-7.28L24.92,4.45l2.13,2.13L13.75,19.87l-3.6,1.48ZM30,12V30H2V2H20V4H4V28H28V12Z"/>
                    </g>
                </svg>
                <span class="lessCircle hideInput" id="lessRol0"></span>
                <span class="plusCircle" id="uniquePlus" onclick="addNewRoleData(0)"></span>
            </div>
        </div>`;
        
        
        if(located.get('rolid') !== null && located.get('rolid') !== undefined){
            
            if(document.getElementById(located.get('rolid')) != null && document.getElementById(located.get('rolid')) != undefined){
                detailRole(`rol${located.get('rolid')}`,'text', located.get('rolid'));
            }
        }
    }
    
    makeNumbersRoles();
    
}

const makeNumbersRoles = () => {
    var container = document.getElementById('listPagesRoles');
    var linkers = "";
    let interations = numPagesRoles > 10 ? 10 : numPagesRoles;
    for(let i = 0; i < interations; i++){
        
        if(numPagesRoles == 1){
            linkers += `<li><a href='javascript:paginationNavigate(${i+1})' class="pagination" id="${i+1}">${i+1}</a></li>`;
        }else if(pageRoles+i <= numPagesRoles){
            if(i === 0){
            
                linkers +=`<li><a href='javascript:paginationNavigate(${1})' class="pagination"><<</a></div>`;
                linkers +=`<li><a href='javascript:paginationNavigate(${pageRoles === 1 ? 1 : pageRoles-1})' class="pagination"><</a></li>`;
                linkers += pageRoles === 1 ? '' : `<li><a href='javascript:paginationNavigate(${pageRoles-1})' class="pagination" id="${pageRoles-1}">${pageRoles-1}</a></li>`;
                linkers += `<li><a href='javascript:paginationNavigate(${pageRoles})' class="pagination" id="${pageRoles}">${pageRoles}</a></li>`;
            
            }else if(i == interations-1){
            
                linkers += `<li><a href='javascript:paginationNavigate(${pageRoles+i})' class="pagination" id="${pageRoles+i}">${pageRoles+i}</a></li>`;
            
                linkers +=`<li><a href='javascript:paginationNavigate(${pageRoles === numPagesRoles ? numPagesRoles : pageRoles + 1})' class="pagination">></a></li>`;
            
                linkers +=`<li><a href='javascript:paginationNavigate(${numPagesRoles})' class="pagination">>></a></li>`;
            }else{
            
                linkers += `<li><a href='javascript:paginationNavigate(${pageRoles+i})' class="pagination" id="${pageRoles+i}">${pageRoles+i}</a></li>`;
            
            }
        }
        
    }
    container.innerHTML = linkers;
    if(document.getElementById(`${pageRoles}`) != undefined){
        document.getElementById(`${pageRoles}`).style.color = '#F68E1E';
    }
}

function paginationNavigate(pageR){
    let located = new URLSearchParams(location.search);
    var params = {
        sessionid: located.get('ssid'),
        offset: (pageR - 1) * qtyForPage,
        numofrecords: qtyForPage
    }
    
    pageRoles = pageR;
    
    document.getElementById('roleInformation').innerHTML = '';
    
    callListOfRoles(params)
    //gotoPage('home','role',params);
}

function addNewRoleData(id){
    var located = new URLSearchParams(location.search);
    let params = {};
    params.sessionid = located.get('ssid');
    params.id = id;
    params.name = document.getElementById('newRole').value;
    params.status = 1;
    
    if(params.name == ""){
        var msg = document.getElementById('error');
        msg.innerHTML = 'Campo no puede estar vac&iacute;o';
        msg.style.display = 'block';
        gotoTop();
        
        setTimeout(() => {
            msg.style.display = 'none';
        }, 2000);
        
        return 0;
    }
    
    callWS('GET','roles/update',params,response);
    
    function response(status, respx){
        let json = JSON.parse(respx);
        console.log(status);
        console.log(json);
        switch(status){
            case 200:
                 document.getElementById('nextRole').innerHTML = document.getElementById('newRole').value;
                document.getElementById('nextRole').setAttribute("id",`rol${json.id}`);
                
                document.getElementById('newRole').classList.toggle("hideInput");
                document.getElementById('newRole').removeAttribute("id");
                
                document.getElementById('overWriteRol0').setAttribute("onclick",`detailRole('rol${json.id}','text', ${json.id})`);
                document.getElementById('overWriteRol0').classList.toggle("hideInput");
                document.getElementById('overWriteRol0').setAttribute("id",`$overWriteRol${json.id}`);
                
                document.getElementById('lessRol0').classList.toggle("hideInput");
                document.getElementById('lessRol0').setAttribute("onclick",`deleteRole(${json.id}, '${params.name}')`);
                document.getElementById('lessRol0').setAttribute("id",`lessRol${json.id}`);
            
                let plusCircle = document.getElementById('uniquePlus');
                plusCircle.removeAttribute("class");
                plusCircle.removeAttribute("id");
                plusCircle.removeAttribute("onclick");
                
                let box = document.getElementById('roleInformation');
                box.innerHTML += `
                    <div class="roleData">
                        <span id="nextRole"></span>
                        <input type="text" id="newRole" placeholder="Rol..."/>
                        <div class="boxLessPlus">
                            <svg viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg" class="icons hideInput" id="overWriteRol0">
                                <g data-name="Layer 5" id="Layer_5">
                                    <path d="M6.47,25l8.41-3.46,15-15L24.92,1.63l-15,15Zm5.16-7.28L24.92,4.45l2.13,2.13L13.75,19.87l-3.6,1.48ZM30,12V30H2V2H20V4H4V28H28V12Z"/>
                                </g>
                            </svg>
                            <span class="lessCircle hideInput" id="lessRol0"></span>
                            <span class="plusCircle" id="uniquePlus" onclick="addNewRoleData(0)"></span>
                        </div>
                    </div>`;
                
                break;
            case 403:
                var msg = document.getElementById('error');
                msg.style.display="block";
                msg.innerHTML = "No posee privilegios";
                gotoTop();
                
                setTimeout(() => {
                    msg.style.display="none";
                },5000)
                break;
            case 500:
                var msg = document.getElementById('error');
                msg.innerHTML = 'Error interno';
                msg.style.display = 'block';
                gotoTop();
                                
                setTimeout(() => {
                    msg.style.display = 'none';
                }, 2000);
                break;
            default:
                var msg = document.getElementById('error');
                msg.innerHTML = json.msg;
                msg.style.display = 'block';
                gotoTop();
                    
                setTimeout(() => {
                    msg.style.display = 'none';
                }, 2000);
        }
    }
}

function addNewRole(){
    let box = document.getElementById('roleInformation');
    let roleInput = document.getElementById('newRole');
    if(roleInput === null){
        let plusCircle = document.getElementById('uniquePlus');
        plusCircle.removeAttribute("class");
        plusCircle.removeAttribute("id");
        plusCircle.removeAttribute("onclick");
        box.innerHTML += `
        <div class="roleData" id="0">
            <span id="nextRole"></span>
            <input type="text" id="newRole" placeholder="Rol..."/>
            <div class="boxLessPlus">
                <svg viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg" class="icons hideInput" id="overWrite">
                    <g data-name="Layer 5" id="Layer_5">
                        <path d="M6.47,25l8.41-3.46,15-15L24.92,1.63l-15,15Zm5.16-7.28L24.92,4.45l2.13,2.13L13.75,19.87l-3.6,1.48ZM30,12V30H2V2H20V4H4V28H28V12Z"/>
                    </g>
                </svg>
                <span class="lessCircle"></span>
                <span class="plusCircle" id="uniquePlus" onclick="addNewRole()"></span>
            </div>
        </div>`;
    }else{
        if(roleInput.value !== ""){
            document.getElementById('nextRole').innerHTML = roleInput.value;
            document.getElementById('nextRole').setAttribute("id",roleInput.value);
            document.getElementById('newRole').classList.toggle("hideInput");
            document.getElementById('newRole').removeAttribute("id");
            document.getElementById('overWrite').setAttribute("onclick",`detailRole('${roleInput.value}','text')`);
            document.getElementById('overWrite').classList.toggle("hideInput");
            document.getElementById('overWrite').removeAttribute("id");
            
            let plusCircle = document.getElementById('uniquePlus');
            plusCircle.removeAttribute("class");
            plusCircle.removeAttribute("id");
            plusCircle.removeAttribute("onclick");
            box.innerHTML += `
            <div class="roleData">
                <span id="nextRole"></span>
                <input type="text" id="newRole" placeholder="Rol..."/>
                <div class="boxLessPlus">
                    <svg viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg" class="icons hideInput" id="overWrite">
                        <g data-name="Layer 5" id="Layer_5">
                        <path d="M6.47,25l8.41-3.46,15-15L24.92,1.63l-15,15Zm5.16-7.28L24.92,4.45l2.13,2.13L13.75,19.87l-3.6,1.48ZM30,12V30H2V2H20V4H4V28H28V12Z"/>
                        </g>
                    </svg>
                    <span class="lessCircle"></span>
                    <span class="plusCircle" id="uniquePlus" onclick="addNewRole()"></span>
                </div>
            </div>`;
        }else{
            alert('Rol Vacío');
        }
    }
}

function detailRole(idRol, from, idSelected){
    console.log(from);
    console.log(idRol);
    rolidSelected = idSelected;
    
    let params = {}
    params.rolid = idSelected;
    params.sessionid = located.get('ssid');
    
    callWS('GET','privileges/loadrolprivileges',params,response);
    
    function response(status, respx){
        let json = JSON.parse(respx);
        console.log(status);
        console.log(json);
        switch(status){
            case 200:
                if(from === "text"){
                    document.getElementById('currentRole').innerHTML = document.getElementById(idRol).innerHTML;
                    let content = "";
                    priviligies.forEach(val => {
                        content += `
                            <div class="inputRow">
                            <input type="checkbox" name="privilegeCheck" ${(json.privileges != null && json.privileges != undefined ? ""+validatePriv(val.id, json.privileges) : "" )} class="resetHeight" id="priv${val.id}" value="${val.id}"/>
                            <label for="priv${val.id}" class="priviligie">${val.grp}: ${val.dsc}</label>
                        </div>
                        `;
                    });
                    document.getElementById('rolePriviligies').innerHTML = content;
                }
                break;
            case 403:
                var msg = document.getElementById('error');
                msg.style.display="block";
                msg.innerHTML = "No posee privilegios";
                gotoTop();
                
                setTimeout(() => {
                    msg.style.display="none";
                },5000)
                break;
            case 500:
                var msg = document.getElementById('error');
                msg.innerHTML = 'Error interno';
                msg.style.display = 'block';
                gotoTop();
                                
                setTimeout(() => {
                    msg.style.display = 'none';
                }, 2000);
                break;
            default:
                var msg = document.getElementById('error');
                msg.innerHTML = json.msg;
                msg.style.display = 'block';
                gotoTop();
                    
                setTimeout(() => {
                    msg.style.display = 'none';
                }, 2000);
        }
    }
}

function validatePriv(current, arr){
    let valid = 0;
    arr.forEach(val => {
        if(val.id == current){
            console.log(val.id == current);
            valid = 1;
        }
    });
    
    if (valid == 1){
        return "checked";
    }else{
        return '';
    }
    
    
}

function clearDetails(){
    document.getElementById('currentRole').innerHTML = "";
    document.getElementById('rolePriviligies').innerHTML = "";
}

function updatePrivileges(){
    // Obtenemos los parametros para actualizar los privilegios
    let params = {}
    
    params.sessionid = located.get('ssid');
    params.rolid = rolidSelected;
    params.privileges = '';
    
    // Recorremos los checkbox
    let checkboxes = document.getElementsByName('privilegeCheck');
    
    checkboxes.forEach(val => {
       if(val.checked){
           
           if(params.privileges == ''){
               params.privileges += val.value;
           }else{
               params.privileges += "-"+val.value;
           }
           
       } 
    });
    
    callWS('GET','privileges/saverolprivileges',params,response);
    
    function response(status, respx){
        let json = JSON.parse(respx);
        console.log(status);
        console.log(json);
        switch(status){
            case 200:
                var msg = document.getElementById('msgApi');
                msg.innerHTML = "Rol actualizado exitosamente";
                msg.style.display = 'block';
                gotoTop();
                
                setTimeout(() => {
                    msg.style.display = 'none';
                }, 2000);
                break;
            case 403:
                var msg = document.getElementById('error');
                msg.style.display="block";
                msg.innerHTML = "No posee privilegios";
                gotoTop();
                
                setTimeout(() => {
                    msg.style.display="none";
                },5000)
                break;
            case 500:
                var msg = document.getElementById('error');
                msg.innerHTML = 'Error interno';
                msg.style.display = 'block';
                gotoTop();
                                    
                setTimeout(() => {
                    msg.style.display = 'none';
                }, 2000);
                break;
            default:
                var msg = document.getElementById('error');
                msg.innerHTML = json.msg;
                msg.style.display = 'block';
                gotoTop();
                                
                setTimeout(() => {
                    msg.style.display = 'none';
                }, 2000);                    
        }
    }
}

function deleteRole(rolid, rolname){
    // Mostramos un pequeno modal para validar que se desea borrar
    rolidSelected = rolid;
    document.getElementById('modalCandeled').style.display = 'flex';
    document.getElementById('msgDeleteRole').innerHTML = `Seguro que desea borrar el rol ${rolname}?`;
}


function choiseWay(e){
    if(e.target.id == "canceldelete"){
        document.getElementById('modalCandeled').style.display = 'none';
    }else{
        console.log(rolidSelected);
        
        let params = {
            id: rolidSelected,
            sessionid: located.get('ssid'),
        }
        console.log(params);
        
        callWS('GET','roles/delete',params,response);
        
        function response(status, respx){
            let json = JSON.parse(respx);
            console.log(status);
            console.log(json);
            switch(status){
                case 200:

                    document.getElementById('modalCandeled').style.display = 'none';
                    document.getElementById('roleInformation').innerHTML = '';
                    var msg = document.getElementById('msgApi');
                    msg.innerHTML = "Rol eliminado exitosamente";
                    msg.style.display = 'block';
                    gotoTop();
                    
                    setTimeout(() => {
                        msg.style.display = 'none';
                    }, 2000);
                    
                    
                    pageRoles = 1;
                    
                    params = {
                        sessionid: located.get('ssid'),
                        offset: (pageRoles - 1) * qtyForPage,
                        numofrecords: qtyForPage
                    }
                    
                    callWS('GET', 'roles/list', params, resp2);
                    
                    function resp2(status, rsp){
                        let json = JSON.parse(rsp);
                        console.log(status);
                        switch(status){
                            case 200:
                                console.log(json);
                                numPagesRoles = Math.ceil(json.numofrecords/qtyForPage);
                                numOfRecordsRoles = json.numofrecords;
                                drawRols(json.records);
                                break;
                            case 500:
                                var msg = document.getElementById('error');
                                msg.innerHTML = 'Error interno';
                                msg.style.display = 'block';
                                gotoTop();
                                
                                setTimeout(() => {
                                    msg.style.display = 'none';
                                }, 2000);
                                break;
                            default:
                                var msg = document.getElementById('error');
                                msg.innerHTML = json.msg;
                                msg.style.display = 'block';
                                gotoTop();
                                
                                setTimeout(() => {
                                    msg.style.display = 'none';
                                }, 2000);
                        }
                    }
                    break;
                case 204:
                    document.getElementById('modalCandeled').style.display = 'none';
                    var msg = document.getElementById('error');
                    msg.innerHTML = 'Registro no encontrado';
                    msg.style.display = 'block';
                    gotoTop();
                    
                    setTimeout(() => {
                        msg.style.display = 'none';
                    }, 2000);
                    break;
                case 403:
                    document.getElementById('modalCandeled').style.display = 'none';
                    var msg = document.getElementById('error');
                    msg.style.display="block";
                    msg.innerHTML = "No posee privilegios";
                    gotoTop();
                    
                    setTimeout(() => {
                        msg.style.display="none";
                    },5000)
                    break;
                case 500:
                    document.getElementById('modalCandeled').style.display = 'none';
                    var msg = document.getElementById('error');
                    msg.innerHTML = 'Error interno';
                    msg.style.display = 'block';
                    gotoTop();
                    
                    setTimeout(() => {
                        msg.style.display = 'none';
                    }, 2000);
                    break;
                default:
                    document.getElementById('modalCandeled').style.display = 'none';
                    var msg = document.getElementById('error');
                    msg.innerHTML = json.msg;
                    msg.style.display = 'block';
                    gotoTop();
                    
                    setTimeout(() => {
                        msg.style.display = 'none';
                    }, 2000);
            }
        }
    }
}