var imagesArr;
var pupilid;
var grade;
window.onload = function carga() {
    loadScreen();
    var located = new URLSearchParams(location.search);
    addQuestions();
    let currentLocation = document.getElementsByClassName('tests') [0];
    currentLocation.setAttribute("id","locationUrl");
    document.getElementsByClassName('userName')[0].innerHTML = located.get('n');
    
    var params = {
        sessionid: located.get('ssid'),
        numofrecords: 0,
    };
    getImagesFromDir(params);
}

function getImagesFromDir(params){
    callWS("GET", "tests/listnew", params, respx);
    
    console.log(params);
    function respx(status, respText){
        console.log(status);
        
        if (status == 200){
            console.log(JSON.parse(respText));
            var json = JSON.parse(respText);
            console.log('ok');
            addDataImages(json);
        }else if(status == 403){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "No posee privilegios";
            gotoTop();
            
            /*setTimeout(() => {
                msg.style.display="none";
            },5000)*/
        }else if(status == 500){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "Error interno";
            gotoTop();
            
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }
    }
}

function addQuestions(){
    let allQuestions = "";
    for(let i = 0; i < 30; i++){
        allQuestions += `
        <div class="dataRow sepQuestion labelRadio">
            <span class="labelAnwser">Pregunta ${i+1}:</span>
                <div class="checksEntry">
                    <div>
                        <input type="radio" class="checkboxData" value="0" name="answer${i+1}" id="nc${i+1}" checked/>
                        <label for="nc${i+1}">N/C</label>
                    </div>
                    <div>
                        <input type="radio" class="checkboxData" value="1" name="answer${i+1}" id="firstRes${i+1}"/>
                        <label for="firstRes${i+1}">1</label>
                    </div>
                    <div>
                        <input type="radio" class="checkboxData" value="2" name="answer${i+1}" id="secondRes${i+1}"/>
                        <label for="secondRes${i+1}">2</label>
                    </div>
                    <div>
                        <input type="radio" class="checkboxData" value="3" name="answer${i+1}" id="thirdRes${i+1}"/>
                        <label for="thirdRes${i+1}">3</label>
                    </div>
                    <div>
                        <input type="radio" class="checkboxData" value="4" name="answer${i+1}" id="quarterRes${i+1}"/>
                        <label for="quarterRes${i+1}">4</label>
                    </div>
                    <div>
                        <input type="radio" class="checkboxData" value="5" name="answer${i+1}" id="fifthRes${i+1}"/>
                        <label for="fifthRes${i+1}">5</label>
                    </div>
                </div>
            </div>`;
    }
    document.getElementById('entryData').innerHTML = allQuestions;
}

function addDataImages(data){
    imagesArr = data;
    let tags = "";
    let finish = 4;
    if(imagesArr.numofrecords === 0){
        alert('No hay examenes para corregir');
        tags += "";
    }else{
        for(let i=0; i < data.records.length; i++){
        if( i === 0 || i % 4 === 0){
            
            tags += `<div class="imageButton">`;
        }
        
        tags += `
            <div class="imageData" onclick="changeImage(${i})">
                <div class="sepIcon">
                    <svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
	                viewBox="0 0 419.2 419.2" style="enable-background:new 0 0 419.2 419.2;" xml:space="preserve" class="icon">
                        <g><g><g>
			                 <circle class="fillSvg" cx="158" cy="144.4" r="28.8"/>
			                 <path class="fillSvg" d="M394.4,250.4c-13.6-12.8-30.8-21.2-49.6-23.6V80.4c0-15.6-6.4-29.6-16.4-40C318,30,304,24,288.4,24h-232
			                 	c-15.6,0-29.6,6.4-40,16.4C6,50.8,0,64.8,0,80.4v184.4V282v37.2c0,15.6,6.4,29.6,16.4,40c10.4,10.4,24.4,16.4,40,16.4h224.4
			                 	c14.8,12,33.2,19.6,53.6,19.6c23.6,0,44.8-9.6,60-24.8c15.2-15.2,24.8-36.4,24.8-60C419.2,286.8,409.6,265.6,394.4,250.4z
			                 	M21.2,80.4c0-9.6,4-18.4,10.4-24.8c6.4-6.4,15.2-10.4,24.8-10.4h232c9.6,0,18.4,4,24.8,10.4c6.4,6.4,10.4,15.2,10.4,24.8v124.8
			                 	l-59.2-58.8c-4-4-10.8-4.4-15.2,0L160,236l-60.4-60.8c-4-4-10.8-4.4-15.2,0l-63.2,64V80.4z M56,354.8v-0.4
			                 	c-9.6,0-18.4-4-24.8-10.4c-6-6.4-10-15.2-10-24.8V282v-12.8L92.4,198l60.4,60.4c4,4,10.8,4,15.2,0l89.2-89.6l58.4,58.8
			                 	c-1.2,0.4-2.4,0.8-3.6,1.2c-1.6,0.4-3.2,0.8-5.2,1.6c-1.6,0.4-3.2,1.2-4.8,1.6c-1.2,0.4-2,0.8-3.2,1.6c-1.6,0.8-2.8,1.2-4,2
			                 	c-2,1.2-4,2.4-6,3.6c-1.2,0.8-2,1.2-3.2,2c-0.8,0.4-1.2,0.8-2,1.2c-3.6,2.4-6.8,5.2-9.6,8.4c-15.2,15.2-24.8,36.4-24.8,60
			                 	c0,6,0.8,11.6,2,17.6c0.4,1.6,0.8,2.8,1.2,4.4c1.2,4,2.4,8,4,12v0.4c1.6,3.2,3.2,6.8,5.2,9.6H56z M378.8,355.2
			                 	c-11.6,11.6-27.2,18.4-44.8,18.4c-16.8,0-32.4-6.8-43.6-17.6c-1.6-1.6-3.2-3.6-4.8-5.2c-1.2-1.2-2.4-2.8-3.6-4
			                 	c-1.6-2-2.8-4.4-4-6.8c-0.8-1.6-1.6-2.8-2.4-4.4c-0.8-2-1.6-4.4-2-6.8c-0.4-1.6-1.2-3.6-1.6-5.2c-0.8-4-1.2-8.4-1.2-12.8
			                 	c0-17.6,7.2-33.2,18.4-44.8c11.6-11.6,27.2-18.4,44.8-18.4c17.6,0,33.2,7.2,44.8,18.4c11.6,11.2,18.4,27.2,18.4,44.8
			                 	C397.2,328,390,343.6,378.8,355.2z"/>
			                 <path class="fillSvg" d="M368.8,299.6h-24.4v-24.4c0-6-4.8-10.8-10.8-10.8s-10.8,4.8-10.8,10.8v24.4h-24.4c-6,0-10.8,4.8-10.8,10.8
			                 	s4.8,10.8,10.8,10.8h24.4v24.4c0,6,4.8,10.8,10.8,10.8s10.8-4.8,10.8-10.8v-24.4h24.4c6,0,10.8-4.8,10.8-10.8
			                 	S374.8,299.6,368.8,299.6z"/>
		              </g></g></g>
                    </svg>
                </div>
                <span>${data.records[i].filename}</span>
            </div>
        `;
        
        
        if(i+1 === finish){
            finish += 4;
            tags += `</div>`;
        }
    }
    changeImage(0);
    }
    
    document.getElementById('imageData').innerHTML = tags;
    closeLoad();
}

function changeImage(id){
    let pic = document.getElementById('examPic');
    pic.src=`./uploads/err/${imagesArr.records[id].filename}`;
    pic.name = id;
}

function deleteTest(){
    var located = new URLSearchParams(location.search);
    let params = {
        filename: document.getElementById('examPic').getAttribute("src"),
        sessionid: located.get('ssid')
    };
    
    loadScreen();
    callWS("GET", "tests/deletenew", params, respx);
    
    console.log(params);
    function respx(status, respText){
        console.log(status);
        
        if (status == 200){
            console.log(JSON.parse(respText));
            reload();
        }else if(status == 403){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "No posee privilegios";
            gotoTop();
            
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }else if(status == 500){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "Error interno";
            gotoTop();
            
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }
    }
}

function searchPupil(e){
    if(e.keyCode == 13){
        clearInput();
        pupilid = undefined;
        var located = new URLSearchParams(location.search);
        
        var params = {
            code: e.target.value,
            sessionid: located.get('ssid'),
        };
        
        getPupilInfo(params);
    }
}

function putPupilsData(student){
    pupilid = student.entry.pupil.id;
    grade = student.entry.pupil.level;
    document.getElementById('pupilCode').value = `${parseInt(student.entry.pupil.code)}`;
    document.getElementById('nameSurname').value = `${student.entry.pupil.name} ${student.entry.pupil.surname}`;
    
    document.getElementById('ci').value = `${student.entry.pupil.ci}`;
    
    document.getElementById('region').value = `${student.entry.school.region}`;
    document.getElementById('grade').value = `${student.entry.pupil.level} - ${student.entry.pupil.section}`;
    document.getElementById('collegeName').value = `${student.entry.school.name}`;
}

function reload(){
    clearInput();
    pupilid = undefined;
    var located = new URLSearchParams(location.search);
    var params = {
        sessionid: located.get('ssid'),
        numofrecords: 0,
    };
    
    getImagesFromDir(params);
}

function clearInput(){
    document.getElementById('nameSurname').value = ``;
    document.getElementById('pupilCode').valie = '';
    document.getElementById('ci').value = ``;
    document.getElementById('region').value = ``;
    document.getElementById('grade').value = ``;
    document.getElementById('collegeName').value = ``;
}

function saveData(){
    if(pupilid === undefined){
        alert('Debe Seleccionar un Alumno');
    }else if(document.getElementById('examPic').getAttribute("src") === ""){
        alert('No hay examenes para corregir');
    }else{
        var located = new URLSearchParams(location.search);
        let params = {
            sessionid: located.get('ssid'),
            grade: grade,
            imgurl: imagesArr.records[parseInt(document.getElementById('examPic').getAttribute("name"))].filename,
            pupilid: pupilid
        };
    
        for(let i = 1; i <= 30; i++){
            let radioGroup = document.getElementsByName(`answer${i}`);
            for(let j = 0; j < radioGroup.length ; j++){
                if(radioGroup[j].checked){
                    params['q'+ i] = radioGroup[j].value;
                }
            }
        }
        
        loadScreen();
        callWS("GET", "tests/insert", params, respx);
    
        console.log(params);
        function respx(status, respText){
            console.log(status);
            closeLoad();
            if (status == 200){
                console.log(JSON.parse(respText));
                var msg = document.getElementById('msgApi');
                msg.style.display="block";
                msg.innerHTML = 'Registro exitoso';
                gotoTop();
                
                setTimeout(() => {
                    msg.style.display="none";
                },5000)
                reload();
            }else if(status == 204){
                var msg = document.getElementById('msgApi');
                msg.style.display="block";
                msg.innerHTML = 'No se encuentra el registro';
                gotoTop();
                
                setTimeout(() => {
                    msg.style.display="none";
                },5000)
            }else if(status == 400){
                var msg = document.getElementById('msgApi');
                msg.style.display="block";
                msg.innerHTML = 'Error al insertar';
                gotoTop();
                
                setTimeout(() => {
                    msg.style.display="none";
                },5000)
            }else if(status == 409){
                var msg = document.getElementById('msgApi');
                msg.style.display="block";
                msg.innerHTML = 'Registro duplicado';
                gotoTop();
                
                setTimeout(() => {
                    msg.style.display="none";
                },5000)
            }else if(status == 403){
                var msg = document.getElementById('msgApi');
                msg.style.display="block";
                msg.innerHTML = "No posee privilegios";
                gotoTop();
                
                setTimeout(() => {
                    msg.style.display="none";
                },5000)
            }else if(status == 500){
                var msg = document.getElementById('msgApi');
                msg.style.display="block";
                msg.innerHTML = "Error interno";
                gotoTop();
                
                setTimeout(() => {
                    msg.style.display="none";
                },5000)
            }
        }
    }
}

function loadScreen() {
    var popup = document.getElementsByClassName("popupLoad")[0];
    
    var style = document.createElement('style');
    document.head.appendChild(style);
    style.sheet.insertRule(`.popupLoad {position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: ${window.screen.height <= 635 ? "auto" : '100%'};
        background-color: rgba(0,0,0,0.5); display:flex; align-items: center;
        ${window.screen.height <= 635 ? 'padding: 10px 0px;' : null}}`);
    
    document.body.style.overflow = window.screen.height <= 635 ? "scroll" : "hidden";
        
    popup.innerHTML = `
    <div class="loaded">
        
        <div class="loaderWrapper">
        <p class="loadLabel">Espere unos segundos...</p>
            <div class="loader"></div>
        </div>
    </div>`;
}

function closeLoad() {
    var popup = document.getElementsByClassName("popupLoad")[0];
    var style = document.createElement('style');
    document.head.appendChild(style);
    
    style.sheet.insertRule(`.popupLoad {display: none}`);
    document.body.style.overflow = "auto";
}

function getNameLike(e){
    var located = new URLSearchParams(location.search);
    if(e.target.value.length >= 3 ){
        
        var paramsList = {
            filter: e.target.value,
            region: '',
            schoolid: '',
            level: '',
            offset: 0,
            numofrecords: 10,
            order: 'pupils.id ASC',
            sessionid: located.get('ssid'),
        };
        console.log(paramsList);
        loadScreen();
        callWS("GET", "pupils/list", paramsList, respxList);
    
        console.log(paramsList);
        function respxList(status, respText){
            console.log(status);
            console.log(JSON.parse(respText));
            if (status == 200){
                var json = JSON.parse(respText);
                putNames(json);
            }
        }
    }else{
        document.getElementsByClassName('dataResult')[0].innerHTML = "";
    }
}

function putNames(nameVal){
    console.log(nameVal.records);
    let list = document.getElementsByClassName('dataResult')[0];
    list.innerHTML = "";
    
    for(let i = 0; i < nameVal.records.length; i++){
        nameSurname = `${nameVal.records[i].pupil.name} ${nameVal.records[i].pupil.surname}`;
        if(nameVal.records[i].pupil.code !== null){
            list.innerHTML+=`<p onclick="buildParam('${nameVal.records[i].pupil.code}')">${nameVal.records[i].pupil.code}-${nameVal.records[i].pupil.name} ${nameVal.records[i].pupil.surname}</p>`;
        }
    }
    
    if(nameVal.numofrecords > 10){
        list.innerHTML += `<p class="lastResult">Especifique para mejorar la busqueda</p>`
    }
    closeLoad();
}

function buildParam(code){
    var located = new URLSearchParams(location.search);
    document.getElementsByClassName('dataResult')[0].innerHTML = "";
    clearInput()
    var params = {
        code: code,
        sessionid: located.get('ssid'),
    };
    
    getPupilInfo(params);
}

function getPupilInfo(params){
    loadScreen();
    callWS("GET", "pupils/entry", params, respx);
    
    console.log(params);
    function respx(status, respText){
        console.log(status);
        closeLoad();
        if (status == 200){
            console.log(JSON.parse(respText));
            putPupilsData(JSON.parse(respText));
        }else if(status == 404){
            alert('No se encontro registro');
        }
    }
}