var located = new URLSearchParams(location.search);
var qtyForPage = 10;
var like = located.get('like') === 'null' || located.get('like') === null ? '' : located.get('like');
var order = located.get('order') === 'null' || located.get('order') === null ? '' : located.get('order');
var page = located.get("page") === null ? 1 : parseInt(located.get("page"));
var numPages;
var status = located.get('status') === 'null' || located.get('status') === null  ? '' : located.get('status');
var type = located.get('type') === 'null' || located.get('type') === null  ? '' : located.get('type');
var region = located.get('region') === 'null' || located.get('region') === null  ? '' : located.get('region');
var numOfRecords = 0;

window.onload = function carga() {
    var located = new URLSearchParams(location.search);
    
    let currentLocation = document.getElementsByClassName('registerColleges') [0];
    currentLocation.setAttribute("id","locationUrl");
    document.getElementsByClassName('userName')[0].innerHTML = located.get('n');
    
    document.getElementsByClassName('searching')[0].value = like === 0 ? "" : like;
    
    var paramsListSchools = {
        filter: like,
        region: region,
        offset: (page - 1) * qtyForPage,
        sessionid: located.get('ssid'),
        type: type,
        status: status,
        numofrecords: qtyForPage,
        order: order,
    };
    
    callListOfSchool(paramsListSchools);
    
    let paramListPupil = {
        sessionid: located.get('ssid'),
        offset: 0,
    }
    
    callRegion(paramListPupil);
}

function callListOfSchool(paramsList){
    
    callWS("GET", "schools/list", paramsList, respxList);
    
    console.log(paramsList);
    function respxList(status, respText){
        console.log(status);
        console.log(JSON.parse(respText));
        var json = JSON.parse(respText);
        if (status == 200){
            numPages = Math.ceil(json.numofrecords/10);
            numOfRecords = json.numofrecords;
            putValues(json);
        }else if(status == 403){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "No posee privilegios";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }else if(status == 500){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "Error interno";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }
    } 
}

function putValues(json){
    if(json.numofrecords == 0){
        alert("No existen registros");
        document.getElementById('totalItems').innerHTML = `Total Colegios: ${format(json.numofrecords.toString())}`;
    }else{
        document.getElementById('totalBox').style.display = 'block';
        document.getElementById('totalItems').innerHTML = `Total Colegios: ${format(json.numofrecords.toString())}`;
        for(let i = 0; i < json.records.length; i++){
            if(json.records[i].name !== null ){
                document.getElementsByClassName('collegeTable')[0].insertRow(-1).innerHTML = `
                <td>${json.records[i].code}</td>
                <td>${json.records[i].name}</td>
                <td>${json.records[i].region.name}</td>
                <td>${json.records[i].type.dsc}</td>
                <td>${json.records[i].contact === null ? '' : json.records[i].contact}</td>
                <td>${json.records[i].phone === null ? "" : json.records[i].phone}</td>
                <td>${json.records[i].status.dsc}</td>
                <td class="idCollege">${json.records[i].id}</td>`;
                addEvent();
            }
        }
        makeNumbers();
    }
}

function addEvent() {
    var located = new URLSearchParams(location.search);
    var table = document.getElementsByClassName("collegeTable")[0];
    var rows = document.getElementsByTagName("tr");
    for (i = 0; i < rows.length; i++) {
    var actRow = table.rows[i];
    var createClickHandler = function(row) {
      return function() {
        var cell = row.getElementsByClassName("idCollege")[0];
        console.log(cell);
        let params = {
            ssid: located.get('ssid'),
            n: located.get('n'),
            college: cell === undefined ? null : cell.innerHTML,
        }
        cell === undefined ? null : gotoPage('home','collegeInfo',params);
      };
    };
    actRow.onclick = createClickHandler(actRow);
  }
}


const makeNumbers = () => {
    var container = document.getElementsByClassName('listPages')[0];
    var linkers = "";
    let interations = numPages > 10 ? 10 : numPages;
    for(let i = 0; i < interations; i++){
        
        if(numPages == 1){
            linkers += `<li><a href='javascript:paginationNavigate(${i+1})' class="pagination" id="${i+1}">${i+1}</a></li>`;
        }else if(page+i <= numPages){
            if(i === 0){
            
                linkers +=`<li><a href='javascript:paginationNavigate(${1})' class="pagination"><<</a></div>`;
                linkers +=`<li><a href='javascript:paginationNavigate(${page === 1 ? 1 : page-1})' class="pagination"><</a></li>`;
                linkers += page === 1 ? '' : `<li><a href='javascript:paginationNavigate(${page-1})' class="pagination" id="${page-1}">${page-1}</a></li>`;
                linkers += `<li><a href='javascript:paginationNavigate(${page})' class="pagination" id="${page}">${page}</a></li>`;
            
            }else if(i == interations-1){
            
                linkers += `<li><a href='javascript:paginationNavigate(${page+i})' class="pagination" id="${page+i}">${page+i}</a></li>`;
            
                linkers +=`<li><a href='javascript:paginationNavigate(${page === numPages ? numPages : page + 1})' class="pagination">></a></li>`;
            
                linkers +=`<li><a href='javascript:paginationNavigate(${numPages})' class="pagination">>></a></li>`;
            }else{
            
                linkers += `<li><a href='javascript:paginationNavigate(${page+i})' class="pagination" id="${page+i}">${page+i}</a></li>`;
            
            }
        }
        
    }
    container.innerHTML = linkers;
    document.getElementById(`${page}`).style.color = '#F68E1E';
}

function navigateNew(){
    var located = new URLSearchParams(location.search);
    
    var params ={
        ssid: located.get('ssid'),
        n: located.get('n'),
        college: 0,
    };
    
    gotoPage('home', 'collegeInfo', params);
}

function changeOrder(event){
    var located = new URLSearchParams(location.search);
    
    var paramsList = {
        filter: like,
        region: region,
        offset: (page - 1) * qtyForPage,
        sessionid: located.get('ssid'),
        type: type,
        status: status,
        numofrecords: qtyForPage,
        order: order,
    };
    
    var arrowsUp = document.getElementsByClassName('up');
    var arrowsDown = document.getElementsByClassName('down');
    
    for(let i = 0; i< arrowsUp.length; i++){
        arrowsDown[i].setAttribute('onclick','changeOrder(this)');
        arrowsUp[i].setAttribute('onclick','changeOrder(this)');
        
        arrowsDown[i].style.borderColor = "#FFF";
        arrowsUp[i].style.borderColor = "#FFF";
        arrowsDown[i].style.cursor = "pointer";
        arrowsUp[i].style.cursor = "pointer";
    }
    
    var arrow = document.getElementById(event.id);
    arrow.setAttribute('onclick','');
    arrow.style.cursor = "auto";
    arrow.style.borderColor = "#BBB";
    
    switch(event.id){
        case "codeUp":
            order = "code ASC";
            break;
        case "codeDown":
            order = "code DESC";
            break;
        case "collegeUp":
            order = "name ASC";
            break;
        case "collegeDown":
            order = "name DESC";
            break;
        case "regionUp":
            order = "region ASC";
            break;
        case "regionDown":
            order = "region DESC";
            break;
        case "kindUp":
            order = "private ASC";
            break;
        case "kindDown":
            order = "private DESC";
            break;
        case "contactUp":
            order = "contact ASC";
            break;
        case "contactDown":
            order = "contact DESC";
            break;
        case "cellUp":
            order = "phone ASC";
            break;
        case "cellDown":
            order = "phone DESC";
            break;
        case "stateUp":
            order = "estimatedpupilsedit ASC";
            break;
        case "stateDown":
            order = "estimatedpupilsedit DESC";
            break;
    }
    
    paramsList.order = order;
    
    var table = document.getElementsByClassName("collegeTable")[0].rows;
    var rowCount = table.length;
    
    for(let i = rowCount - 1; i > 0; i--){
        table[i].closest('tr').remove();
    }
    callListOfSchool(paramsList);
}

function paginationNavigate(page){
    let located = new URLSearchParams(location.search);
    var params = {
        ssid: located.get('ssid'),
        n: located.get('n'),
        page: page,
    }
    
    if(order !== ""){
        params.order = order;
    }
    
    if(like !== ""){
        params.like = like;   
    }
    
    if(region !== ""){
        params.region = region;
    }
    
    if(status !== ""){
        params.status = status;
    }
    
    if(type !== "2"){
        params.type = type;
    }
    
    gotoPage('home','searchCollege',params);
}

function callRegion(paramsList){
    
    callWS("GET", "regions/list", paramsList, respxList);
    
    function respxList(status, respText){
        if (status == 200){
            let json = JSON.parse(respText);
            putRegions(json.records);
        }
    }
}

function putRegions(records){
    let select = document.getElementsByClassName("region")[0];
    for(let i = 0; i< records.length; i++){
        let option = document.createElement("option");
        option.text = records[i].region;
        option.value = records[i].region;
        select.add(option);
    }
}

function searchingSchool(e){
    if(e.keyCode == 13){
        var located = new URLSearchParams(location.search);
        
        like = e.target.value === "" ? '' : `${e.target.value}`;
        page = 1;
        
        var paramsList = {
            filter: like,
            region: region,
            offset: (page - 1) * qtyForPage,
            sessionid: located.get('ssid'),
            type: type,
            status: status,
            numofrecords: qtyForPage,
            order: order,
        };
        
        var table = document.getElementsByClassName("collegeTable")[0].rows;
        var rowCount = table.length;
    
        for(let i = rowCount - 1; i > 0; i--){
            table[i].closest('tr').remove();
        }
    
        callListOfSchool(paramsList);
    }
}

function searchFilter(e) {
    let located = new URLSearchParams(location.search);

    if(e.target.className === "region"){
        region = e.target.value;
    }
    
    if(e.target.className === "state"){
        status = e.target.value;
    }
    
    if(e.target.className === "kind"){
        type = e.target.value;
    }
    
    
    page = 1;
        
    var paramsList = {
        filter: like,
        region: region,
        offset: (page - 1) * qtyForPage,
        sessionid: located.get('ssid'),
        type: type,
        status: status,
        numofrecords: qtyForPage,
        order: order,
    };
    
    var table = document.getElementsByClassName("collegeTable")[0].rows;
    var rowCount = table.length;
    for(let i = rowCount - 1; i > 0; i--){
         table[i].closest('tr').remove();
    }
        
    callListOfSchool(paramsList);
}

function exportTableToExcel(){
    let paramsList = {
        filter: like,
        region: region,
        offset: 0,
        sessionid: located.get('ssid'),
        type: type,
        status: status,
        numofrecords: parseInt(numOfRecords),
        order: order,
        csv: 1
    };
    console.log(paramsList);
    callWS("GET", "schools/list", paramsList, respxList);

    function respxList(status, respText){
        console.log(status);
        console.log(JSON.parse(respText));
        var json = JSON.parse(respText);
        if (status == 200){
            loadScreen();
            downloadCsv();
        }else if(status == 403){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "No posee privilegios";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }else if(status == 500){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "Error interno";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }
    }
}

function downloadCsv() {
    let linkPhp = document.createElement("a");
    linkPhp.href = globalurl + "/api/schools/exports/school_data.csv";
    linkPhp.download = "schools_data.csv";
    document.body.appendChild(linkPhp);
    linkPhp.click();
    document.body.removeChild(linkPhp);
    closeLoad();
}

function format(input) {
    var num = input.replace(/\./g,'');
    num = num.toString().split('').reverse().join('').replace(/(?=\d*\.?)(\d{3})/g,'$1.');
    num = num.split('').reverse().join('').replace(/^[\.]/,'');
    
    return num;
}