var located = new URLSearchParams(location.search);
var qtyForPage = 10;
var like = located.get('like') === 'null' || located.get('like') === null ? '' : located.get('like');
var order = located.get('order') === 'null' || located.get('order') === null ? 'pupils.id ASC' : located.get('order');
var page;
var numPages;
var schoolid = located.get('schoolid') === 'null' || located.get('schoolid') === null  ? '': located.get('schoolid');
var region = located.get('region') === 'null' || located.get('region') === null  ? '' : located.get('region');
var level = located.get('level') === 'null' || located.get('level') === null  ? '' : located.get('level');
var schooltype = located.get('schooltype') === 'null' || located.get('schooltype') === null  ? '' : located.get('schooltype');
var modalidad = located.get('modalidad') === 'null' || located.get('modalidad') === null  ? '' : located.get('modalidad');
var numOfRecords = 0;

var testname = located.get('testname') === 'null' || located.get('testname') === null  ? '' : located.get('testname');

window.onload = function carga() {
    console.log(localStorage.getItem('like'));
    
    like = localStorage.getItem('like') === null ? '' : localStorage.getItem('like');
    order = localStorage.getItem('order') === null ? 'pupils.id ASC' : localStorage.getItem('order');
    schoolid = localStorage.getItem('schoolid') === null ? '' : localStorage.getItem('schoolid');
    region = localStorage.getItem('region') === null ? '' : localStorage.getItem('region');
    level = localStorage.getItem('level') === null ? '' : localStorage.getItem('level');
    testname = localStorage.getItem('testname') === null ? '' : localStorage.getItem('testname');
    schooltype = localStorage.getItem('schooltype') === null ? '' : localStorage.getItem('schooltype');
    modalidad = localStorage.getItem('modalidad') === null ? '' : localStorage.getItem('modalidad');
    
     console.log(localStorage.getItem('like'));
    
    var located = new URLSearchParams(location.search);
    document.getElementsByClassName('userName')[0].innerHTML = located.get('n');
    let currentLocation = document.getElementsByClassName('registerStudents') [0];
    currentLocation.setAttribute("id","locationUrl");
    
    document.getElementsByClassName('searching')[0].value = like === 0 ? "" : like;
    document.getElementsByClassName('grade')[0].value = level;
    document.getElementsByClassName('res')[0].value = testname;
    document.getElementsByClassName('modalidad')[0].value = modalidad;
    
    page = located.get("page") === null ? 1 : parseInt(located.get("page"));
    
    let paramsListSchools = {
        offset: 0,
        filter: '',
        schoolid: schoolid,
        region: region,
        sessionid: located.get('ssid'),
        status: '',
        type: schooltype,
        kindTests: modalidad,
        numofrecords: null,
        order: "id",
    };
    
    callListOfSchoolFirst(paramsListSchools);
}

function callListOfSchoolFirst(paramsList){
    callWS("GET", "schools/list", paramsList, respxList);
    
    console.log(paramsList);
    function respxList(status, respText){
        console.log(status);
        console.log(JSON.parse(respText));
        var json = JSON.parse(respText);
        if (status == 200){
            console.log('ok');
            putSchools(json.records);
            
            var paramsList = {
                filter: like,
                region: region,
                schoolid: schoolid,
                level: level,
                schooltype: schooltype,
                offset: (page - 1) * qtyForPage,
                numofrecords: qtyForPage,
                kindTests: modalidad,
                order: order,
                sessionid: located.get('ssid'),
                test: testname,
            };
            
            callListOfPupilsFirst(paramsList);
        }else if(status == 403){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "No posee privilegios";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }else if(status == 500){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "Error interno";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }
    }
}

function callRegionFirst(paramsList){
    
    callWS("GET", "regions/list", paramsList, respxList);
    
    function respxList(status, respText){
        if (status == 200){
            let json = JSON.parse(respText);
            putRegions(json.records);
        }else if(status == 403){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "No posee privilegios";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }else if(status == 500){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "Error interno";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }
    }
}

function callListOfPupilsFirst(paramsList){
    
    callWS("GET", "pupils/list", paramsList, respxList);
    
    console.log(paramsList);
    function respxList(status, respText){
        console.log(status);
        console.log(JSON.parse(respText));
        var json = JSON.parse(respText);
        if (status == 200){
            console.log('ok');
            numPages = Math.ceil(json.numofrecords/10);
            putValues(json);
            numOfRecords = json.numofrecords;
        }else if(status == 403){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "No posee privilegios";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }else if(status == 500){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "Error interno";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }
        
        let paramListPupil = {
            sessionid: located.get('ssid'),
            offset: 0,
        }
    
        callRegionFirst(paramListPupil);
    }
}

function callRegion(paramsList){
    
    callWS("GET", "regions/list", paramsList, respxList);
    
    function respxList(status, respText){
        if (status == 200){
            let json = JSON.parse(respText);
            putRegions(json.records);
        }else if(status == 403){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "No posee privilegios";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }else if(status == 500){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "Error interno";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }
    }
}

function callListOfPupils(paramsList){
    
    callWS("GET", "pupils/list", paramsList, respxList);
    
    console.log(paramsList);
    function respxList(status, respText){
        console.log(status);
        console.log(JSON.parse(respText));
        var json = JSON.parse(respText);
        if (status == 200){
            console.log('ok');
            numPages = Math.ceil(json.numofrecords/10);
            putValues(json);
            numOfRecords = json.numofrecords;
        }else if(status == 403){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "No posee privilegios";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }else if(status == 500){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "Error interno";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }
    }
}

function navigateNew(){
    var located = new URLSearchParams(location.search);
    
    var params ={
        ssid: located.get('ssid'),
        n: located.get('n'),
        code: 0,
    };
    
    gotoPage('home', 'studentInfo', params);
}

function changeOrder(event){
    var located = new URLSearchParams(location.search);
    
    var paramsList = {
        filter: like,
        region: region,
        schoolid: schoolid,
        schooltype: schooltype,
        level: level,
        offset: (page - 1) * qtyForPage,
        numofrecords: qtyForPage,
        order: order,
        kindTests: modalidad,
        sessionid: located.get('ssid'),
        test: testname,
    };
    
    var arrowsUp = document.getElementsByClassName('up');
    var arrowsDown = document.getElementsByClassName('down');
    
    for(let i = 0; i< arrowsUp.length; i++){
        arrowsDown[i].setAttribute('onclick','changeOrder(this)');
        arrowsUp[i].setAttribute('onclick','changeOrder(this)');
        
        arrowsDown[i].style.borderColor = "#FFF";
        arrowsUp[i].style.borderColor = "#FFF";
        arrowsDown[i].style.cursor = "pointer";
        arrowsUp[i].style.cursor = "pointer";
    }
    
    var arrow = document.getElementById(event.id);
    arrow.setAttribute('onclick','');
    arrow.style.cursor = "auto";
    arrow.style.borderColor = "#BBB";
    
    switch(event.id){
        case "codeUp":
            order = "pupils.id ASC";
            break;
        case "codeDown":
            order = "pupils.id DESC";
            break;
        case "ciUp":
            order = "pupils.ci ASC";
            break;
        case "ciDown":
            order = "pupils.ci DESC";
            break;
        case "nameUp":
            order = "pupils.name ASC, pupils.surname ASC";
            break;
        case "nameDown":
            order = "pupils.name DESC, pupils.surname DESC";
            break;
        case "kindUp":
            order = "pupils.gender ASC";
            break;
        case "kindDown":
            order = "pupils.gender DESC";
            break;
        case "gradeUp":
            order = "pupils.level ASC, pupils.section ASC";
            break;
        case "gradeDown":
            order = "pupils.level DESC, pupils.section DESC";
            break;
        case "collegeUp":
            order = "schools.name ASC";
            break;
        case "collegeDown":
            order = "schools.name DESC";
            break;
        case "regionUp":
            order = "schools.region ASC";
            break;
        case "regionDown":
            order = "schools.region DESC";
            break;
    }
    
    paramsList.order = order;
    
    localStorage.setItem('order',order);
    
    var table = document.getElementsByClassName("studentTable")[0].rows;
    var rowCount = table.length;
    
    for(let i = rowCount - 1; i > 0; i--){
        table[i].closest('tr').remove();
    }
    callListOfPupils(paramsList);
}

function putValues(json){
    if(json.numofrecords == 0){
        alert("No existen registros");
        document.getElementById('totalItems').innerHTML = `Total Alumnos: ${format(json.numofrecords.toString())}`;
    }else{
        document.getElementById('totalBox').style.display = 'block';
        document.getElementById('totalItems').innerHTML = `Total Alumnos: ${format(json.numofrecords.toString())}`;
        for(let i = 0; i < json.records.length; i++){
            if(json.records[i].pupil.name !== null ){
                document.getElementsByClassName('studentTable')[0].insertRow(-1).innerHTML = `
                <td class="codeStudent">${json.records[i].pupil.code}</td>
                <td>${json.records[i].pupil.ci}</td>
                <td class="largeTxt">${json.records[i].pupil.name + " " + json.records[i].pupil.surname}</td>
                <td>${json.records[i].pupil.gender.dsc}</td>
                <td>${json.records[i].pupil.level}${abrev(json.records[i].pupil.level)} ${json.records[i].pupil.section}</td>
                <td class="largeTxt">${json.records[i].school.name}</td>
                <td>${json.records[i].school.region}</td>
                <td>${determinateScore(json.records[i].results)}</td>`;
                addEvent();
            }
        }
    }
    
    makeNumbers();
}

function determinateScore(json) {
    if (testname == 'nacional' && json.nacional != undefined) {
        return json.nacional;
    } else if (testname == 'regional' && json.regional != undefined) {
        return json.regional;
    } else if(testname == 'prueba preliminar' && json.correct != undefined) {
        return json.correct;
    } else if (testname == '0' || testname == '') {
        if(json.nacional != undefined){
            return json.nacional;
        } else if (json.regional != undefined) {
            return json.regional;
        } else {
            return json.correct;
        }
    }
    
    
    return 0;
}

function addEvent() {
    var located = new URLSearchParams(location.search);
    var table = document.getElementsByClassName("studentTable")[0];
    var rows = document.getElementsByTagName("tr");
    for (i = 0; i < rows.length; i++) {
    var actRow = table.rows[i];
    var createClickHandler = function(row) {
      return function() {
        var cell = row.getElementsByClassName("codeStudent")[0];
        if(cell != undefined){
            let params = {
                ssid: located.get('ssid'),
                n: located.get('n'),
                code: cell.innerHTML,
            }
            gotoPage('home','studentInfo',params);    
        }
      };
    };
    actRow.onclick = createClickHandler(actRow);
  }
}

const abrev = level => {
    return level == "3" || level == "1" ? "ro" : (level == "2" ? "do" : "to");
}

const makeNumbers = () => {
    var container = document.getElementsByClassName('listPages')[0];
    var linkers = "";
    let interations = numPages > 10 ? 10 : numPages;
    for(let i = 0; i < interations; i++){
        
        if(numPages == 1){
            linkers += `<li><a href='javascript:paginationNavigate(${i+1})' class="pagination" id="${i+1}">${i+1}</a></li>`;
        }else if(page+i <= numPages){
            if(i === 0){
            
                linkers +=`<li><a href='javascript:paginationNavigate(${1})' class="pagination"><<</a></div>`;
                linkers +=`<li><a href='javascript:paginationNavigate(${page === 1 ? 1 : page-1})' class="pagination"><</a></li>`;
                linkers += page === 1 ? '' : `<li><a href='javascript:paginationNavigate(${page-1})' class="pagination" id="${page-1}">${page-1}</a></li>`;
                linkers += `<li><a href='javascript:paginationNavigate(${page})' class="pagination" id="${page}">${page}</a></li>`;
            
            }else if(i == interations-1){
            
                linkers += `<li><a href='javascript:paginationNavigate(${page+i})' class="pagination" id="${page+i}">${page+i}</a></li>`;
            
                linkers +=`<li><a href='javascript:paginationNavigate(${page === numPages ? numPages : page + 1})' class="pagination">></a></li>`;
            
                linkers +=`<li><a href='javascript:paginationNavigate(${numPages})' class="pagination">>></a></li>`;
            }else{
            
                linkers += `<li><a href='javascript:paginationNavigate(${page+i})' class="pagination" id="${page+i}">${page+i}</a></li>`;
            
            }
        }
        
    }
    container.innerHTML = linkers;
    document.getElementById(`${page}`) != undefined ? document.getElementById(`${page}`).style.color = '#F68E1E' : null;
}

function paginationNavigate(page){
    let located = new URLSearchParams(location.search);
    var params = {
        ssid: located.get('ssid'),
        n: located.get('n'),
        page: page,
    }
    
    if(order != ""){
        localStorage.setItem('order',order);
        params.order = order;
    }
    
    if(like != ""){
        localStorage.setItem('like',like);
        params.like = like;   
    }
    
    if(region != ""){
        localStorage.setItem('region',region);
        params.region = region;
    }
    
    if(schoolid != ""){
        localStorage.setItem('schoolid',schoolid);
        params.schoolid = schoolid;
    }
    
    if(level != ""){
        localStorage.setItem('level',level);
        params.level = level;
    }
    
    if(testname != ""){
        localStorage.setItem('testname',testname);
        params.testname = testname;
    }
    
    if(modalidad != ""){
        localStorage.setItem('modalidad',modalidad);
        params.modalidad = modalidad;
    }
    
    if(schooltype != ""){
        localStorage.setItem("schooltype",schooltype);
        params.schooltype = schooltype;
    }
    
    gotoPage('home','searchStudent',params);
}

function callListOfSchool(paramsList){
    callWS("GET", "schools/list", paramsList, respxList);
    
    console.log(paramsList);
    function respxList(status, respText){
        console.log(status);
        console.log(JSON.parse(respText));
        var json = JSON.parse(respText);
        if (status == 200){
            console.log('ok');
            putSchools(json.records);
        }else if(status == 403){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "No posee privilegios";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }else if(status == 500){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "Error interno";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }
    }
}

function searchingPupil(e){
    if(e.keyCode == 13){
        var located = new URLSearchParams(location.search);
        
        like = e.target.value === "" ? '' : `${e.target.value}`;
        page = 1;
        
        var paramsList = {
            filter: like,
            region: region,
            schoolid: schoolid,
            schooltype: schooltype,
            level: level,
            offset: (page - 1) * qtyForPage,
            numofrecords: qtyForPage,
            order: order,
            kindTests: modalidad,
            sessionid: located.get('ssid'),
            test: testname,
        };
        
        localStorage.setItem('like',like);
        
        var table = document.getElementsByClassName("studentTable")[0].rows;
        var rowCount = table.length;
    
        for(let i = rowCount - 1; i > 0; i--){
            table[i].closest('tr').remove();
        }
    
        callListOfPupils(paramsList);
    }
}

function searchFilter(e) {
    let located = new URLSearchParams(location.search);

    if(e.target.className === "region"){
        region = e.target.value;
        localStorage.setItem('region',region);
        localStorage.removeItem('schoolid');
        
        document.getElementById("inputSchools").value = "";
        
        schoolid='';
        let paramsSchool = {
            region: region,
            schoolid: schoolid,
            offset: 0,
            type: schooltype,
            sessionid: located.get('ssid'),
            status: '',
            numofrecords: null,
            order: "id",
        }
        
        callListOfSchool(paramsSchool);
        
    }
    
    if(e.target.className === "kind"){
        schooltype = e.target.value;
        localStorage.setItem('schooltype',schooltype);
        localStorage.removeItem('schoolid');
        
        document.getElementById("inputSchools").value = "";
        
        schoolid='';
        let paramsSchool = {
            region: region,
            schoolid: schoolid,
            offset: 0,
            type: schooltype,
            sessionid: located.get('ssid'),
            status: '',
            numofrecords: null,
            order: "id",
        }
        
        callListOfSchool(paramsSchool);
        
    }
    
    if(e.target.className === "grade"){
        level = e.target.value;
        localStorage.setItem('level',level);
    }
    
    if(e.target.className === "schools" && e.target.value != ""){
        let getId = e.target.value.split("-");
        console.log(getId.length);
        if(getId.length < 2){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "Debe seleccionar un colegio";
            setTimeout(() => {
                msg.style.display="none";
            },5000);
            return 0;
        }
        schoolid = getId[0];
        localStorage.setItem('schoolid',schoolid);
    }else if(e.target.className === "schools" && e.target.value == ""){
        schoolid='';   
        localStorage.setItem('schoolid',schoolid);
    }
    
    if(e.target.className === "res"){
        testname = e.target.value;
        localStorage.setItem('testname',testname);
    }
    
    if(e.target.className === "modalidad"){
        modalidad = e.target.value;
        localStorage.setItem('modalidad',testname);
    }
    
    page = 1;
        
    var paramsList = {
        filter: like,
        region: region,
        schoolid: schoolid,
        level: level,
        offset: (page - 1) * qtyForPage,
        numofrecords: qtyForPage,
        order: order,
        schooltype: schooltype,
        kindTests: modalidad,
        sessionid: located.get('ssid'),
        test: testname,
    };
    
    var table = document.getElementsByClassName("studentTable")[0].rows;
    var rowCount = table.length;
    for(let i = rowCount - 1; i > 0; i--){
         table[i].closest('tr').remove();
    }
        
    callListOfPupils(paramsList);
}

function exportTableToExcel(){
    let paramsList = {
        filter: like,
        region: region,
        schoolid: schoolid,
        level: level,
        test: testname,
        schooltype: schooltype,
        offset: 0,
        numofrecords: parseInt(numOfRecords),
        order: `pupils.id ASC`,
        sessionid: located.get('ssid'),
        kindTests: modalidad,
        csv: 1
    };
    
    callWS("GET", "pupils/list", paramsList, respxList);

    function respxList(status, respText){
        console.log(status);
        console.log(JSON.parse(respText));
        var json = JSON.parse(respText);
        if (status == 200){
            loadScreen();
            downloadCsv();
        }else if(status == 403){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "No posee privilegios";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }else if(status == 500){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "Error interno";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }
    }
}

function downloadCsv() {
    let linkPhp = document.createElement("a");
    linkPhp.href = globalurl + "/api/pupils/schools_data.zip";
    linkPhp.download = "schools_data.zip";
    document.body.appendChild(linkPhp);
    linkPhp.click();
    document.body.removeChild(linkPhp);
    closeLoad();
}

function putRegions(records){
    let select = document.getElementsByClassName("region")[0];
    for(let i = 0; i< records.length; i++){
        let option = document.createElement("option");
        option.text = records[i].region;
        option.value = records[i].region;
        
        if(region == records[i].region){
            option.selected = true;
        }
        select.add(option);
    }
}

function putSchools(records){
    let option = "";
    option += `<option disabled selected>Colegios...</option>`;
    option += `<option value="">TODOS</option>`;
    for(let i = 0; i < records.length; i++){
        option += `<option value="${records[i].id} - ${records[i].name}">${records[i].id} - ${records[i].name}</option>`;
        
        if(parseInt(records[i].id) == parseInt(schoolid)){
            document.getElementById('inputSchools').value = `${records[i].id} - ${records[i].name}`;
        }
    }
    
    document.getElementById("schools").innerHTML = option;
}

function format(input) {
    var num = input.replace(/\./g,'');
    num = num.toString().split('').reverse().join('').replace(/(?=\d*\.?)(\d{3})/g,'$1.');
    num = num.split('').reverse().join('').replace(/^[\.]/,'');
    
    return num;
}