var pupilid;
var schoolid;
window.onload = function carga() {
    var located = new URLSearchParams(location.search);
    
    if(localStorage.getItem('level') != '' && localStorage.getItem('level') != undefined){
        innerInInputs('grade',localStorage.getItem('level'));
    }
    
    let currentLocation = document.getElementsByClassName('registerStudents') [0];
    currentLocation.setAttribute("id","locationUrl");
    document.getElementsByClassName('userName')[0].innerHTML = located.get('n')
        
    var params = {
        code: located.get('code'),
        sessionid: located.get('ssid'),
    };
    
    let paramListRegion = {
        sessionid: located.get('ssid'),
        offset: 0,
    }
    
    callRegion(paramListRegion);
    
    if(parseInt(params.code) !== 0){
        callData(params);
        document.getElementById('inputCollege').setAttribute('id','collegeName');
    }else if(parseInt(params.code) === 0){
        let paramsListSchools = {
            filter: '',
            region: '',
            offset: 0,
            sessionid: located.get('ssid'),
            status: 0,
            numofrecords: null,
            order: "id",
        };
        
        pupilid = 0;
        document.getElementById('inputCollege').classList.toggle('noShow');
        document.getElementById('selectCollege').classList.toggle('noShow');
        
        document.getElementById('selectCollege').setAttribute('id','collegeName');
        callListOfSchool(paramsListSchools);
    }

}

function callRegion(paramsList){
    
    callWS("GET", "regions/list", paramsList, respxList);
    
    function respxList(status, respText){
        if (status == 200){
            let json = JSON.parse(respText);
            putRegions(json.records);
        }else if(status == 403){
            var msg = document.getElementById('error');
            msg.style.display="block";
            msg.innerHTML = "No posee privilegios";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }else if(status == 500){
            var msg = document.getElementById('error');
            msg.style.display="block";
            msg.innerHTML = "Error interno";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }
    }
}

function putRegions(records){
    let select = document.getElementById("state");
    for(let i = 0; i< records.length; i++){
        let option = document.createElement("option");
        option.text = records[i].region;
        option.value = records[i].region;
        if(records[i].region == localStorage.getItem('region')){
            option.selected = true;
        }
        select.add(option);
    }
}

function callData(params){
    callWS("GET", "pupils/entry", params, respx);
    
    console.log(params);
    function respx(status, respText){
        console.log(status);
        if (status == 200){
            console.log(JSON.parse(respText));
            var json = JSON.parse(respText);
            putValues(json.entry);
        }else if(status == 404){
            var msg = document.getElementById('error');
            msg.style.display="block";
            msg.innerHTML = "No se encontr\u00F3 registro";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }else if(status == 403){
            var msg = document.getElementById('error');
            msg.style.display="block";
            msg.innerHTML = "No posee privilegios";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }else if(status == 500){
            var msg = document.getElementById('error');
            msg.style.display="block";
            msg.innerHTML = "Error interno";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }
    }
}

function callListOfSchool(paramsList){
    callWS("GET", "schools/list", paramsList, respxList);
    
    console.log(paramsList);
    function respxList(status, respText){
        console.log(status);
        if (status == 200){
            console.log(JSON.parse(respText));
            var json = JSON.parse(respText);
            if(parseInt(json.numofrecords) === 0){
                var msg = document.getElementById('error');
                msg.style.display="block";
                msg.innerHTML = "No existen colegios";
                setTimeout(() => {
                    msg.style.display="none";
                },5000)
            }else{
                putSchools(json.records);
            }
        }else if(status == 403){
            var msg = document.getElementById('error');
            msg.style.display="block";
            msg.innerHTML = "No posee privilegios";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }else if(status == 500){
            var msg = document.getElementById('error');
            msg.style.display="block";
            msg.innerHTML = "Error interno";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }
    }
}

function putSchools(records){
    let option = "";
    option += `<option value="0" disabled selected>Colegios...</option>`;
    for(let i = 0; i < records.length; i++){
        option += `<option value="${records[i].id}" ${(parseInt(records[i].id) == parseInt(localStorage.getItem('schoolid')) ? 'selected' : '')}>${records[i].id}-${records[i].name}</option>`;
        
        if(parseInt(records[i].id) == parseInt(localStorage.getItem('schoolid'))){
            innerInInputs('state',records[i].region.name);
        }
    }
    
    console.log(localStorage.getItem('schoolid'));
    
    
    document.getElementById("collegeName").innerHTML = option;
}

const innerInInputs = (id,value) => {
    document.getElementById(id).value = value;
}

function putValues(json){
    
    console.log(json);
    
    pupilid = json.pupil.id;
    
    innerInInputs('pupilName',json.pupil.name);
    innerInInputs('surname',json.pupil.surname);
    innerInInputs('birthdate',json.pupil.birthdate.formatted);
    innerInInputs('gender',json.pupil.gender.id);
    innerInInputs('ci',json.pupil.ci);
    innerInInputs('code',json.pupil.code);
    innerInInputs('observations',json.pupil.observation);
    
    innerInInputs('section',json.pupil.section);
    innerInInputs('grade',json.pupil.level);
    innerInInputs('collegeName',json.school.name);
    innerInInputs('state',json.school.region);
    
    if(json.corrections.numofrecords == 0){
        alert("No existen registros");
    }else{
        for(let i = 0; i < json.corrections.length; i++){
            document.getElementsByClassName('testResults')[0].insertRow(-1).innerHTML = `
                <td>${json.corrections[i].datecreated.formatted}</td>
                <td class="testName">${json.corrections[i].test.name}</td>
                <td>${json.corrections[i].test.level}</td>
                <td>${json.corrections[i].score}</td>
            `;
        }
    }
}

function deletePupil(){
    var located = new URLSearchParams(location.search);
    
    let params = {
        pupilid :pupilid,
        sessionid: located.get('ssid'),
    }
    
    callWS("GET", "pupils/delete", params, respx);
    
    console.log(params);
    function respx(status, respText){
        gotoTop();
        console.log(status);
        if(status == 200){
            document.getElementById('confirmation').innerHTML = "Eliminaci\u00F3n de Alumno Exitosa";
            let timerVal = 0;
            var timer = setInterval(function(){
                timerVal++;
               if(timerVal == 2){
                   clearInterval(timer);
                  navigationMenu('searchStudent');
              }
            },1000);
        }else if(status == 304){
            var msg = document.getElementById('error');
            msg.style.display="block";
            msg.innerHTML = 'No se puede borrar debido a que posee examenes';
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        } else if(status == 401) {
            var msg = document.getElementById('error');
            msg.style.display="block";
            msg.innerHTML = "Hash invalido";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }else if(status == 403){
            var msg = document.getElementById('error');
            msg.style.display="block";
            msg.innerHTML = "No posee privilegios";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }else if(status == 500){
            var msg = document.getElementById('error');
            msg.style.display="block";
            msg.innerHTML = "Error interno";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }
    }
}

function updatePupil(){
    var error = document.getElementById('error');
    var valId=/^(([0-9])|(ext|x)){1,10}$/;
    var located = new URLSearchParams(location.search);
    
    var student = {
      name: document.getElementById('pupilName').value,
      surname: document.getElementById('surname').value,
      gender: document.getElementById('gender').value,
      birthDate: document.getElementById('birthdate').value,
      ci: document.getElementById('ci').value,
      grade: document.getElementById('grade').value,
      section: document.getElementById('section').value,
      schoolid: document.getElementById('collegeName').value
    };
    console.log(student);
    let today = new Date();
    let validDate = new Date(student.birthDate);
    
    if( student.name == "" || student.surname == "" || student.gender != "M" && student.gender != "F" || student.birthDate == "" || student.grade == "0" || student.section == "0" || student.schoolid == "0"){
        error.innerHTML = "Campos Vac\u00EDos";
        gotoTop();
    }else if(validDate.getFullYear() > today.getFullYear() || validDate.getFullYear() < 1990){
        error.innerHTML = "Fecha de Nacimiento incorrecta";
        gotoTop();
    }else if(!valId.test(student.ci) && student.ci != "" ){
        error.innerHTML = "Identificaci\u00F3n incorrecta";
        gotoTop();
    }else{
        error.innerHTML = "";
        
        let realParams = {
            id: pupilid,
            schoolid: student.schoolid,
            name: student.name,
            surname: student.surname,
            gender: student.gender,
            birthdate: student.birthDate,
            ci: student.ci == "" ? "0" : student.ci,
            level: student.grade,
            section: student.section,
            sessionid: located.get('ssid'),
            observation: document.getElementById('observations').value
        };
        error.innerHTML = "";
        console.log(realParams);
        callWS("GET", "pupils/update", realParams, respxUpdate);
    }
}

function respxUpdate(status, respText){
    gotoTop();
    if ( status == 200 ){
        console.log(status);
        console.log(JSON.parse(respText));
        document.getElementById('confirmation').innerHTML = "Modificaci\u00F3n de Datos Exitosa";
        let timerVal = 0;
        var timer = setInterval(function(){
            timerVal++;
            if(timerVal == 2){
                clearInterval(timer);
                navigationMenu('searchStudent');
            }
        },1000);
    } else if( status == 401 ) {
        var msg = document.getElementById('error');
        msg.style.display="block";
        msg.innerHTML = "Hash invalido";
        setTimeout(() => {
            msg.style.display="none";
        },5000)
    } else if( status == 203 ){
        var msg = document.getElementById('error');
        msg.style.display="block";
        msg.innerHTML = "No tiene más cupos disponibles";
        setTimeout(() => {
            msg.style.display="none";
        },5000)
    } else if( status == 304 ){
        var msg = document.getElementById('error');
        msg.style.display="block";
        msg.innerHTML = "No se pudo modificar";
        setTimeout(() => {
            msg.style.display="none";
        },5000)
    }else if(status == 204){
        var msg = document.getElementById('error');
        msg.style.display="block";
        msg.innerHTML = "No se encontro registro";
        setTimeout(() => {
            msg.style.display="none";
        },5000)
    }else if(status == 403){
        var msg = document.getElementById('error');
        msg.style.display="block";
        msg.innerHTML = "No posee privilegios";
        setTimeout(() => {
            msg.style.display="none";
        },5000)
    }else if(status == 500){
        var msg = document.getElementById('error');
        msg.style.display="block";
        msg.innerHTML = "Error interno";
        setTimeout(() => {
            msg.style.display="none";
        },5000)
    }
}

function searchFilter(e) {
    let located = new URLSearchParams(location.search);
        
    let paramsSchool = {
        filter: '',
        region: e.target.value,
        offset: 0,
        sessionid: located.get('ssid'),
        type: '',
        status: 0,
        numofrecords: null,
        order: "id",
    }
    callListOfSchool(paramsSchool);
    
}