var schoolsid = [];
var userId="";
window.onload = function carga() {
    let today = new Date();
    let dd = String(today.getDate()).padStart(2, '0');
    let mm = String(today.getMonth() + 1).padStart(2, '0');
    let yyyy = today.getFullYear();
    document.getElementById('chargeDate').value = `${yyyy}-${mm}-${dd}`;
    
    var located = new URLSearchParams(location.search);
    
    let currentLocation = document.getElementsByClassName('registerUsers') [0];
    currentLocation.setAttribute("id","locationUrl");
    document.getElementsByClassName('userName')[0].innerHTML = located.get('n');
    
    var params = {
        sessionid: located.get('ssid'),  
        id: located.get('userId'),
    };
    
    if(parseInt(params.id) !== 0){
        callEntryData(params);
    }else{
        userId=0;
        document.getElementById('delete').style.display = 'none';
        var located = new URLSearchParams(location.search);
        
        let paramsList = {
            offset: 0,
            sessionid: located.get('ssid'),
            status: 0,
            numofrecords: null,
            order: 'id ASC',
            csv: 0,
            all: 1,
        };
        
        callSchools(paramsList);
        
        var params = {
            sessionid: located.get('ssid'),
            offset: 0,
            numofrecords: 1000
        };
        
        callWS('GET','roles/list',params, resp);
        
        function resp(status, rsp){
            let json = JSON.parse(rsp);
            console.log(json.records);
            switch(status){
                case 200:
                    if(json.numofrecords > 0){
                        var select = document.getElementById('role');
                        for(let i = 0; i < json.records.length; i++){
                            var option = document.createElement('option');
                            
                            option.innerHTML = json.records[i].user;
                            option.value = json.records[i].id;
                            
                            select.appendChild(option);
                        }
                    }
                    break;
                case 403:
                    var msg = document.getElementById('error');
                    msg.style.display="block";
                    msg.innerHTML = "No posee privilegios";
                    setTimeout(() => {
                        msg.style.display="none";
                    },5000)
                    break;
                case 500:
                    var msg = document.getElementById('error');
                    msg.style.display="block";
                    msg.innerHTML = "Error interno";
                    setTimeout(() => {
                        msg.style.display="none";
                    },5000)
                    break;
                default:
                    var msg = document.getElementById('error');
                    msg.style.display="block";
                    msg.innerHTML = json.msg;
                    setTimeout(() => {
                        msg.style.display="none";
                    },5000)
            }
        }
    }
}

function callSchools(paramsList){
    console.log(paramsList);
    callWS("GET", "schools/list", paramsList, respxList);

    function respxList(status, respText){
        console.log(status);
        console.log(JSON.parse(respText));
        var json = JSON.parse(respText);
        schoolsid = json.schools.records;
        if (status == 200){
            for(let i = 0; i < json.schools.records.length; i++){
                if(json.schools.records[i].name !== null ){
                document.getElementsByClassName('priviligies')[0].insertRow(-1).innerHTML = `
                <td>${json.schools.records[i].code}</td>
                <td>${json.schools.records[i].name}</td>
                <td>${json.schools.records[i].region}</td>
                <td><input type="radio" value="${json.schools.records[i].id}" class="defaultSchool" name="defaultSchool" ${json.schools.records[i].access == "DEFAULT" ? "checked" : ""}></td>
                <td>
                    <div class="resetBox privateSchools resetPadding">
                        <label class="switch marginCenter">
                            <input type="checkbox" class="asignSchool" value="${json.schools.records[i].id}" ${json.schools.records[i].access == "SI" ? "checked" : ""}>
                            <span class="slider round"></span>
                        </label>
                    </div>
                </td>`;
                }
            }
        }
    }
}

function callEntryData(params){
    callWS("GET", "users/entry", params, respx);
    
    console.log(params);
    function respx(status, respText){
        var userdata = JSON.parse(respText);
        console.log(status);
        if (status == 200){
            console.log(JSON.parse(respText));
            putValues(JSON.parse(respText));
            var located = new URLSearchParams(location.search);
            
            var params = {
                sessionid: located.get('ssid'),
                offset: 0,
                numofrecords: 1000
            };
            
            callWS('GET','roles/list',params, resp);
            
            function resp(status, rsp){
                let json = JSON.parse(rsp);
                console.log(json.records);
                switch(status){
                    case 200:
                        if(json.numofrecords > 0){
                            var select = document.getElementById('role');
                            for(let i = 0; i < json.records.length; i++){
                                var option = document.createElement('option');
                                    
                                option.innerHTML = json.records[i].user;
                                option.value = json.records[i].id;
                                
                                if(userdata.rol != null){
                                    option.selected = json.records[i].id == userdata.rol.id ? true : false;
                                }
                                    
                                select.appendChild(option);
                            }
                        }
                        break;
                    case 403:
                        var msg = document.getElementById('error');
                        msg.style.display="block";
                        msg.innerHTML = "No posee privilegios";
                        setTimeout(() => {
                            msg.style.display="none";
                        },5000)
                        break;
                    case 500:
                        var msg = document.getElementById('error');
                        msg.style.display="block";
                        msg.innerHTML = "Error interno";
                        setTimeout(() => {
                            msg.style.display="none";
                        },5000)
                        break;
                    default:
                        var msg = document.getElementById('error');
                        msg.style.display="block";
                        msg.innerHTML = json.msg;
                        setTimeout(() => {
                            msg.style.display="none";
                        },5000)
                }
            }
        
        }else if(status == 404){
            var msg = document.getElementById('error');
            msg.style.display="block";
            msg.innerHTML = "No se encontr\u00F3 registro";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }
    }
}

function putValues(json){
    userId = json.id;
    document.getElementById('name').value = json.name;
    document.getElementById('email').value = json.email;
    document.getElementById('status').value = json.status.id;
    schoolsid = json.schools.records;
    console.log(json.schools.records.length);
    for(let i = 0; i < json.schools.records.length; i++){
        if(json.schools.records[i].name !== null ){
            document.getElementsByClassName('priviligies')[0].insertRow(-1).innerHTML = `
            <td>${json.schools.records[i].code}</td>
            <td>${json.schools.records[i].name}</td>
            <td>${json.schools.records[i].region}</td>
            <td><input type="radio" value="${json.schools.records[i].id}" class="defaultSchool" name="defaultSchool" ${json.schools.records[i].access == "DEFAULT" ? "checked" : ""}></td>
            <td>
                <div class="resetBox privateSchools resetPadding">
                    <label class="switch marginCenter">
                        <input type="checkbox" class="asignSchool" value="${json.schools.records[i].id}" 
                        ${json.schools.records[i].access == "SI" || json.schools.records[i].access == "DEFAULT" ? "checked" : ""}>
                        <span class="slider round"></span>
                    </label>
                </div>
            </td>`;
        }
    }
    
}

function deleteUser(){
    var located = new URLSearchParams(location.search);
    
    let params = {
        sessionid: located.get('ssid'),  
        id: located.get('userId'),
    }
    
    callWS("GET", "users/delete", params, respx);
    
    console.log(params);
    function respx(status, respText){
        gotoTop();
        if ( status == 200 ){
            document.getElementById('confirmation').innerHTML = "Eliminaci\u00F3n de Usuario Exitosa";
            let timerVal = 0;
            var timer = setInterval(function(){
                timerVal++;
                if(timerVal == 2){
                    clearInterval(timer);
                    navigationMenu('searchUser');
                }
            },1000);
        } else if ( status == 401 ) {
            var msg = document.getElementById('error');
            msg.style.display="block";
            msg.innerHTML = "Hash invalido";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        } else if( status == 304 ){
             var msg = document.getElementById('error');
            msg.style.display="block";
            msg.innerHTML = "El Colegio posee Alumnos/Pagos registrados";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }else if(status == 403){
            var msg = document.getElementById('error');
            msg.style.display="block";
            msg.innerHTML = "No posee privilegios";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }else if(status == 500){
            var msg = document.getElementById('error');
            msg.style.display="block";
            msg.innerHTML = "Error interno";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }
    }
    
}

function saveUser(){
    document.getElementById('confirmation').innerHTML = "";
    document.getElementById('error').innerHTML = "";
    var located = new URLSearchParams(location.search);
    let radioGroup = document.getElementsByClassName('defaultSchool');
    let assignedGroup = document.getElementsByClassName('asignSchool');
    let defaultSchoolId = "";
    let schoolAssigned = "";
    
    for(let i = 0;i < radioGroup.length; i++){
        if(radioGroup[i].checked){
            defaultSchoolId = radioGroup[i].value;
        }
    }
    
    for(let i = 0; i < assignedGroup.length; i++){
        if(assignedGroup[i].checked){
            if(schoolAssigned.length === 0){
                schoolAssigned += `${assignedGroup[i].value}`;
            }else{
                schoolAssigned += `-${assignedGroup[i].value}`;
            }
        }
    }
    
    let params = {
        id: userId,
        usr: document.getElementById('name').value,
        name: document.getElementById('name').value,
        email: document.getElementById('email').value,
        rolid: document.getElementById('role').value,
        schoolid: defaultSchoolId,
        schools: schoolAssigned,
        status: document.getElementById('status').value,
        sessionid: located.get('ssid'),
    };
    
    if(params.usr === "" || params.name === ""){
        document.getElementById('error').innerHTML = "Nombre vac&iacute;o";
    }else if(params.email === ""){
        document.getElementById('error').innerHTML = "Email vac&iacute;o";
    }else if(params.schoolid === ""){
        document.getElementById('error').innerHTML = "Debe tener un colegio predeterminado";
    }else if(params.rolid === ""){
        document.getElementById('error').innerHTML = "Debe asignar un rol";
    }
    console.log(params);
    callWS("GET", "users/update", params, respxUpdate);
}

function respxUpdate(status, respText){
    gotoTop();
    console.log(status);
    console.log(JSON.parse(respText));
    if ( status == 200 ){
        console.log(status);
        console.log(JSON.parse(respText));
        document.getElementById('confirmation').innerHTML = "Modificaci\u00F3n de Datos Exitosa";
        let timerVal = 0;
        var timer = setInterval(function(){
            timerVal++;
            if(timerVal == 2){
                clearInterval(timer);
                navigationMenu('searchUser');
            }
        },1000);
    } else if ( status == 401 ) {
        var msg = document.getElementById('error');
        msg.style.display="block";
        msg.innerHTML = "Hash invalido";
        setTimeout(() => {
            msg.style.display="none";
        },5000)
    } else if( status == 409 ){
        var msg = document.getElementById('error');
        msg.style.display="block";
        msg.innerHTML = "Correo Duplicado";
        setTimeout(() => {
            msg.style.display="none";
        },5000)
    }else if(status == 403){
        var msg = document.getElementById('error');
        msg.style.display="block";
        msg.innerHTML = "No posee privilegios";
        setTimeout(() => {
            msg.style.display="none";
        },5000)
    }else if(status == 500){
        var msg = document.getElementById('error');
        msg.style.display="block";
        msg.innerHTML = "Error interno";
        setTimeout(() => {
            msg.style.display="none";
        },5000)
    }
}
function allSelect(e){
    if(e.target.checked){
        let checkAssign = document.getElementsByClassName('asignSchool');
        for(let i = 0; i < checkAssign.length; i++){
            checkAssign[i].checked = true;
        }
    }else{
        let checkAssign = document.getElementsByClassName('asignSchool');
        for(let i = 0; i < checkAssign.length; i++){
            
            if(schoolsid[i].access == "NO"){
                checkAssign[i].checked = false;
            }
            
        }
    }
}

function changeOrder(event){
    var located = new URLSearchParams(location.search);
    
    var paramsList = {
        offset: 0,
        sessionid: located.get('ssid'),
        status: 0,
        numofrecords: null,
        order: order,
        csv: 0,
        all: 1,
    };
    
    var arrowsUp = document.getElementsByClassName('up');
    var arrowsDown = document.getElementsByClassName('down');
    
    for(let i = 0; i< arrowsUp.length; i++){
        arrowsDown[i].setAttribute('onclick','changeOrder(this)');
        arrowsUp[i].setAttribute('onclick','changeOrder(this)');
        
        arrowsDown[i].style.borderColor = "#FFF";
        arrowsUp[i].style.borderColor = "#FFF";
        arrowsDown[i].style.cursor = "pointer";
        arrowsUp[i].style.cursor = "pointer";
    }
    
    var arrow = document.getElementById(event.id);
    arrow.setAttribute('onclick','');
    arrow.style.cursor = "auto";
    arrow.style.borderColor = "#BBB";
    
    var order= '';
    
    switch(event.id){
        case "codeUp":
            order = "code ASC";
            break;
        case "codeDown":
            order = "code DESC";
            break;
        case "collegeUp":
            order = "name ASC";
            break;
        case "collegeDown":
            order = "name DESC";
            break;
        case "regionUp":
            order = "region ASC";
            break;
        case "regionDown":
            order = "region DESC";
            break;
    }
    
    paramsList.order = order;
    
    var table = document.getElementsByClassName("priviligies")[0].rows;
    var rowCount = table.length;
    
    for(let i = rowCount - 1; i > 0; i--){
        table[i].closest('tr').remove();
    }
    
    callSchools(paramsList);
}