<?php 
    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");
    require '../../hooks/PHPMailer5/PHPMailerAutoload.php';
    
    // parametros obligatorios
    $parmsob = array("email","schoolid");
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(",", $parmsob)));
    }
    
    //Obtenemos los datos de la url y creamos el hash
    $out = new stdClass();
    $email = $_GET["email"];
    $schoolid = $_GET["schoolid"];
    $hash = substr(str_shuffle(str_repeat($x='0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ', ceil(128/strlen($x)) )),1,128);
    
    //Consulta para verificar que el colegio no tiene un email asociado
    $sql =  "SELECT schools.email ".
            "FROM   schools, users " .
            "WHERE schools.code = ".$schoolid." AND schools.id = users.schoolid";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    $row=$rs->fetch_assoc();
    
    if($row["email"] != null){
        badEnd("409", array("msg"=>"Ya este colegio está registrado"));
    }
    
    //Consulta para verificar que el correo no haya sido utilizado antes
    $sql =  "SELECT  *".
        "FROM    users ".
        "WHERE   UPPER(email)='".strtoupper($email)."'";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row= $rs->fetch_assoc();
    
    if($row["email"] != null){
        badEnd("410", array("msg"=>"Ya este correo se encuentra asociado a un colegio!!"));
    }
    
    // Asignacion de hash para school y asignacion de email
    $sql = "UPDATE schools " .
            "SET    hashregister = '".$hash."', email ='".$email."'".
            "WHERE  code = '".$schoolid."' ";
    if (!$db->query($sql)){
        badEnd("500", array("msg"=>$db->error));
    }
    
    //En caso de que no actualice arrojara el error para indicar que no hay resultados
    if ($db->affected_rows == 0){
        badEnd("401", array("sql"=>$sql,"msg"=>"No tenemos ningún colegio registrado con ese id"));
    }
    
    //obtener nombre del colegio
    $sql = "SELECT name FROM schools WHERE code=".$schoolid;
    
    if (!$rs =$db->query($sql)){
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    }
    
    //Ordenamos los datos del correo
    $row = $rs->fetch_assoc();
    $collegename = $row["name"];
    
    $from = "developer@totalsoftware.com.ve";
    $subject = "Registro  - Olimpíadas Recreativas de Matemáticas";
    $subject = '=?UTF-8?B?'.base64_encode($subject).'?=';
            
    $body = "Hola, colegio <b>" . $collegename . "!</b><br/><br/>Para registrarse en el sistema dir&iacute;jase a la direcci&oacute;n indicada a continuaci&oacute;n:<br/><br/>".
            "<a href='".$homeurl."?id=register&sid=registerForm&hash=".$hash."&email=".$email."&college=".urlencode($collegename)."'>http://totalsoftware.la/~ormv/register</a><br/><br/>".
            "Gracias de antemano<br/><br/><b>Olimp&iacute;adas Recreativas  de Matem&aacute;ticas</b>";

    enviarCorreo($from, $email, $subject, $body);
    
    $out->email = $email;
    $out->college = $collegename;
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>