<?php
    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");
    
    //Parametros obligatorios
    $parmsob = array("sessionid","id");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros invalidos " . implode(", ", $parmsob)));
        
    //Inicializamos nuestras variables
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    $idstudent = $_GET["id"];
    
    //Validamos que la session del usuario sea valida
    isSessionValid($db, $sessionid);
    
    //Consultamos los datos del alumno
    $sql = "SELECT pupils.id, pupils.name, ".
    "       pupils.surname, pupils.gender, ".
    "       pupils.birthdate, pupils.level, ".
    "       pupils.section, pupils.ci".
    "       FROM pupils, users ".
    "       WHERE users.sessionid = '".$sessionid."' ".
    "       AND pupils.schoolid = users.schoolid ".
    "       AND pupils.id = ".$idstudent."";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    //Ordenamos los valores
    $row= $rs->fetch_assoc();
    $out->id=$row["id"];
    $out->ci=$row["ci"];
    $out->name=$row["name"];
    $out->surname=$row["surname"];
    $out->gender = new stdClass();
    $out->gender->id=$row["gender"];
    $out->gender->dsc= $row["gender"] == "M" ? "Masculino" : "Femenino";
    $out->birthdate = new stdClass();
    $dateFormat = strtotime($row["birthdate"]);
    $out->birthdate->date = date("Y",$dateFormat).date("m",$dateFormat).date("d",$dateFormat);
    $out->birthdate->formatted = $row["birthdate"];
    $out->level = $row["level"];
    $out->grade = $row["section"];
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>