var registerEnabled = 1;

function validate() {
    var params = {};
    var error = document.getElementById('error');
    var email = document.getElementById('email');
    //Regex para validar el correo
    var rgx = /^[-\w.%+]{1,64}@(?:[A-Z0-9-]{1,63}\.){1,125}[A-Z]{2,63}$/i;
    params.email = email.value;
    params.schoolid = document.getElementById('collegeId').value;
    
    //Validamos el correo
    if (rgx.test(email.value)){
        //Validamos el campo schoolid
        if(params.schoolid !== "") {
            loadScreen();
            callWS("GET", "login/register", params, respx);
            error.innerHTML = "";
        }else{
            error.innerHTML = "C\u00F3digo del colegio no puede estar vac\u00EDo";
        }
    } else {
        error.innerHTML = "Correo electr\u00F3nico inv\u00E1lido";
  }
  
    function respx(status, respText){
        var json = JSON.parse(respText);
        closeLoad();
        if(status == 200) {
            params.college = json.college;
            gotoPage('register','registerMessage',params);
        }else if(status == 409) {
            error.innerHTML = "Ya este colegio se encuentra registrado";
        }else if (status == 401) {
            error.innerHTML = "No tenemos ning\u00FAn colegio registrado con ese c\u00F3digo";
        } else if(status == 410) {
            error.innerHTML = "Ya este correo est\u00E1 asociado a otro colegio";
        }
    }
}

window.onload = function carga() {
    
    //Regresar
    document.getElementById('login').addEventListener("click", function(){
        gotoPage('login','main',{});
    });
    
    //Registrarse
    document.getElementById('register').addEventListener("click", function(){
        if(registerEnabled == 1){
            validate();
        }
    });
    
    getRegisterEnabled();
}

function getRegisterEnabled(){
    let params = {
        id: 6
    }
    loadScreen();
    callWS("GET", "settings/entryregister", params, respx);
    
    //Obtenemos los datos del servicio
    function respx(status, respText){
        var json = JSON.parse(respText);
        closeLoad();
        if (status == 200){
            registerEnabled = parseInt(json.entry.content);
            
            if(registerEnabled == 0){
                gotoPage('login','main',{});
            }
        }else{
            console.log(json.msg);
        }
    }
}