<?php
    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("pupilid","schoolid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));

    $pupilid = (integer) substr($_REQUEST["pupilid"], 0, -2);
    
    $sql =  "SELECT     P.id pupilid, CONCAT(P.name, ' ', P.surname) fullname, " .
            "           S.id, S.name, S.region " .
            "FROM       pupils P " .
            "INNER JOIN schools S " .
            "ON         P.schoolid = S.id " .
            "WHERE      P.status = 1 " .
            "AND        P.id=" . $pupilid . " " .
            "AND        S.id=" . $_REQUEST["schoolid"];
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error, "sql"=>$sql));
    
    $out = new stdClass();
    if ($row = $rs->fetch_assoc()){
        $pupilid = (integer) $row["pupilid"];
        $out->id = $pupilid;
        $out->pupilid = $_REQUEST["pupilid"];
        $out->fullname = $row["fullname"];
        $out->school = array("id"=>(integer)$row["id"],"name"=>$row["name"],"region"=>$row["region"]);
    }else{
        badEnd("401", array("msg"=>"No coincide alumno con el colegio"));
    }

    // tomar datos del examen
    $sql =  "SELECT     T.id, T.ptsoklow, T.ptsokmid, T.ptsokhigh, " .
            "           T.ptsbadlow, T.ptsbadmid, T.ptsbadhigh, " .
            "           date_format(T.testfrom, '%yY%m%d') testfrom, " . 
            "           date_format(T.testfrom, '%d/%m/%Y %h:%i %p') testfromfrm, " . 
            "           date_format(T.testto, '%yY%m%d') testto, " .
            "           date_format(T.testto, '%d/%m/%Y %h:%i %p') testtofrm, " .
            "           IF(NOW()<T.testfrom OR NOW()>T.testto, 0, 1) testenabled, " .
            "           T.ptsblank, T.maxminutes, T.numofquestions " .
            "FROM       pupils P " .
            "INNER JOIN tests T " .
            "ON         P.level=T.level " .
            "WHERE      T.status = 1 " .
            "AND        P.id=" . $pupilid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error, "sql"=>$sql));

    if ($row = $rs->fetch_assoc()){
        $testid = (integer) $row["id"];;
    
        $out->test = new stdClass();
        $out->test->id = (integer) $row["id"];
        $out->test->enabled = new stdClass();
        $out->test->enabled->status = (boolean) $row["testenabled"]=="1";
        $out->test->enabled->from = $row["testfromfrm"];
        $out->test->enabled->to = $row["testtofrm"];
        $out->test->points = new stdClass();
        $out->test->points->ok = new stdClass();
        $out->test->points->ok->low = (integer) $row["ptsoklow"];
        $out->test->points->ok->mid = (integer) $row["ptsokmid"];
        $out->test->points->ok->high = (integer) $row["ptsokhigh"];
        $out->test->points->bad = new stdClass();
        $out->test->points->bad->low = (integer) $row["ptsbadlow"];
        $out->test->points->bad->mid = (integer) $row["ptsbadmid"];
        $out->test->points->bad->high = (integer) $row["ptsbadhigh"];
        $out->test->points->blank = (integer) $row["ptsblank"];
        $out->test->numberofquestions = (integer) $row["numofquestions"];
        $maxminutes = (integer) $row["maxminutes"];
    }else{
        badEnd("401", array("msg"=>"El grado del alumno no tiene ningun examen disponible"));
    }

    if ($out->test->enabled->status){
        // verificar que haya empezado la prueba
        $sql =  "SELECT     testid, datestart, " .
                "           A.q1, A.q2, A.q3, A.q4, A.q5, A.q6, A.q7, A.q8, A.q9, A.q10, " .
                "           A.q11, A.q12, A.q13, A.q14, A.q15, A.q16, A.q17, A.q18, A.q19, A.q20, " .
                "           A.q21, A.q22, A.q23, A.q24, A.q25, A.q26, A.q27, A.q28, A.q29, A.q30, " .
                "           ROUND((UNIX_TIMESTAMP() - UNIX_TIMESTAMP(datestart)) / 60) remmin, " .
                "           IF(A.dateend IS NULL, 0, 1) ended, " .
                "           TIMESTAMPDIFF(MINUTE,A.datestart,IFNULL(A.dateend,DATE_ADD(A.datestart, INTERVAL +T.maxminutes MINUTE))) totalminutes " .
                "FROM       answers A " . 
                "INNER JOIN tests T " .
                "ON         A.testid = T.id " .
                "WHERE      T.status=1 " .
                "AND        A.pupilid=" . $pupilid;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error, "sql"=>$sql));
        $out->test->started = (boolean) ($row = $rs->fetch_assoc());

        //Tiempo maximo de la prueba por si el forn necesita sacar por finalizado - JR
        $out->test->maxminutes = $maxminutes;

        // calculo del tiempo remanente
        if (!$out->test->started){
            $out->test->minutesremain = $maxminutes;
        }else{
            $out->test->minutesremain = $maxminutes - (integer) $row["remmin"];
        }

        // verificar que el tiempo no se haya excedido
        if ($out->test->minutesremain < 0){
            badEnd("403", array("msg"=>"Plazo del examen vencido",
                                "ended"=>(boolean) $row["ended"]==1,
                                "totalminutes"=>(integer)$row["totalminutes"]));
        }

        // si ya estaba iniciada calcular siguiente pregunta
        $nextq = -1;
        if ($out->test->started){
            for ($i=0; $i<$out->test->numberofquestions+1; $i++){
                if ($row["q".($i+1)] == null){
                    $nextq = $i+1;
                    $i = $out->test->numberofquestions;
                }
            }

            // Si esta completamente respondido se devuelven los datos de finalización
            //$out->test->ended = ($out->test->numberofquestions < $nextq || $row["ended"] == 1);
            $out->test->ended = (boolean) $row["ended"] == 1;
            $out->test->totalminutes = (integer) $row["totalminutes"];

            if (!$out->test->ended){
                // obtener siguiente pregunta
                $sql =  "SELECT     Q.ordinal, Q.type qtype, Q.id qid, Q.testid, Q.label qlabel, Q.statement, Q.imagetype qimage, " .
                        "           O.id oid, O.label olabel, O.dsc, O.imagetype oimage, O.ord, Q.backuprequired " .
                        "FROM       questions Q " .
                        "INNER JOIN options O " .
                        "ON         Q.id = O.questionid " .
                        "WHERE      Q.ordinal=" . $nextq . " " .
                        "AND        Q.testid=" . $testid . " " .
                        "ORDER BY   O.ord";
                if (!$rs=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error, "sql"=>$sql));
                
                $first = true;
                while ($row = $rs->fetch_assoc()){
                    if ($first){
                        $first = false;
                        $out->test->questions = new stdClass();
                        $out->test->questions->next = new stdClass();
                        $out->test->questions->next->ordinal = (integer) $row["ordinal"];
                        $out->test->questions->next->type = (integer) $row["qtype"];
                        $out->test->questions->next->backuprequired = (boolean) $row["backuprequired"]==1;
                        $out->test->questions->next->id = (integer) $row["qid"];
                        $out->test->questions->next->label = $row["qlabel"];
                        $out->test->questions->next->statement = $row["statement"];
                        $out->test->questions->next->image = new stdClass();
                        $datatype = nvl($row["qimage"],"");
                        $url = "";
                        if (strlen($datatype)){
                            $type = explode("/",$datatype);
                            if ($type[0]=="image"){
                                $url = "../uploads/tests/".$row["testid"]."/".$row["qid"]."/question.".$type[1];
                                if (!file_exists("../../".$url)){
                                    $datatype = "";
                                    $url = "";
                                }
                            }
                        }
                        $out->test->questions->next->image->type = $datatype;
                        $out->test->questions->next->image->url = $url;
                        $out->test->questions->next->options = array();
                    }
                    $option = new stdClass();
                    $option->id = (integer) $row["oid"];
                    $option->ordinal = (integer) $row["ord"];
                    $option->label = $row["olabel"];
                    $option->dsc = $row["dsc"];
                    $option->image = new stdClass();
                    $datatype = nvl($row["oimage"],"");
                    $url = "";
                    if ($datatype != ""){
                        $type = explode("/",$datatype);
                        if ($type[0]=="image"){
                            $url = "../uploads/tests/".$row["testid"]."/".$row["qid"]."/".$row["oid"].".".$type[1];
                            if (!file_exists("../../".$url)){
                                //$datatype = "";
                                //$url = "";
                            }
                        }
                    }
                    $option->image->url = $url;

                    // buscar respuesta
                    $sql =  "SELECT     id, q" . $out->test->questions->next->ordinal . " answs " .
                            "FROM       answers " .
                            "WHERE      testid=" . $testid . " " .
                            "AND        pupilid=" . $pupilid;
                    if (!$rsansws=$db->query($sql))
                        badEnd("500", array("msg"=>$db->error, "sql"=>$sql));
                    $row2 = $rsansws->fetch_assoc();
                    $out->test->questions->next->answers = nvl($row2["answs"],"");

                    // buscar attachments
                    $out->test->questions->next->attachments = array();
                    $dir = "../../../uploads/answers/" . $row2["id"];
                    if (file_exists($dir)){
                        $files = scandir($dir);
                        foreach ($files as $file){
                            if (!in_array($file,array(".","..")) && substr($file,0,2) == str_pad($out->test->questions->next->ordinal,2,"0",STR_PAD_LEFT)){
                                $out->test->questions->next->attachments[] = array("filename"=>$file, 
                                                                                "url"=>"../uploads/answers/" . $row2["id"] ."/" . $file);
                            }
                        }
                    }
        
                    $out->test->questions->next->options[] = $option;
                }
            }
        }
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>