<?php
    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");    
    require '../../hooks/PHPMailer5/PHPMailerAutoload.php';

    //cantidad de emails
    $cnt=0;
    //Se ubican los examenes que ya finalizaron. (Por tiempo o por completado) Y que no han sido enviados
    $sql =  "SELECT S.* FROM (" .
            "   SELECT     A.id answerid, T.id testid, T.maxminutes, T.numofquestions, A.pupilid, A.emailsent, CONCAT(P.name, ' ', P.surname) fullname, P.email, A.dateend, ".
            "   ROUND((UNIX_TIMESTAMP() - UNIX_TIMESTAMP(A.datestart)) / 60) remmin, ".
            "   IF(A.dateend IS NOT NULL,1, " .
            "      IF((T.maxminutes-ROUND((UNIX_TIMESTAMP() - UNIX_TIMESTAMP(A.datestart)) / 60))<0, 1, 0) " .
            "   ) ended, " .
            "   TIMESTAMPDIFF(MINUTE,A.datestart,IFNULL(A.dateend,NOW())) totalminutes " .
            "   FROM       answers A " .
            "   INNER JOIN tests T ON         A.testid = T.id " .
            "   INNER JOIN pupils P ON P.id = A.pupilid) S " .
            "WHERE emailsent IS NULL AND ended > 0 ";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error, "sql"=>$sql));
    while ($row = $rs->fetch_assoc()){  
        $sql =  "UPDATE     answers A " .
                "SET        emailsent = NOW() " .
                "WHERE      A.id = ".$row['answerid'];
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error, "sql"=>$sql));   

        if($row['email'] !== "" && $row['email']!==null){
            $email = $row['email'];
            
            $subject = "Felicitaciones";
            $fromeMail = "noresponder@totalsoftware.com.ve";
            $footerEmails = "<a href='https://ormve.org'>https://ormve.org</a><br> Totalsoftware de Venezuela &copy;2021. ";

            $endedMsg = "Terminaste tu prueba en ".formatTime($row['totalminutes']);
            if($row['dateend']==null)$endedMsg = "Terminó el tiempo de ".formatTime($row['maxminutes'])." disponible para presentar el examen";
            $body = "<html>".
                    "   <head>".
                    "       <meta http-equiv='Content-Type' content='text/html; charset=utf-8'>".
                    "       <title></title>".
                    "       <link href='https://fonts.googleapis.com/css?family=Montserrat:300,400,500,600,700,800,900&display=swap' rel='stylesheet'>".
                    "   </head>".
                    "   <body>".
                    "       <div style='background-color: #ffffff;padding: 15px;'>".
                    "           <img style='margin: auto; display: block;margin-bottom:10px;' width='200' height='145' src='".$homeurl."/img/logo.png'/>".
                    "           <div style='margin: auto; display: block;background-color: #ffffff;width: 60%;padding:30px;'>".
                    "               <div style='width: 90%;margin-left: auto;margin-right: auto;text-align: center;margin-bottom:1vh;'>".
                    "                   <div style='color: #236abd;font-size: 14px;font-weight: 700;'>¡Felicitaciones!</div>".
                    "               </div>".        
                    "               <div style='width: 90%;margin-left: auto;margin-right: auto;text-align: center;margin-bottom:20px'>".
                    "                   <div style='color: #236abd;font-size: 17px;font-weight: 700;'>".$row['fullname']."</div>".
                    "               </div>".
                    "               <div style='font-weight:bold;margin-bottom: 20px;margin-left: auto;margin-right: auto;width: 90%;color: #47464F;font-size: 14px;text-align: center;'>".
                    $endedMsg.                        
                    "               </div>" .
                    "               <div style='font-weight:500;margin-bottom:15px;margin-left: auto;margin-right: auto;width: 90%;color: #47464F;font-size: 14px;text-align: center;'>".
                    "                   Gracias por participar en la Edición 29 de la Olimpiada Recreativa de Matemática.".
                    "               </div>".
                    "           </div>".
                    "           <p style='color: #767E93;text-align:center;'>".$footerEmails."</p>".
                    "       </div>".
                    "   </body>".
                    "</html>";                  
                    
            enviarCorreo($fromeMail, strtolower($email), $subject, $body);
            $cnt=$cnt+1;
        }
    }

    $out = new stdClass;
    $out->emailsSended = $cnt;
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
