<?php
    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("pupilid","testid","imagename");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));

    $pupilid = (integer) substr($_REQUEST["pupilid"], 0, -2);
    $imagename = $_REQUEST["imagename"];
    $testid = (integer) $_REQUEST["testid"];
    $out = new stdClass();

    // obtener id de la respuesta
    $sql =  "SELECT     A.id " .
            "FROM       answers A " .
            "INNER JOIN tests T " .
            "ON         A.testid=T.id " .
            "WHERE      A.pupilid='" . $pupilid . "' " .
            "AND        T.status=1 " .
            "AND        T.id = " . $testid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error, "sql"=>$sql));
    if (!$row = $rs->fetch_assoc())
        badEnd("404", array("msg"=>"Combinacion Prueba / Usuario inválida"));

    $filetodel = "../../../uploads/answers/" . $row["id"] . "/" . $imagename;
    if (file_exists($filetodel)){
        if (!unlink($filetodel))
            badEnd("404", array("msg"=>"Imposible borrar el archivo " . $filetodel));
    }else{
        badEnd("404", array("msg"=>"No se consiguio el archivo " . $filetodel));
    }
    
    // buscar attachments
    $out->attachments = array();
    $dir = "../../../uploads/answers/" . $row["id"];
    if (file_exists($dir)){
        $files = scandir($dir);
        foreach ($files as $file){
            if (!in_array($file,array(".","..")) && substr($file,0,2) == substr($imagename,0,2)){
                $out->attachments[] = array("filename"=>$file, 
                                            "url"=>"../uploads/answers/" . $row["id"] ."/" . $file);
            }
        }
    }

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
